/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.CageTrapBlockEntity;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedIronBarsBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPaneBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.EntitySelectionContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.logging.log4j.util.TriConsumer;

public class CageTrapBlock
extends DisguisableBlock {
    public static final BooleanProperty DEACTIVATED = BooleanProperty.func_177716_a((String)"deactivated");

    public CageTrapBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof CageTrapBlockEntity) {
            CageTrapBlockEntity te = (CageTrapBlockEntity)tile;
            if (ctx instanceof EntitySelectionContext) {
                EntitySelectionContext esc = (EntitySelectionContext)ctx;
                Entity entity = esc.getEntity();
                if (entity instanceof PlayerEntity && (te.getOwner().isOwner((PlayerEntity)entity) || ModuleUtils.isAllowed((IModuleInventory)te, entity))) {
                    return this.getCorrectShape(state, world, pos, ctx, te);
                }
                if (entity instanceof MobEntity && !((Boolean)state.func_177229_b((Property)DEACTIVATED)).booleanValue()) {
                    return te.capturesMobs() ? VoxelShapes.func_197880_a() : this.getCorrectShape(state, world, pos, ctx, te);
                }
                if (entity instanceof ItemEntity) {
                    return this.getCorrectShape(state, world, pos, ctx, te);
                }
            }
            return (Boolean)state.func_177229_b((Property)DEACTIVATED) != false ? this.getCorrectShape(state, world, pos, ctx, te) : VoxelShapes.func_197880_a();
        }
        return VoxelShapes.func_197880_a();
    }

    private VoxelShape getCorrectShape(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx, DisguisableBlockEntity disguisableTe) {
        ItemStack moduleStack = disguisableTe.getModule(ModuleType.DISGUISE);
        if (!moduleStack.func_190926_b() && ((ModuleItem)moduleStack.func_77973_b()).getBlockAddon(moduleStack.func_77978_p()) != null) {
            return super.func_220071_b(state, world, pos, ctx);
        }
        return VoxelShapes.func_197868_b();
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K) {
            CageTrapBlockEntity tileEntity = (CageTrapBlockEntity)world.func_175625_s(pos);
            boolean isPlayer = entity instanceof PlayerEntity;
            if (isPlayer || entity instanceof MobEntity && tileEntity.capturesMobs()) {
                if (isPlayer && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner((PlayerEntity)entity)) {
                    return;
                }
                if (((Boolean)state.func_177229_b((Property)DEACTIVATED)).booleanValue()) {
                    return;
                }
                BlockPos topMiddle = pos.func_177981_b(4);
                String ownerName = ((IOwnable)world.func_175625_s(pos)).getOwner().getName();
                BlockModifier placer = new BlockModifier(world, new BlockPos.Mutable().func_189533_g((Vector3i)pos), tileEntity.getOwner());
                placer.loop((TriConsumer<World, BlockPos.Mutable, Owner>)((TriConsumer)(w, p, o) -> {
                    if (w.func_175623_d((BlockPos)p)) {
                        if (p.equals((Object)topMiddle)) {
                            w.func_175656_a((BlockPos)p, ((Block)SCContent.HORIZONTAL_REINFORCED_IRON_BARS.get()).func_176223_P());
                        } else {
                            w.func_175656_a((BlockPos)p, ((ReinforcedPaneBlock)SCContent.REINFORCED_IRON_BARS.get()).getStateForPlacement((IBlockReader)w, (BlockPos)p));
                        }
                    }
                }));
                placer.loop((TriConsumer<World, BlockPos.Mutable, Owner>)((TriConsumer)(w, p, o) -> {
                    TileEntity te = w.func_175625_s((BlockPos)p);
                    if (te instanceof IOwnable) {
                        ((IOwnable)te).setOwner(o.getUUID(), o.getName());
                    }
                    if (te instanceof ReinforcedIronBarsBlockEntity) {
                        ((ReinforcedIronBarsBlockEntity)te).setCanDrop(false);
                    }
                }));
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
                world.func_184133_a(null, pos, SoundEvents.field_187698_i, SoundCategory.BLOCKS, 3.0f, 1.0f);
                if (isPlayer && PlayerUtils.isPlayerOnline(ownerName)) {
                    PlayerUtils.sendMessageToPlayer(ownerName, (IFormattableTextComponent)Utils.localize(((Block)SCContent.CAGE_TRAP.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:cageTrap.captured", ((PlayerEntity)entity).func_200200_C_(), Utils.getFormattedCoordinates(pos)), TextFormatting.BLACK);
                }
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == SCContent.WIRE_CUTTERS.get()) {
            if (!((Boolean)state.func_177229_b((Property)DEACTIVATED)).booleanValue()) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
                if (!player.func_184812_l_()) {
                    stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
                }
                world.func_184133_a(null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return ActionResultType.SUCCESS;
            }
        } else if (stack.func_77973_b() == Items.field_151137_ax && ((Boolean)state.func_177229_b((Property)DEACTIVATED)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            world.func_184133_a(null, pos, SoundEvents.field_187907_gg, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j());
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity player) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DEACTIVATED});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CageTrapBlockEntity();
    }

    public static class BlockModifier {
        private World world;
        private BlockPos.Mutable pos;
        private BlockPos origin;
        private Owner owner;

        public BlockModifier(World world, BlockPos.Mutable origin, Owner owner) {
            this.world = world;
            this.pos = origin.func_196234_d(-1, 1, -1);
            this.origin = origin.func_185334_h();
            this.owner = owner;
        }

        public void loop(TriConsumer<World, BlockPos.Mutable, Owner> ifTrue) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 3; ++x) {
                    for (int z = 0; z < 3; ++z) {
                        if (x != 1 || z != 1 || y == 3) {
                            ifTrue.accept((Object)this.world, (Object)this.pos, (Object)this.owner);
                        }
                        this.pos.func_196234_d(0, 0, 1);
                    }
                    this.pos.func_196234_d(1, 0, -3);
                }
                this.pos.func_196234_d(-3, 1, 0);
            }
            this.pos.func_189533_g((Vector3i)this.origin);
        }
    }
}

