/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.KeyPanelBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class KeyPanelBlock
extends OwnableBlock
implements IWaterLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.field_208158_K;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final VoxelShape FLOOR_NS = Block.func_208617_a((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)1.0, (double)15.0);
    public static final VoxelShape FLOOR_EW = Block.func_208617_a((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)14.0);
    public static final VoxelShape CEILING_NS = Block.func_208617_a((double)2.0, (double)15.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0);
    public static final VoxelShape CEILING_EW = Block.func_208617_a((double)1.0, (double)15.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0);
    public static final VoxelShape WALL_N = Block.func_208617_a((double)2.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0, (double)16.0);
    public static final VoxelShape WALL_E = Block.func_208617_a((double)0.0, (double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)14.0);
    public static final VoxelShape WALL_S = Block.func_208617_a((double)2.0, (double)1.0, (double)0.0, (double)14.0, (double)15.0, (double)1.0);
    public static final VoxelShape WALL_W = Block.func_208617_a((double)15.0, (double)1.0, (double)2.0, (double)16.0, (double)15.0, (double)14.0);

    public KeyPanelBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(FACE, (Comparable)AttachFace.WALL)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        switch ((AttachFace)state.func_177229_b(FACE)) {
            case FLOOR: {
                switch ((Direction)state.func_177229_b((Property)FACING)) {
                    case NORTH: {
                        return FLOOR_NS;
                    }
                    case EAST: {
                        return FLOOR_EW;
                    }
                    case SOUTH: {
                        return FLOOR_NS;
                    }
                    case WEST: {
                        return FLOOR_EW;
                    }
                }
                return VoxelShapes.func_197880_a();
            }
            case CEILING: {
                switch ((Direction)state.func_177229_b((Property)FACING)) {
                    case NORTH: {
                        return CEILING_NS;
                    }
                    case EAST: {
                        return CEILING_EW;
                    }
                    case SOUTH: {
                        return CEILING_NS;
                    }
                    case WEST: {
                        return CEILING_EW;
                    }
                }
                return VoxelShapes.func_197880_a();
            }
            case WALL: {
                switch ((Direction)state.func_177229_b((Property)FACING)) {
                    case NORTH: {
                        return WALL_N;
                    }
                    case EAST: {
                        return WALL_E;
                    }
                    case SOUTH: {
                        return WALL_S;
                    }
                    case WEST: {
                        return WALL_W;
                    }
                }
                return VoxelShapes.func_197880_a();
            }
        }
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return VoxelShapes.func_197880_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            return ActionResultType.PASS;
        }
        KeyPanelBlockEntity te = (KeyPanelBlockEntity)world.func_175625_s(pos);
        if (ModuleUtils.isDenied(te, (Entity)player)) {
            if (te.sendsMessages()) {
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
            }
        } else if (ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
            if (te.sendsMessages()) {
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), TextFormatting.GREEN);
            }
            this.activate(state, world, pos, te.getSignalLength());
        } else if (!PlayerUtils.isHoldingItem(player, SCContent.CODEBREAKER, hand)) {
            te.openPasswordGUI(player);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        BlockUtils.updateIndirectNeighbors((World)world, pos, this, KeyPanelBlock.getConnectedDirection(state).func_176734_d());
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return (Boolean)state.func_177229_b((Property)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return (Boolean)state.func_177229_b((Property)POWERED) != false && KeyPanelBlock.getConnectedDirection(state) == side ? 15 : 0;
    }

    public boolean func_196260_a(BlockState state, IWorldReader level, BlockPos pos) {
        return KeyPanelBlock.canAttach(level, pos, KeyPanelBlock.getConnectedDirection(state).func_176734_d());
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        for (Direction direction : ctx.func_196009_e()) {
            BlockState state = direction.func_176740_k() == Direction.Axis.Y ? (BlockState)((BlockState)this.func_176223_P().func_206870_a(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f()) : (BlockState)((BlockState)this.func_176223_P().func_206870_a(FACE, (Comparable)AttachFace.WALL)).func_206870_a((Property)FACING, (Comparable)direction.func_176734_d());
            if (!state.func_196955_c((IWorldReader)world, pos)) continue;
            return (BlockState)((BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return KeyPanelBlock.getConnectedDirection(state).func_176734_d() == facing && !state.func_196955_c((IWorldReader)world, pos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, world, pos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POWERED, FACE, WATERLOGGED});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new KeyPanelBlockEntity();
    }

    public void activate(BlockState state, World world, BlockPos pos, int signalLength) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)));
        BlockUtils.updateIndirectNeighbors(world, pos, this, KeyPanelBlock.getConnectedDirection(state).func_176734_d());
        world.func_205220_G_().func_205360_a(pos, (Object)this, signalLength);
    }

    protected static Direction getConnectedDirection(BlockState state) {
        switch ((AttachFace)state.func_177229_b(FACE)) {
            case CEILING: {
                return Direction.DOWN;
            }
            case FLOOR: {
                return Direction.UP;
            }
        }
        return (Direction)state.func_177229_b((Property)FACING);
    }

    public static boolean canAttach(IWorldReader world, BlockPos pos, Direction direction) {
        BlockPos relativePos = pos.func_177972_a(direction);
        return world.func_180495_p(relativePos).func_224755_d((IBlockReader)world, relativePos, direction.func_176734_d());
    }
}

