/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Optional;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class KeypadChestBlock
extends ChestBlock {
    private static final TileEntityMerger.ICallback<ChestTileEntity, Optional<INamedContainerProvider>> CONTAINER_MERGER = new TileEntityMerger.ICallback<ChestTileEntity, Optional<INamedContainerProvider>>(){

        public Optional<INamedContainerProvider> acceptDouble(final ChestTileEntity chest1, final ChestTileEntity chest2) {
            DoubleSidedInventory chestInventory = new DoubleSidedInventory((IInventory)chest1, (IInventory)chest2);
            return Optional.of(new INamedContainerProvider((IInventory)chestInventory){
                final /* synthetic */ IInventory val$chestInventory;
                {
                    this.val$chestInventory = iInventory;
                }

                public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                    if (chest1.func_213904_e(player) && chest2.func_213904_e(player)) {
                        chest1.func_184281_d(inventory.field_70458_d);
                        chest2.func_184281_d(inventory.field_70458_d);
                        return ChestContainer.func_216984_b((int)id, (PlayerInventory)inventory, (IInventory)this.val$chestInventory);
                    }
                    return null;
                }

                public ITextComponent func_145748_c_() {
                    if (chest1.func_145818_k_()) {
                        return chest1.func_145748_c_();
                    }
                    return chest2.func_145818_k_() ? chest2.func_145748_c_() : Utils.localize("block.securitycraft.keypad_chest_double", new Object[0]);
                }
            });
        }

        public Optional<INamedContainerProvider> acceptSingle(ChestTileEntity te) {
            return Optional.of(te);
        }

        public Optional<INamedContainerProvider> acceptNone() {
            return Optional.empty();
        }
    };

    public KeypadChestBlock(AbstractBlock.Properties properties) {
        super(properties, () -> SCContent.beTypeKeypadChest);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K && !KeypadChestBlock.isBlocked(world, pos)) {
            KeypadChestBlockEntity te = (KeypadChestBlockEntity)world.func_175625_s(pos);
            if (ModuleUtils.isDenied(te, (Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
                }
            } else if (ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), TextFormatting.GREEN);
                }
                this.activate(state, world, pos, player);
            } else if (!PlayerUtils.isHoldingItem(player, SCContent.CODEBREAKER, hand)) {
                te.openPasswordGUI(player);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void activate(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        ChestBlock block;
        INamedContainerProvider containerProvider;
        if (!world.field_72995_K && (containerProvider = (block = (ChestBlock)state.func_177230_c()).func_220052_b(state, world, pos)) != null) {
            player.func_213829_a(containerProvider);
            player.func_71029_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188063_ac));
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        boolean isPlayer = entity instanceof PlayerEntity;
        if (isPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)entity));
            if (state.func_177229_b((Property)field_196314_b) != ChestType.SINGLE) {
                KeypadChestBlockEntity thisTe = (KeypadChestBlockEntity)world.func_175625_s(pos);
                TileEntity otherTe = world.func_175625_s(pos.func_177972_a(KeypadChestBlock.func_196311_i((BlockState)state)));
                if (otherTe instanceof KeypadChestBlockEntity && thisTe.getOwner().owns((KeypadChestBlockEntity)otherTe)) {
                    thisTe.setPassword(((KeypadChestBlockEntity)otherTe).getPassword());
                }
            }
        }
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof KeypadChestBlockEntity) {
            return ((KeypadChestBlockEntity)te).hasModule(ModuleType.REDSTONE) ? MathHelper.func_76125_a((int)((KeypadChestBlockEntity)te).getNumPlayersUsing(), (int)0, (int)15) : 0;
        }
        return 0;
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return side == Direction.UP ? state.func_185911_a(world, pos, side) : 0;
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof KeypadChestBlockEntity) {
            ((KeypadChestBlockEntity)tileEntity).func_145836_u();
        }
    }

    public INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        return ((Optional)this.func_225536_a_(state, world, pos, false).apply(CONTAINER_MERGER)).orElse(null);
    }

    public TileEntity func_196283_a_(IBlockReader reader) {
        return new KeypadChestBlockEntity();
    }

    public static boolean isBlocked(World world, BlockPos pos) {
        return KeypadChestBlock.isBelowSolidBlock(world, pos);
    }

    private static boolean isBelowSolidBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).func_215686_e((IBlockReader)world, pos.func_177984_a());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)field_176459_a, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)field_176459_a)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)field_176459_a)));
    }

    public static class Convertible
    implements IPasswordConvertible {
        @Override
        public Block getOriginalBlock() {
            return Blocks.field_150486_ae;
        }

        @Override
        public boolean convert(PlayerEntity player, World world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            Direction facing = (Direction)state.func_177229_b((Property)ChestBlock.field_176459_a);
            ChestType type = (ChestType)state.func_177229_b((Property)ChestBlock.field_196314_b);
            this.convertChest(player, world, pos, facing, type);
            if (type != ChestType.SINGLE) {
                BlockPos newPos = pos.func_177972_a(ChestBlock.func_196311_i((BlockState)state));
                BlockState newState = world.func_180495_p(newPos);
                Direction newFacing = (Direction)newState.func_177229_b((Property)ChestBlock.field_176459_a);
                ChestType newType = (ChestType)newState.func_177229_b((Property)ChestBlock.field_196314_b);
                this.convertChest(player, world, newPos, newFacing, newType);
            }
            return true;
        }

        private void convertChest(PlayerEntity player, World world, BlockPos pos, Direction facing, ChestType type) {
            ChestTileEntity chest = (ChestTileEntity)world.func_175625_s(pos);
            chest.func_184281_d(player);
            CompoundNBT tag = chest.func_189515_b(new CompoundNBT());
            chest.func_174888_l();
            world.func_175656_a(pos, (BlockState)((BlockState)((Block)SCContent.KEYPAD_CHEST.get()).func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)facing)).func_206870_a((Property)ChestBlock.field_196314_b, (Comparable)type));
            ((ChestTileEntity)world.func_175625_s(pos)).func_230337_a_(world.func_180495_p(pos), tag);
            ((IOwnable)world.func_175625_s(pos)).setOwner(player.func_110124_au().toString(), player.func_200200_C_().getString());
        }
    }
}

