/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Iterator;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.fml.network.PacketDistributor;

public class SecurityCameraBlock
extends OwnableBlock {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", facing -> facing != Direction.UP);
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty BEING_VIEWED = BooleanProperty.func_177716_a((String)"being_viewed");
    private static final VoxelShape SHAPE_SOUTH = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.275f, 0.25, 0.0, (double)0.7f, (double)0.8f, (double)0.85f));
    private static final VoxelShape SHAPE_NORTH = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.275f, 0.25, (double)0.15f, (double)0.7f, (double)0.8f, 1.0));
    private static final VoxelShape SHAPE_WEST = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.125, 0.25, (double)0.275f, 1.0, (double)0.8f, (double)0.725f));
    private static final VoxelShape SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.25, (double)0.275f, (double)0.85f, (double)0.8f, (double)0.725f));
    private static final VoxelShape SHAPE_DOWN = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)15.0, (double)5.0, (double)9.0, (double)16.0, (double)11.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)15.0, (double)6.0, (double)7.0, (double)16.0, (double)10.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)15.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)9.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)10.0, (double)15.0, (double)7.0, (double)11.0, (double)16.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)14.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0))))));

    public SecurityCameraBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BEING_VIEWED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220071_b(BlockState blockState, IBlockReader access, BlockPos pos, ISelectionContext ctx) {
        return VoxelShapes.func_197880_a();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return state.func_177229_b((Property)FACING) == Direction.DOWN ? BlockRenderType.MODEL : BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        world.func_195593_d(pos.func_177978_c(), world.func_180495_p(pos).func_177230_c());
        world.func_195593_d(pos.func_177968_d(), world.func_180495_p(pos).func_177230_c());
        world.func_195593_d(pos.func_177974_f(), world.func_180495_p(pos).func_177230_c());
        world.func_195593_d(pos.func_177976_e(), world.func_180495_p(pos).func_177230_c());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext ctx) {
        Direction dir = (Direction)state.func_177229_b((Property)FACING);
        if (dir == Direction.SOUTH) {
            return SHAPE_SOUTH;
        }
        if (dir == Direction.NORTH) {
            return SHAPE_NORTH;
        }
        if (dir == Direction.WEST) {
            return SHAPE_WEST;
        }
        if (dir == Direction.DOWN) {
            return SHAPE_DOWN;
        }
        return SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return ctx.func_196000_l() != Direction.UP ? this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j()) : null;
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity placer) {
        BlockState state;
        block1: {
            Direction newFacing;
            state = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing);
            if (this.func_196260_a(state, (IWorldReader)world, pos)) break block1;
            Iterator iterator = Direction.Plane.HORIZONTAL.iterator();
            while (iterator.hasNext() && !this.func_196260_a(state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)(newFacing = (Direction)iterator.next())), (IWorldReader)world, pos)) {
            }
        }
        return state;
    }

    public void mountCamera(World world, BlockPos pos, PlayerEntity player) {
        if (!world.field_72995_K) {
            ServerWorld serverWorld = (ServerWorld)world;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            SectionPos chunkPos = SectionPos.func_218167_a((BlockPos)pos);
            int viewDistance = serverPlayer.field_71133_b.func_184103_al().func_72395_o();
            TileEntity te = world.func_175625_s(pos);
            SecurityCamera dummyEntity = serverPlayer.func_175398_C() instanceof SecurityCamera ? new SecurityCamera(world, pos, (SecurityCamera)serverPlayer.func_175398_C()) : new SecurityCamera(world, pos);
            world.func_217376_c((Entity)dummyEntity);
            for (int x = chunkPos.func_177958_n() - viewDistance; x <= chunkPos.func_177958_n() + viewDistance; ++x) {
                for (int z = chunkPos.func_177952_p() - viewDistance; z <= chunkPos.func_177952_p() + viewDistance; ++z) {
                    ForgeChunkManager.forceChunk((ServerWorld)serverWorld, (String)"securitycraft", (Entity)dummyEntity, (int)x, (int)z, (boolean)true, (boolean)false);
                }
            }
            serverPlayer.field_175401_bS = dummyEntity;
            SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SetCameraView(dummyEntity));
            if (te instanceof SecurityCameraBlockEntity) {
                ((SecurityCameraBlockEntity)te).startViewing();
            }
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        return BlockUtils.isSideSolid(world, pos.func_177972_a(facing.func_176734_d()), facing);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        if (((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue() && ((IModuleInventory)world.func_175625_s(pos)).hasModule(ModuleType.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        if (((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue() && ((IModuleInventory)world.func_175625_s(pos)).hasModule(ModuleType.REDSTONE) && blockState.func_177229_b((Property)FACING) == side) {
            return 15;
        }
        return 0;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        if (!this.func_196260_a(world.func_180495_p(pos), (IWorldReader)world, pos) && !this.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POWERED, BEING_VIEWED});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SecurityCameraBlockEntity();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.func_176740_k() != Direction.Axis.Z) break;
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)facing.func_176734_d());
            }
            case FRONT_BACK: {
                if (facing.func_176740_k() != Direction.Axis.X) break;
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)facing.func_176734_d());
            }
        }
        return state;
    }
}

