/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.stream.Stream;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.inventory.GenericBEMenu;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class TrophySystemBlock
extends DisguisableBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.func_208617_a((double)6.5, (double)0.0, (double)12.0, (double)9.5, (double)1.5, (double)15.0), Block.func_208617_a((double)5.5, (double)7.0, (double)5.5, (double)10.5, (double)11.0, (double)10.5), Block.func_208617_a((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0), Block.func_208617_a((double)6.5, (double)12.5, (double)6.5, (double)9.5, (double)15.0, (double)9.5), Block.func_208617_a((double)7.0, (double)14.5, (double)7.0, (double)9.0, (double)15.5, (double)9.0), Block.func_208617_a((double)7.25, (double)9.0, (double)7.25, (double)8.75, (double)12.0, (double)8.75), Block.func_208617_a((double)1.0, (double)0.0, (double)6.5, (double)4.0, (double)1.5, (double)9.5), Block.func_208617_a((double)12.0, (double)0.0, (double)6.5, (double)15.0, (double)1.5, (double)9.5), Block.func_208617_a((double)6.5, (double)0.0, (double)1.0, (double)9.5, (double)1.5, (double)4.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).orElse(VoxelShapes.func_197868_b());

    public TrophySystemBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return BlockUtils.isSideSolid(world, pos.func_177977_b(), Direction.UP);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, final World world, final BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(player)) {
            if (!world.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericBEMenu(SCContent.mTypeTrophySystem, windowId, world, pos);
                    }

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent(TrophySystemBlock.this.func_149739_a());
                    }
                }, (BlockPos)pos);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.func_177230_c() != this) {
            return disguisedState.func_215700_a(world, pos, ctx);
        }
        return SHAPE;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TrophySystemBlockEntity();
    }
}

