/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.AllowlistOnlyBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeverBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedLeverBlock
extends LeverBlock
implements IReinforcedBlock {
    public ReinforcedLeverBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (this.isAllowedToPress(world, pos, (AllowlistOnlyBlockEntity)world.func_175625_s(pos), player)) {
            return super.func_225533_a_(state, world, pos, player, hand, result);
        }
        return ActionResultType.FAIL;
    }

    public boolean isAllowedToPress(World world, BlockPos pos, AllowlistOnlyBlockEntity te, PlayerEntity entity) {
        return te.getOwner().isOwner(entity) || ModuleUtils.isAllowed((IModuleInventory)te, (Entity)entity);
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.field_150442_at;
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196366_M, vanillaState.func_177229_b((Property)field_196366_M))).func_206870_a((Property)field_185512_D, vanillaState.func_177229_b((Property)field_185512_D))).func_206870_a((Property)field_176359_b, vanillaState.func_177229_b((Property)field_176359_b));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)placer));
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new AllowlistOnlyBlockEntity();
    }
}

