/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.PaneBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedPaneBlock
extends PaneBlock
implements IReinforcedBlock {
    private final Block vanillaBlock;

    public ReinforcedPaneBlock(AbstractBlock.Properties properties, Block vB) {
        super(properties);
        this.vanillaBlock = vB;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getStateForPlacement((IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState getStateForPlacement(IBlockReader world, BlockPos pos) {
        FluidState fluidState = world.func_204610_c(pos);
        BlockPos northPos = pos.func_177978_c();
        BlockPos southPos = pos.func_177968_d();
        BlockPos westPos = pos.func_177976_e();
        BlockPos eastPos = pos.func_177974_f();
        BlockState northState = world.func_180495_p(northPos);
        BlockState southState = world.func_180495_p(southPos);
        BlockState westState = world.func_180495_p(westPos);
        BlockState eastState = world.func_180495_p(eastPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196409_a, (Comparable)Boolean.valueOf(this.func_220112_a(northState, northState.func_224755_d(world, northPos, Direction.SOUTH))))).func_206870_a((Property)field_196413_c, (Comparable)Boolean.valueOf(this.func_220112_a(southState, southState.func_224755_d(world, southPos, Direction.NORTH))))).func_206870_a((Property)field_196414_y, (Comparable)Boolean.valueOf(this.func_220112_a(westState, westState.func_224755_d(world, westPos, Direction.EAST))))).func_206870_a((Property)field_196411_b, (Comparable)Boolean.valueOf(this.func_220112_a(eastState, eastState.func_224755_d(world, eastPos, Direction.WEST))))).func_206870_a((Property)field_204514_u, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlock;
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196409_a, vanillaState.func_177229_b((Property)PaneBlock.field_196409_a))).func_206870_a((Property)field_196411_b, vanillaState.func_177229_b((Property)PaneBlock.field_196411_b))).func_206870_a((Property)field_196414_y, vanillaState.func_177229_b((Property)PaneBlock.field_196414_y))).func_206870_a((Property)field_196413_c, vanillaState.func_177229_b((Property)PaneBlock.field_196413_c))).func_206870_a((Property)field_204514_u, vanillaState.func_177229_b((Property)PaneBlock.field_204514_u));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)placer));
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new OwnableBlockEntity();
    }
}

