/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.jei;

import java.util.Collection;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.AbstractKeypadFurnaceBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.compat.jei.ReinforcerRecipe;
import net.geforcemods.securitycraft.compat.jei.SecurityCraftToVanillaCategory;
import net.geforcemods.securitycraft.compat.jei.SlotMover;
import net.geforcemods.securitycraft.compat.jei.VanillaToSecurityCraftCategory;
import net.geforcemods.securitycraft.screen.CustomizeBlockScreen;
import net.geforcemods.securitycraft.screen.DisguiseModuleScreen;
import net.geforcemods.securitycraft.screen.ProjectorScreen;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class SCJEIPlugin
implements IModPlugin {
    public static final ResourceLocation VTS_ID = new ResourceLocation("securitycraft", "vanilla_to_securitycraft");
    public static final ResourceLocation STV_ID = new ResourceLocation("securitycraft", "securitycraft_to_vanilla");

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)SCContent.ADMIN_TOOL.get()), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe.admin_tool"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)SCContent.KEYPAD.get()), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe." + ((Block)SCContent.KEYPAD.get()).getRegistryName().func_110623_a()});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)SCContent.KEYPAD_CHEST.get()), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe." + ((Block)SCContent.KEYPAD_CHEST.get()).getRegistryName().func_110623_a()});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)SCContent.KEYPAD_FURNACE.get()), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe." + ((AbstractKeypadFurnaceBlock)SCContent.KEYPAD_FURNACE.get()).getRegistryName().func_110623_a()});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)SCContent.KEYPAD_SMOKER.get()), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe." + ((AbstractKeypadFurnaceBlock)SCContent.KEYPAD_SMOKER.get()).getRegistryName().func_110623_a()});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)SCContent.KEYPAD_BLAST_FURNACE.get()), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe." + ((AbstractKeypadFurnaceBlock)SCContent.KEYPAD_BLAST_FURNACE.get()).getRegistryName().func_110623_a()});
        registration.addRecipes((Collection)IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.entrySet().stream().filter(entry -> ((Block)entry.getKey()).func_199767_j() != Items.field_190931_a && ((Block)entry.getValue()).func_199767_j() != Items.field_190931_a).map(entry -> new ReinforcerRecipe((Block)entry.getKey(), (Block)entry.getValue())).collect(Collectors.toList()), VTS_ID);
        registration.addRecipes((Collection)IReinforcedBlock.SECURITYCRAFT_TO_VANILLA.entrySet().stream().filter(entry -> ((Block)entry.getKey()).func_199767_j() != Items.field_190931_a && ((Block)entry.getValue()).func_199767_j() != Items.field_190931_a).map(entry -> new ReinforcerRecipe((Block)entry.getValue(), (Block)entry.getKey())).collect(Collectors.toList()), STV_ID);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new VanillaToSecurityCraftCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SecurityCraftToVanillaCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SCContent.KEYPAD_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SCContent.KEYPAD_SMOKER.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.SMOKING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SCContent.KEYPAD_BLAST_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.BLASTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get()), new ResourceLocation[]{VTS_ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_2.get()), new ResourceLocation[]{VTS_ID, STV_ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get()), new ResourceLocation[]{VTS_ID, STV_ID});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CustomizeBlockScreen.class, new SlotMover());
        registration.addGuiContainerHandler(DisguiseModuleScreen.class, new SlotMover());
        registration.addGuiContainerHandler(ProjectorScreen.class, new SlotMover());
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("securitycraft", "securitycraft");
    }
}

