/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.server.DismountCamera;
import net.minecraft.block.BlockState;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.SectionPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class CameraController {
    public static PointOfView previousCameraType;
    private static ClientChunkProvider.ChunkArray cameraStorage;
    private static boolean wasUpPressed;
    private static boolean wasDownPressed;
    private static boolean wasLeftPressed;
    private static boolean wasRightPressed;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Entity renderViewEntity = Minecraft.func_71410_x().field_175622_Z;
        if (renderViewEntity instanceof SecurityCamera) {
            SecurityCamera cam = (SecurityCamera)renderViewEntity;
            GameSettings options = Minecraft.func_71410_x().field_71474_y;
            if (event.phase == TickEvent.Phase.START) {
                wasUpPressed = options.field_74351_w.func_151470_d();
                if (wasUpPressed) {
                    options.field_74351_w.func_225593_a_(false);
                }
                if (wasDownPressed = options.field_74368_y.func_151470_d()) {
                    options.field_74368_y.func_225593_a_(false);
                }
                if (wasLeftPressed = options.field_74370_x.func_151470_d()) {
                    options.field_74370_x.func_225593_a_(false);
                }
                if (wasRightPressed = options.field_74366_z.func_151470_d()) {
                    options.field_74366_z.func_225593_a_(false);
                }
                if (options.field_228046_af_.func_151470_d()) {
                    CameraController.dismount();
                    options.field_228046_af_.func_225593_a_(false);
                }
            } else if (event.phase == TickEvent.Phase.END) {
                if (wasUpPressed) {
                    CameraController.moveViewUp(cam);
                    options.field_74351_w.func_225593_a_(true);
                }
                if (wasDownPressed) {
                    CameraController.moveViewDown(cam);
                    options.field_74368_y.func_225593_a_(true);
                }
                if (wasLeftPressed) {
                    CameraController.moveViewHorizontally(cam, cam.field_70177_z, cam.field_70177_z - (float)cam.cameraSpeed * cam.zoomAmount);
                    options.field_74370_x.func_225593_a_(true);
                }
                if (wasRightPressed) {
                    CameraController.moveViewHorizontally(cam, cam.field_70177_z, cam.field_70177_z + (float)cam.cameraSpeed * cam.zoomAmount);
                    options.field_74366_z.func_225593_a_(true);
                }
                if (KeyBindings.cameraZoomIn.func_151470_d()) {
                    CameraController.zoomIn(cam);
                } else if (KeyBindings.cameraZoomOut.func_151470_d()) {
                    CameraController.zoomOut(cam);
                } else {
                    cam.zooming = false;
                }
                if (KeyBindings.cameraEmitRedstone.func_151468_f()) {
                    CameraController.emitRedstone(cam);
                }
                if (KeyBindings.cameraActivateNightVision.func_151468_f()) {
                    CameraController.giveNightVision(cam);
                }
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                double yRotChange = player.field_70177_z - player.field_175164_bL;
                double xRotChange = player.field_70125_A - player.field_175165_bM;
                if (yRotChange != 0.0 || xRotChange != 0.0) {
                    player.field_71174_a.func_147297_a((IPacket)new CPlayerPacket.RotationPacket(player.field_70177_z, player.field_70125_A, player.func_233570_aj_()));
                }
            }
        }
    }

    private static void dismount() {
        SecurityCraft.channel.sendToServer((Object)new DismountCamera());
    }

    public static void moveViewUp(SecurityCamera cam) {
        float next = cam.field_70125_A - (float)cam.cameraSpeed * cam.zoomAmount;
        if (cam.isCameraDown()) {
            if (next > 40.0f) {
                cam.func_70101_b(cam.field_70177_z, next);
            }
        } else if (next > -25.0f) {
            cam.func_70101_b(cam.field_70177_z, next);
        }
    }

    public static void moveViewDown(SecurityCamera cam) {
        float next = cam.field_70125_A + (float)cam.cameraSpeed * cam.zoomAmount;
        if (cam.isCameraDown()) {
            if (next < 90.0f) {
                cam.func_70101_b(cam.field_70177_z, next);
            }
        } else if (next < 60.0f) {
            cam.func_70101_b(cam.field_70177_z, next);
        }
    }

    public static void moveViewHorizontally(SecurityCamera cam, float yRot, float next) {
        BlockState state = cam.field_70170_p.func_180495_p(cam.func_233580_cy_());
        if (state.func_235901_b_((Property)SecurityCameraBlock.FACING)) {
            float checkNext = next;
            if (checkNext < 0.0f) {
                checkNext += 360.0f;
            }
            boolean shouldSetRotation = false;
            switch ((Direction)state.func_177229_b((Property)SecurityCameraBlock.FACING)) {
                case NORTH: {
                    shouldSetRotation = checkNext > 90.0f && checkNext < 270.0f;
                    break;
                }
                case SOUTH: {
                    shouldSetRotation = checkNext > 270.0f || checkNext < 90.0f;
                    break;
                }
                case EAST: {
                    shouldSetRotation = checkNext > 180.0f && checkNext < 360.0f;
                    break;
                }
                case WEST: {
                    shouldSetRotation = checkNext > 0.0f && checkNext < 180.0f;
                    break;
                }
                case DOWN: {
                    shouldSetRotation = true;
                    break;
                }
                default: {
                    shouldSetRotation = false;
                }
            }
            if (shouldSetRotation) {
                cam.field_70177_z = next;
            }
        }
    }

    public static void zoomIn(SecurityCamera cam) {
        if (!cam.zooming) {
            Minecraft.func_71410_x().field_71441_e.func_184156_a(cam.func_233580_cy_(), SCSounds.CAMERAZOOMIN.event, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
        cam.zooming = true;
        cam.zoomAmount = Math.max(cam.zoomAmount - 0.1f, 0.1f);
    }

    public static void zoomOut(SecurityCamera cam) {
        if (!cam.zooming) {
            Minecraft.func_71410_x().field_71441_e.func_184156_a(cam.func_233580_cy_(), SCSounds.CAMERAZOOMIN.event, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
        cam.zooming = true;
        cam.zoomAmount = Math.min(cam.zoomAmount + 0.1f, 1.4f);
    }

    public static void emitRedstone(SecurityCamera cam) {
        if (cam.redstoneCooldown == 0) {
            cam.toggleRedstonePower();
            cam.redstoneCooldown = 30;
        }
    }

    public static void giveNightVision(SecurityCamera cam) {
        if (cam.toggleNightVisionCooldown == 0) {
            cam.toggleNightVision();
        }
    }

    public static ClientChunkProvider.ChunkArray getCameraStorage() {
        return cameraStorage;
    }

    public static void setCameraStorage(ClientChunkProvider.ChunkArray cameraStorage) {
        if (cameraStorage != null) {
            CameraController.cameraStorage = cameraStorage;
        }
    }

    public static void setRenderPosition(Entity entity) {
        if (entity instanceof SecurityCamera) {
            SectionPos cameraPos = SectionPos.func_218157_a((Entity)entity);
            CameraController.cameraStorage.field_217198_e = cameraPos.func_218149_a();
            CameraController.cameraStorage.field_217199_f = cameraPos.func_218148_c();
        }
    }
}

