/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class MineRemoteAccessToolItem
extends Item {
    public MineRemoteAccessToolItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.field_72995_K) {
            ClientHandler.displayMRATGui(player.func_184586_b(hand));
        }
        return ActionResult.func_226249_b_((Object)player.func_184586_b(hand));
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
        return this.onItemUseFirst(ctx.func_195999_j(), ctx.func_195991_k(), ctx.func_195995_a(), stack, ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c);
    }

    public ActionResultType onItemUseFirst(PlayerEntity player, World world, BlockPos pos, ItemStack stack, Direction facing, double hitX, double hitY, double hitZ) {
        if (world.func_180495_p(pos).func_177230_c() instanceof IExplosive) {
            if (!this.isMineAdded(stack, pos)) {
                int availSlot = this.getNextAvaliableSlot(stack);
                if (availSlot == 0) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.REMOTE_ACCESS_MINE.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:mrat.noSlots", new Object[0]), TextFormatting.RED);
                    return ActionResultType.FAIL;
                }
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof IOwnable && !((IOwnable)te).getOwner().isOwner(player)) {
                    if (world.field_72995_K) {
                        ClientHandler.displayMRATGui(stack);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new CompoundNBT());
                }
                stack.func_77978_p().func_74783_a("mine" + availSlot, BlockUtils.posToIntArray(pos));
                if (!world.field_72995_K) {
                    SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new UpdateNBTTagOnClient(stack));
                }
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.REMOTE_ACCESS_MINE.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:mrat.bound", Utils.getFormattedCoordinates(pos)), TextFormatting.GREEN);
                return ActionResultType.SUCCESS;
            }
            this.removeTagFromItemAndUpdate(stack, pos, player);
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.REMOTE_ACCESS_MINE.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:mrat.unbound", Utils.getFormattedCoordinates(pos)), TextFormatting.RED);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            if (stack.func_77978_p().func_74759_k("mine" + i).length > 0) {
                int[] coords = stack.func_77978_p().func_74759_k("mine" + i);
                if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) {
                    list.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "---"));
                    continue;
                }
                list.add((ITextComponent)Utils.localize("tooltip.securitycraft:mine", new Object[0]).func_230529_a_((ITextComponent)new StringTextComponent(" " + i + ": ")).func_230529_a_((ITextComponent)Utils.getFormattedCoordinates(new BlockPos(coords[0], coords[1], coords[2]))).func_230530_a_(Utils.GRAY_STYLE));
                continue;
            }
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "---"));
        }
    }

    private void removeTagFromItemAndUpdate(ItemStack stack, BlockPos pos, PlayerEntity player) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("mine" + i))[0] != pos.func_177958_n() || coords[1] != pos.func_177956_o() || coords[2] != pos.func_177952_p()) continue;
            stack.func_77978_p().func_74783_a("mine" + i, new int[]{0, 0, 0});
            if (!player.field_70170_p.field_72995_K) {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new UpdateNBTTagOnClient(stack));
            }
            return;
        }
    }

    private boolean isMineAdded(ItemStack stack, BlockPos pos) {
        if (stack.func_77978_p() == null) {
            return false;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("mine" + i))[0] != pos.func_177958_n() || coords[1] != pos.func_177956_o() || coords[2] != pos.func_177952_p()) continue;
            return true;
        }
        return false;
    }

    private int getNextAvaliableSlot(ItemStack stack) {
        for (int i = 1; i <= 6; ++i) {
            if (stack.func_77978_p() == null) {
                return 1;
            }
            if (stack.func_77978_p().func_74759_k("mine" + i).length != 0 && (stack.func_77978_p().func_74759_k("mine" + i)[0] != 0 || stack.func_77978_p().func_74759_k("mine" + i)[1] != 0 || stack.func_77978_p().func_74759_k("mine" + i)[2] != 0)) continue;
            return i;
        }
        return 0;
    }
}

