/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCEventHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.MutablePair;

public class PortableTunePlayerItem
extends Item {
    public PortableTunePlayerItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockPos pos;
        World world = ctx.func_195991_k();
        if (world.func_180495_p(pos = ctx.func_195995_a()).func_177230_c() == SCContent.SONIC_SECURITY_SYSTEM.get()) {
            SonicSecuritySystemBlockEntity te = (SonicSecuritySystemBlockEntity)world.func_175625_s(pos);
            PlayerEntity player = ctx.func_195999_j();
            if (te.getOwner().isOwner(player) || ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
                if (te.getNumberOfNotes() > 0) {
                    te.saveNotes(ctx.func_195996_i().func_196082_o());
                    player.func_146105_b((ITextComponent)Utils.localize("messages.securitycraft:portable_tune_player.tune_saved", new Object[0]), true);
                } else {
                    player.func_146105_b((ITextComponent)Utils.localize("messages.securitycraft:portable_tune_player.no_tune", new Object[0]), true);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            CompoundNBT tag = stack.func_196082_o();
            boolean isTunePlaying = SCEventHandler.PLAYING_TUNES.containsKey(player);
            if (!isTunePlaying && tag.func_74764_b("Notes")) {
                ArrayDeque notes = new ArrayDeque();
                SonicSecuritySystemBlockEntity.loadNotes(stack.func_77978_p(), notes);
                SCEventHandler.PLAYING_TUNES.put(player, (MutablePair<Integer, Deque<SonicSecuritySystemBlockEntity.NoteWrapper>>)MutablePair.of((Object)0, notes));
                return ActionResult.func_226248_a_((Object)stack);
            }
            if (isTunePlaying) {
                SCEventHandler.PLAYING_TUNES.remove(player);
                return ActionResult.func_226248_a_((Object)stack);
            }
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        int notesCount = stack.func_77978_p().func_150295_c("Notes", 10).size();
        if (notesCount > 0) {
            tooltip.add((ITextComponent)Utils.localize("tooltip.securitycraft:portableTunePlayer.noteCount", notesCount).func_240703_c_(Utils.GRAY_STYLE));
        }
    }
}

