/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class SonicSecuritySystemItem
extends BlockItem {
    public SonicSecuritySystemItem(Item.Properties properties) {
        super((Block)SCContent.SONIC_SECURITY_SYSTEM.get(), properties);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
        return this.onItemUseFirst(ctx.func_195999_j(), ctx.func_195991_k(), ctx.func_195995_a(), stack, ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c);
    }

    public ActionResultType onItemUseFirst(PlayerEntity player, World world, BlockPos pos, ItemStack stack, Direction facing, double hitX, double hitY, double hitZ) {
        TileEntity te;
        if (!world.field_72995_K && !player.func_225608_bj_() && (te = world.func_175625_s(pos)) instanceof ILockable) {
            if (te instanceof IOwnable && !((IOwnable)te).getOwner().isOwner(player)) {
                Block block = te.func_195044_w().func_177230_c();
                if (!(block instanceof DisguisableBlock) || ((DisguisableBlock)block).getDisguisedBlockState((IBlockReader)world, pos) == null) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Block)SCContent.SONIC_SECURITY_SYSTEM.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:notOwned", ((IOwnable)te).getOwner().getName(), pos), TextFormatting.GREEN);
                    return ActionResultType.SUCCESS;
                }
            } else {
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new CompoundNBT());
                }
                if (SonicSecuritySystemItem.isAdded(stack.func_77978_p(), pos)) {
                    SonicSecuritySystemItem.removeLinkedBlock(stack.func_77978_p(), pos);
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Block)SCContent.SONIC_SECURITY_SYSTEM.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:sonic_security_system.blockUnlinked", Utils.localize(world.func_180495_p(pos).func_177230_c().func_149739_a(), new Object[0]), pos), TextFormatting.GREEN);
                    return ActionResultType.SUCCESS;
                }
                if (SonicSecuritySystemItem.addLinkedBlock(stack.func_77978_p(), pos, player)) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Block)SCContent.SONIC_SECURITY_SYSTEM.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:sonic_security_system.blockLinked", Utils.localize(world.func_180495_p(pos).func_177230_c().func_149739_a(), new Object[0]), pos), TextFormatting.GREEN);
                    SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new UpdateNBTTagOnClient(stack));
                    return ActionResultType.SUCCESS;
                }
            }
        }
        if (!stack.func_77942_o() || !SonicSecuritySystemItem.hasLinkedBlock(stack.func_77978_p())) {
            if (!world.field_72995_K) {
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Block)SCContent.SONIC_SECURITY_SYSTEM.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:sonic_security_system.notLinked", new Object[0]), TextFormatting.DARK_RED);
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    protected boolean func_195943_a(BlockPos pos, World level, PlayerEntity player, ItemStack stack, BlockState state) {
        TileEntity be = level.func_175625_s(pos);
        if (be instanceof SonicSecuritySystemBlockEntity && ((SonicSecuritySystemBlockEntity)be).transferPositionsFromItem(stack.func_196082_o())) {
            return true;
        }
        return super.func_195943_a(pos, level, player, stack, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        int numOfLinkedBlocks = stack.func_77978_p().func_150295_c("LinkedBlocks", 10).size();
        if (numOfLinkedBlocks > 0) {
            tooltip.add((ITextComponent)Utils.localize("tooltip.securitycraft:sonicSecuritySystem.linkedTo", numOfLinkedBlocks).func_240703_c_(Utils.GRAY_STYLE));
        }
    }

    public static boolean addLinkedBlock(CompoundNBT tag, BlockPos pos, PlayerEntity player) {
        if (SonicSecuritySystemItem.isAdded(tag, pos)) {
            return false;
        }
        ListNBT list = tag.func_150295_c("LinkedBlocks", 10);
        if (list.size() >= 30) {
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Block)SCContent.SONIC_SECURITY_SYSTEM.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:sonic_security_system.linkMaxReached", 30), TextFormatting.DARK_RED);
            return false;
        }
        CompoundNBT nbt = NBTUtil.func_186859_a((BlockPos)pos);
        list.add((Object)nbt);
        tag.func_218657_a("LinkedBlocks", (INBT)list);
        return true;
    }

    public static void removeLinkedBlock(CompoundNBT tag, BlockPos pos) {
        if (!tag.func_74764_b("LinkedBlocks")) {
            return;
        }
        ListNBT list = tag.func_150295_c("LinkedBlocks", 10);
        for (int i = list.size() - 1; i >= 0; --i) {
            BlockPos posRead = NBTUtil.func_186861_c((CompoundNBT)list.func_150305_b(i));
            if (!pos.equals((Object)posRead)) continue;
            list.remove(i);
        }
    }

    public static boolean isAdded(CompoundNBT tag, BlockPos pos) {
        if (!tag.func_74764_b("LinkedBlocks")) {
            return false;
        }
        ListNBT list = tag.func_150295_c("LinkedBlocks", 10);
        for (int i = 0; i < list.size(); ++i) {
            BlockPos posRead = NBTUtil.func_186861_c((CompoundNBT)list.func_150305_b(i));
            if (!pos.equals((Object)posRead)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLinkedBlock(CompoundNBT tag) {
        if (!tag.func_74764_b("LinkedBlocks")) {
            return false;
        }
        return tag.func_150295_c("LinkedBlocks", 10).size() > 0;
    }
}

