/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class UniversalOwnerChangerItem
extends Item {
    public UniversalOwnerChangerItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
        return this.onItemUseFirst(ctx.func_195999_j(), ctx.func_195991_k(), ctx.func_195995_a(), stack, ctx.func_196000_l(), ctx.func_221531_n());
    }

    public ActionResultType onItemUseFirst(PlayerEntity player, World world, BlockPos pos, ItemStack stack, Direction side, Hand hand) {
        boolean isDefault;
        if (hand == Hand.MAIN_HAND && player.func_184592_cb().func_77973_b() == SCContent.BRIEFCASE.get()) {
            return this.handleBriefcase(player, stack).func_188397_a();
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        TileEntity te = world.func_175625_s(pos);
        String newOwner = stack.func_200301_q().getString();
        if (!(te instanceof IOwnable)) {
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.cantChange", new Object[0]), TextFormatting.RED);
            return ActionResultType.FAIL;
        }
        Owner owner = ((IOwnable)te).getOwner();
        boolean bl = isDefault = owner.getName().equals("owner") && owner.getUUID().equals("ownerUUID");
        if (!owner.isOwner(player) && !isDefault) {
            if (!(block instanceof IBlockMine || te.func_195044_w().func_177230_c() instanceof DisguisableBlock && !(((BlockItem)((DisguisableBlock)te.func_195044_w().func_177230_c()).getDisguisedStack((IBlockReader)world, pos).func_77973_b()).func_179223_d() instanceof DisguisableBlock))) {
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.notOwned", new Object[0]), TextFormatting.RED);
                return ActionResultType.FAIL;
            }
            return ActionResultType.PASS;
        }
        if (!stack.func_82837_s() && !isDefault) {
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.noName", new Object[0]), TextFormatting.RED);
            return ActionResultType.FAIL;
        }
        if (isDefault) {
            if (((Boolean)ConfigHandler.SERVER.allowBlockClaim.get()).booleanValue()) {
                newOwner = player.func_200200_C_().getString();
            } else {
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.noBlockClaiming", new Object[0]), TextFormatting.RED);
                return ActionResultType.FAIL;
            }
        }
        if (te instanceof IOwnable) {
            ((IOwnable)te).setOwner(PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).func_110124_au().toString() : "ownerUUID", newOwner);
            ((IOwnable)te).onOwnerChanged(state, world, pos, player);
        }
        if (!world.field_72995_K) {
            world.func_73046_m().func_184103_al().func_148540_a((IPacket)te.func_189518_D_());
        }
        if (FMLEnvironment.production && te instanceof IModuleInventory) {
            for (ModuleType moduleType : ((IModuleInventory)te).getInsertedModules()) {
                ItemStack moduleStack = ((IModuleInventory)te).getModule(moduleType);
                ((IModuleInventory)te).removeModule(moduleType);
                ((IModuleInventory)te).onModuleRemoved(moduleStack, moduleType);
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)moduleStack);
            }
        }
        PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), TextFormatting.GREEN);
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack ownerChanger = player.func_184586_b(hand);
        if (!ownerChanger.func_82837_s()) {
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.noName", new Object[0]), TextFormatting.RED);
            return ActionResult.func_226251_d_((Object)ownerChanger);
        }
        if (hand == Hand.MAIN_HAND && player.func_184592_cb().func_77973_b() == SCContent.BRIEFCASE.get()) {
            return this.handleBriefcase(player, ownerChanger);
        }
        return ActionResult.func_226250_c_((Object)ownerChanger);
    }

    private ActionResult<ItemStack> handleBriefcase(PlayerEntity player, ItemStack ownerChanger) {
        ItemStack briefcase = player.func_184592_cb();
        if (BriefcaseItem.isOwnedBy(briefcase, player)) {
            String newOwner = ownerChanger.func_200301_q().getString();
            if (!briefcase.func_77942_o()) {
                briefcase.func_77982_d(new CompoundNBT());
            }
            briefcase.func_77978_p().func_74778_a("owner", newOwner);
            briefcase.func_77978_p().func_74778_a("ownerUUID", PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).func_110124_au().toString() : "ownerUUID");
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), TextFormatting.GREEN);
            return ActionResult.func_226248_a_((Object)ownerChanger);
        }
        PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.briefcase.notOwned", new Object[0]), TextFormatting.RED);
        return ActionResult.func_226249_b_((Object)ownerChanger);
    }
}

