/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;

public class LimitedUseKeycardRecipe
extends SpecialRecipe {
    @ObjectHolder(value="securitycraft:limited_use_keycard_recipe")
    public static SpecialRecipeSerializer<LimitedUseKeycardRecipe> serializer = null;

    public LimitedUseKeycardRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingInventory inv, World world) {
        boolean hasNormalKeycard = false;
        boolean hasLimitedUseKeycard = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            Item item = stack.func_77973_b();
            if (item instanceof KeycardItem) {
                if (item != SCContent.LIMITED_USE_KEYCARD.get()) {
                    if (hasNormalKeycard || stack.func_196082_o().func_74767_n("limited")) {
                        return false;
                    }
                    hasNormalKeycard = true;
                    continue;
                }
                if (hasLimitedUseKeycard) {
                    return false;
                }
                hasLimitedUseKeycard = true;
                continue;
            }
            if (stack.func_190926_b()) continue;
            return false;
        }
        return hasNormalKeycard && hasLimitedUseKeycard;
    }

    public ItemStack assemble(CraftingInventory inv) {
        ItemStack keycard = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            Item item = stack.func_77973_b();
            if (!(item instanceof KeycardItem) || item == SCContent.LIMITED_USE_KEYCARD.get()) continue;
            keycard = stack.func_77946_l();
            break;
        }
        if (keycard.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        CompoundNBT tag = keycard.func_196082_o();
        tag.func_74757_a("limited", true);
        tag.func_74768_a("uses", 0);
        keycard.func_190920_e(2);
        return keycard;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return serializer;
    }
}

