/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SonicSecuritySystemTracker {
    private static final Map<RegistryKey<World>, Collection<BlockPos>> trackedSonicSecuritySystems = new HashMap<RegistryKey<World>, Collection<BlockPos>>();

    public static void track(SonicSecuritySystemBlockEntity te) {
        SonicSecuritySystemTracker.getTrackedSonicSecuritySystems(te.func_145831_w()).add(te.func_174877_v().func_185334_h());
    }

    public static void stopTracking(SonicSecuritySystemBlockEntity te) {
        SonicSecuritySystemTracker.getTrackedSonicSecuritySystems(te.func_145831_w()).remove(te.func_174877_v());
    }

    public static List<SonicSecuritySystemBlockEntity> getSonicSecuritySystemsInRange(World world, BlockPos pos) {
        return SonicSecuritySystemTracker.getSonicSecuritySystemsInRange(world, pos, 30);
    }

    public static List<SonicSecuritySystemBlockEntity> getSonicSecuritySystemsInRange(World world, BlockPos pos, int range) {
        Collection<BlockPos> sonicSecuritySystems = SonicSecuritySystemTracker.getTrackedSonicSecuritySystems(world);
        ArrayList<SonicSecuritySystemBlockEntity> returnValue = new ArrayList<SonicSecuritySystemBlockEntity>();
        Iterator<BlockPos> it = sonicSecuritySystems.iterator();
        while (it.hasNext()) {
            TileEntity potentialSonicSecuritySystem;
            BlockPos sonicSecuritySystemPos = it.next();
            if (sonicSecuritySystemPos != null && (potentialSonicSecuritySystem = world.func_175625_s(sonicSecuritySystemPos)) instanceof SonicSecuritySystemBlockEntity) {
                if (!SonicSecuritySystemTracker.canSonicSecuritySystemReach((SonicSecuritySystemBlockEntity)potentialSonicSecuritySystem, pos)) continue;
                returnValue.add((SonicSecuritySystemBlockEntity)potentialSonicSecuritySystem);
                continue;
            }
            it.remove();
        }
        return returnValue;
    }

    private static Collection<BlockPos> getTrackedSonicSecuritySystems(World world) {
        Collection<BlockPos> sonicSecuritySystems = trackedSonicSecuritySystems.get(world.func_234923_W_());
        if (sonicSecuritySystems == null) {
            sonicSecuritySystems = new HashSet<BlockPos>();
            trackedSonicSecuritySystems.put((RegistryKey<World>)world.func_234923_W_(), sonicSecuritySystems);
        }
        return sonicSecuritySystems;
    }

    public static boolean canSonicSecuritySystemReach(SonicSecuritySystemBlockEntity te, BlockPos pos) {
        AxisAlignedBB sssRange = new AxisAlignedBB(te.func_174877_v()).func_186662_g(30.0);
        return sssRange.field_72340_a <= (double)pos.func_177958_n() && sssRange.field_72338_b <= (double)pos.func_177956_o() && sssRange.field_72339_c <= (double)pos.func_177952_p() && sssRange.field_72336_d >= (double)pos.func_177958_n() && sssRange.field_72337_e >= (double)pos.func_177956_o() && sssRange.field_72334_f >= (double)pos.func_177952_p();
    }
}

