/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import net.geforcemods.securitycraft.entity.camera.CameraController;
import net.geforcemods.securitycraft.misc.IChunkStorageProvider;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientChunkProvider.class}, priority=1100)
public abstract class ClientChunkProviderMixin
implements IChunkStorageProvider {
    @Shadow
    private volatile ClientChunkProvider.ChunkArray field_217256_d;
    @Shadow
    @Final
    private ClientWorld field_73235_d;

    @Shadow
    public abstract WorldLightManager func_212863_j_();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onInit(ClientWorld world, int viewDistance, CallbackInfo ci) {
        CameraController.setCameraStorage(this.newStorage(Math.max(2, viewDistance) + 3));
    }

    @Inject(method={"updateViewRadius"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/multiplayer/ClientChunkProvider$ChunkArray;<init>(Lnet/minecraft/client/multiplayer/ClientChunkProvider;I)V")})
    public void onUpdateViewRadius(int viewDistance, CallbackInfo ci) {
        CameraController.setCameraStorage(this.newStorage(Math.max(2, viewDistance) + 3));
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")})
    public void onDrop(int x, int z, CallbackInfo ci) {
        int i;
        Chunk chunk;
        ClientChunkProvider.ChunkArray cameraStorage = CameraController.getCameraStorage();
        if (cameraStorage.func_217183_b(x, z) && (chunk = cameraStorage.func_217192_a(i = cameraStorage.func_217191_a(x, z))) != null && chunk.func_76632_l().field_77276_a == x && chunk.func_76632_l().field_77275_b == z) {
            MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((IChunk)chunk));
            cameraStorage.func_217190_a(i, chunk, null);
        }
    }

    @Inject(method={"replaceWithPacketData"}, at={@At(value="HEAD")}, cancellable=true)
    private void onReplace(int x, int z, BiomeContainer biomeContainer, PacketBuffer buffer, CompoundNBT chunkTag, int size, boolean fullChunk, CallbackInfoReturnable<Chunk> callback) {
        ClientChunkProvider.ChunkArray cameraStorage = CameraController.getCameraStorage();
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.func_71410_x().field_71439_g) && !this.field_217256_d.func_217183_b(x, z) && cameraStorage.func_217183_b(x, z)) {
            int index = cameraStorage.func_217191_a(x, z);
            Chunk chunk = cameraStorage.func_217192_a(index);
            ChunkPos chunkPos = new ChunkPos(x, z);
            if (chunk == null || chunk.func_76632_l().field_77276_a != x || chunk.func_76632_l().field_77275_b != z) {
                chunk = new Chunk((World)this.field_73235_d, chunkPos, biomeContainer);
                chunk.func_227073_a_(biomeContainer, buffer, chunkTag, size);
                cameraStorage.func_217181_a(index, chunk);
            } else {
                chunk.func_227073_a_(biomeContainer, buffer, chunkTag, size);
            }
            ChunkSection[] chunkSections = chunk.func_76587_i();
            WorldLightManager lightEngine = this.func_212863_j_();
            lightEngine.func_215571_a(chunkPos, true);
            for (int y = 0; y < chunkSections.length; ++y) {
                lightEngine.func_215566_a(SectionPos.func_218154_a((int)x, (int)y, (int)z), ChunkSection.func_222628_a((ChunkSection)chunkSections[y]));
            }
            this.field_73235_d.func_228323_e_(x, z);
            MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load((IChunk)chunk));
            callback.setReturnValue((Object)chunk);
        }
    }

    @Inject(method={"getChunk(IILnet/minecraft/world/chunk/ChunkStatus;Z)Lnet/minecraft/world/chunk/Chunk;"}, at={@At(value="TAIL")}, cancellable=true)
    private void onGetChunk(int x, int z, ChunkStatus requiredStatus, boolean load, CallbackInfoReturnable<Chunk> callback) {
        Chunk chunk;
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.func_71410_x().field_71439_g) && !this.field_217256_d.func_217183_b(x, z) && CameraController.getCameraStorage().func_217183_b(x, z) && (chunk = CameraController.getCameraStorage().func_217192_a(CameraController.getCameraStorage().func_217191_a(x, z))) != null && chunk.func_76632_l().field_77276_a == x && chunk.func_76632_l().field_77275_b == z) {
            callback.setReturnValue((Object)chunk);
        }
    }
}

