/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.models;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class DisguisableDynamicBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<BlockState> DISGUISED_STATE_RL = new ModelProperty();
    private final IBakedModel oldModel;

    public DisguisableDynamicBakedModel(IBakedModel oldModel) {
        this.oldModel = oldModel;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData modelData) {
        IBakedModel model;
        Block block;
        BlockState disguisedState = (BlockState)modelData.getData(DISGUISED_STATE_RL);
        if (disguisedState != null && (block = disguisedState.func_177230_c()) != Blocks.field_150350_a && (model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(disguisedState)) != null && model != this) {
            return model.getQuads(disguisedState, side, rand, modelData);
        }
        return this.oldModel.getQuads(state, side, rand, modelData);
    }

    public TextureAtlasSprite getParticleTexture(IModelData modelData) {
        IBakedModel model;
        Block block;
        BlockState state = (BlockState)modelData.getData(DISGUISED_STATE_RL);
        if (state != null && (block = state.func_177230_c()) != Blocks.field_150350_a && (model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state)) != null && model != this) {
            return model.getParticleTexture(modelData);
        }
        return this.oldModel.getParticleTexture(modelData);
    }

    @Nonnull
    public IModelData getModelData(IBlockDisplayReader world, BlockPos pos, BlockState state, IModelData tileData) {
        Optional<BlockState> disguisedState;
        Block block;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && (block = te.func_195044_w().func_177230_c()) instanceof DisguisableBlock && (disguisedState = ((DisguisableBlock)block).getDisguisedBlockState((IBlockReader)world, pos)).isPresent()) {
            tileData.setData(DISGUISED_STATE_RL, (Object)disguisedState.get());
            return tileData;
        }
        tileData.setData(DISGUISED_STATE_RL, (Object)Blocks.field_150350_a.func_176223_P());
        return tileData;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.oldModel.func_177554_e();
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public boolean func_177555_b() {
        return true;
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }

    public boolean func_230044_c_() {
        return false;
    }
}

