/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class MountCamera {
    private BlockPos pos;

    public MountCamera() {
    }

    public MountCamera(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(MountCamera message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
    }

    public static MountCamera decode(PacketBuffer buf) {
        MountCamera message = new MountCamera();
        message.pos = buf.func_179259_c();
        return message;
    }

    public static void onMessage(MountCamera message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te;
            BlockPos pos = message.pos;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.field_70170_p;
            BlockState state = world.func_180495_p(pos);
            if (world.func_195588_v(pos) && state.func_177230_c() == SCContent.SECURITY_CAMERA.get() && (te = world.func_175625_s(pos)) instanceof SecurityCameraBlockEntity) {
                SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)te;
                if (cam.getOwner().isOwner((PlayerEntity)player) || ModuleUtils.isAllowed((IModuleInventory)cam, (Entity)player)) {
                    ((SecurityCameraBlock)state.func_177230_c()).mountCamera(world, pos, (PlayerEntity)player);
                } else {
                    PlayerUtils.sendMessageToPlayer((PlayerEntity)player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.CAMERA_MONITOR.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:notOwned", cam.getOwner().getName()), TextFormatting.RED);
                }
                return;
            }
            PlayerUtils.sendMessageToPlayer((PlayerEntity)player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.CAMERA_MONITOR.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:cameraMonitor.cameraNotAvailable", pos), TextFormatting.RED);
        });
        ctx.get().setPacketHandled(true);
    }
}

