/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadChestBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetPassword {
    private String password;
    private int x;
    private int y;
    private int z;

    public SetPassword() {
    }

    public SetPassword(int x, int y, int z, String code) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.password = code;
    }

    public static void encode(SetPassword message, PacketBuffer buf) {
        buf.writeInt(message.x);
        buf.writeInt(message.y);
        buf.writeInt(message.z);
        buf.func_180714_a(message.password);
    }

    public static SetPassword decode(PacketBuffer buf) {
        SetPassword message = new SetPassword();
        message.x = buf.readInt();
        message.y = buf.readInt();
        message.z = buf.readInt();
        message.password = buf.func_150789_c(0x1FFFFFFF);
        return message;
    }

    public static void onMessage(SetPassword message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockPos pos = new BlockPos(message.x, message.y, message.z);
            String password = message.password;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.field_70170_p;
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof IPasswordProtected && (!(te instanceof IOwnable) || ((IOwnable)te).getOwner().isOwner((PlayerEntity)player))) {
                ((IPasswordProtected)te).setPassword(password);
                if (te instanceof KeypadChestBlockEntity) {
                    SetPassword.checkAndUpdateAdjacentChest((KeypadChestBlockEntity)te, world, pos, password, (PlayerEntity)player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void checkAndUpdateAdjacentChest(KeypadChestBlockEntity te, World world, BlockPos pos, String codeToSet, PlayerEntity player) {
        BlockPos offsetPos;
        TileEntity otherTe;
        if (te.func_195044_w().func_177229_b((Property)KeypadChestBlock.field_196314_b) != ChestType.SINGLE && (otherTe = world.func_175625_s(offsetPos = pos.func_177972_a(KeypadChestBlock.func_196311_i((BlockState)te.func_195044_w())))) instanceof KeypadChestBlockEntity && te.getOwner().owns((KeypadChestBlockEntity)otherTe)) {
            ((KeypadChestBlockEntity)otherTe).setPassword(codeToSet);
            world.func_184138_a(offsetPos, otherTe.func_195044_w(), otherTe.func_195044_w(), 2);
        }
    }
}

