/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncKeycardSettings {
    private BlockPos pos;
    private int signature;
    private boolean[] acceptedLevels;
    private boolean link;

    public SyncKeycardSettings() {
    }

    public SyncKeycardSettings(BlockPos pos, boolean[] acceptedLevels, int signature, boolean link) {
        this.pos = pos;
        this.acceptedLevels = acceptedLevels;
        this.signature = signature;
        this.link = link;
    }

    public static void encode(SyncKeycardSettings message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.func_150787_b(message.signature);
        buf.writeBoolean(message.link);
        for (int i = 0; i < 5; ++i) {
            buf.writeBoolean(message.acceptedLevels[i]);
        }
    }

    public static SyncKeycardSettings decode(PacketBuffer buf) {
        SyncKeycardSettings message = new SyncKeycardSettings();
        message.pos = buf.func_179259_c();
        message.signature = buf.func_150792_a();
        message.link = buf.readBoolean();
        message.acceptedLevels = new boolean[5];
        for (int i = 0; i < 5; ++i) {
            message.acceptedLevels[i] = buf.readBoolean();
        }
        return message;
    }

    public static void onMessage(SyncKeycardSettings message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            KeycardReaderBlockEntity te;
            boolean isOwner;
            BlockPos pos = message.pos;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            if (tile instanceof KeycardReaderBlockEntity && ((isOwner = (te = (KeycardReaderBlockEntity)tile).getOwner().isOwner((PlayerEntity)player)) || ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player))) {
                Container container;
                if (isOwner) {
                    te.setAcceptedLevels(message.acceptedLevels);
                    te.setSignature(message.signature);
                }
                if (message.link && (container = player.field_71070_bA) instanceof KeycardReaderMenu) {
                    ((KeycardReaderMenu)container).link();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

