/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncSSSSettingsOnServer {
    private BlockPos pos;
    private DataType dataType;

    public SyncSSSSettingsOnServer() {
    }

    public SyncSSSSettingsOnServer(BlockPos pos, DataType dataType) {
        this.pos = pos;
        this.dataType = dataType;
    }

    public static void encode(SyncSSSSettingsOnServer message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.func_179249_a((Enum)message.dataType);
    }

    public static SyncSSSSettingsOnServer decode(PacketBuffer buf) {
        SyncSSSSettingsOnServer message = new SyncSSSSettingsOnServer();
        message.pos = buf.func_179259_c();
        message.dataType = (DataType)buf.func_179257_a(DataType.class);
        return message;
    }

    public static void onMessage(SyncSSSSettingsOnServer message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World world = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p;
            BlockPos pos = message.pos;
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof SonicSecuritySystemBlockEntity && ((SonicSecuritySystemBlockEntity)te).getOwner().isOwner((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender())) {
                SonicSecuritySystemBlockEntity sss = (SonicSecuritySystemBlockEntity)te;
                switch (message.dataType) {
                    case POWER_ON: {
                        sss.setActive(true);
                        break;
                    }
                    case POWER_OFF: {
                        sss.setActive(false);
                        if (!sss.isRecording()) break;
                        sss.setRecording(false);
                        break;
                    }
                    case SOUND_ON: {
                        sss.setPings(true);
                        break;
                    }
                    case SOUND_OFF: {
                        sss.setPings(false);
                        break;
                    }
                    case RECORDING_ON: {
                        sss.setRecording(true);
                        break;
                    }
                    case RECORDING_OFF: {
                        sss.setRecording(false);
                        break;
                    }
                    case CLEAR_NOTES: {
                        sss.clearNotes();
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum DataType {
        POWER_ON,
        POWER_OFF,
        SOUND_ON,
        SOUND_OFF,
        RECORDING_ON,
        RECORDING_OFF,
        CLEAR_NOTES;

    }
}

