/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateSliderValue {
    private BlockPos pos;
    private String option;
    private double value;

    public UpdateSliderValue() {
    }

    public UpdateSliderValue(BlockPos pos, Option<?> option, double v) {
        this.pos = pos;
        this.option = option.getName();
        this.value = v;
    }

    public static void encode(UpdateSliderValue message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.func_180714_a(message.option);
        buf.writeDouble(message.value);
    }

    public static UpdateSliderValue decode(PacketBuffer buf) {
        UpdateSliderValue message = new UpdateSliderValue();
        message.pos = buf.func_179259_c();
        message.option = buf.func_218666_n();
        message.value = buf.readDouble();
        return message;
    }

    public static void onMessage(UpdateSliderValue message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockPos pos = message.pos;
            String optionName = message.option;
            double value = message.value;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            TileEntity te = player.field_70170_p.func_175625_s(pos);
            if (te instanceof ICustomizable && (!(te instanceof IOwnable) || ((IOwnable)te).getOwner().isOwner((PlayerEntity)player))) {
                ICustomizable customizable = (ICustomizable)te;
                Option<?> option = null;
                for (Option<?> o : customizable.customOptions()) {
                    if (!o.getName().equals(optionName)) continue;
                    option = o;
                    break;
                }
                if (option == null) {
                    return;
                }
                if (option instanceof Option.DoubleOption) {
                    ((Option.DoubleOption)option).setValue(value);
                } else if (option instanceof Option.IntOption) {
                    ((Option.IntOption)option).setValue((int)value);
                }
                customizable.onOptionChanged(option);
                if (te instanceof CustomizableBlockEntity) {
                    player.field_70170_p.func_184138_a(pos, te.func_195044_w(), te.func_195044_w(), 3);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

