/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.LivingEntity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SecurityCameraRenderer
extends TileEntityRenderer<SecurityCameraBlockEntity> {
    private static final Quaternion POSITIVE_Y_180 = Vector3f.field_229181_d_.func_229187_a_(180.0f);
    private static final Quaternion POSITIVE_Y_90 = Vector3f.field_229181_d_.func_229187_a_(90.0f);
    private static final Quaternion NEGATIVE_Y_90 = Vector3f.field_229180_c_.func_229187_a_(90.0f);
    private static final Quaternion POSITIVE_X_180 = Vector3f.field_229179_b_.func_229187_a_(180.0f);
    private static final SecurityCameraModel MODEL = new SecurityCameraModel();
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/block/security_camera.png");
    private static final ResourceLocation BEING_VIEWED_TEXTURE = new ResourceLocation("securitycraft:textures/block/security_camera_viewing.png");

    public SecurityCameraRenderer(TileEntityRendererDispatcher terd) {
        super(terd);
    }

    public void render(SecurityCameraBlockEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight, int packedOverlay) {
        BlockState state;
        if (te.down || PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_175622_Z.func_233580_cy_().equals((Object)te.func_174877_v())) {
            return;
        }
        matrix.func_227861_a_(0.5, 1.5, 0.5);
        if (te.func_145830_o() && (state = te.func_145831_w().func_180495_p(te.func_174877_v())).func_177230_c() == SCContent.SECURITY_CAMERA.get()) {
            Direction side = (Direction)state.func_177229_b((Property)SecurityCameraBlock.FACING);
            if (side == Direction.NORTH) {
                matrix.func_227863_a_(POSITIVE_Y_180);
            } else if (side == Direction.EAST) {
                matrix.func_227863_a_(POSITIVE_Y_90);
            } else if (side == Direction.WEST) {
                matrix.func_227863_a_(NEGATIVE_Y_90);
            }
        }
        matrix.func_227863_a_(POSITIVE_X_180);
        SecurityCameraRenderer.MODEL.cameraRotationPoint.field_78796_g = (float)te.cameraRotation;
        MODEL.func_225598_a_(matrix, buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)((Boolean)te.func_195044_w().func_177229_b((Property)SecurityCameraBlock.BEING_VIEWED) != false ? BEING_VIEWED_TEXTURE : TEXTURE))), packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

