/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.models.SonicSecuritySystemModel;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SonicSecuritySystemRenderer
extends TileEntityRenderer<SonicSecuritySystemBlockEntity> {
    private static final Quaternion POSITIVE_X_180 = Vector3f.field_229179_b_.func_229187_a_(180.0f);
    private static final SonicSecuritySystemModel MODEL = new SonicSecuritySystemModel();
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/block/sonic_security_system.png");
    private static final TranslationTextComponent RECORDING_TEXT = Utils.localize("gui.securitycraft:sonic_security_system.recording", new Object[0]);
    private static final TranslationTextComponent LISTENING_TEXT = Utils.localize("gui.securitycraft:sonic_security_system.listening", new Object[0]);

    public SonicSecuritySystemRenderer(TileEntityRendererDispatcher terd) {
        super(terd);
    }

    public void render(SonicSecuritySystemBlockEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight, int packedOverlay) {
        boolean recording = te.isRecording();
        matrix.func_227861_a_(0.5, 1.5, 0.5);
        if (recording || te.isListening()) {
            TranslationTextComponent text = recording ? RECORDING_TEXT : LISTENING_TEXT;
            float f1 = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            FontRenderer fontRenderer = this.field_228858_b_.func_147548_a();
            float halfWidth = -fontRenderer.func_238414_a_((ITextProperties)text) / 2;
            matrix.func_227860_a_();
            matrix.func_227863_a_(Minecraft.func_71410_x().func_175598_ae().func_229098_b_());
            matrix.func_227862_a_(-0.025f, -0.025f, 0.025f);
            Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
            RenderSystem.disableCull();
            fontRenderer.func_243247_a((ITextComponent)text, halfWidth, 0.0f, 0xFFFFFF, false, positionMatrix, buffer, true, j, packedLight);
            fontRenderer.func_243247_a((ITextComponent)text, halfWidth, 0.0f, -1, false, positionMatrix, buffer, false, 0, packedLight);
            matrix.func_227865_b_();
        }
        matrix.func_227863_a_(POSITIVE_X_180);
        MODEL.setRadarRotation(te.radarRotationDegrees);
        MODEL.func_225598_a_(matrix, buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)TEXTURE)), packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

