/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.inventory.BlockPocketManagerMenu;
import net.geforcemods.securitycraft.network.server.SyncBlockPocketManager;
import net.geforcemods.securitycraft.screen.components.NamedSlider;
import net.geforcemods.securitycraft.screen.components.StackHoverChecker;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import net.minecraftforge.fml.client.gui.widget.Slider;
import net.minecraftforge.fml.network.PacketDistributor;

public class BlockPocketManagerScreen
extends ContainerScreen<BlockPocketManagerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/block_pocket_manager.png");
    private static final ResourceLocation TEXTURE_STORAGE = new ResourceLocation("securitycraft:textures/gui/container/block_pocket_manager_storage.png");
    private static final ItemStack BLOCK_POCKET_WALL = new ItemStack((IItemProvider)SCContent.BLOCK_POCKET_WALL.get());
    private static final ItemStack REINFORCED_CHISELED_CRYSTAL_QUARTZ = new ItemStack((IItemProvider)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get());
    private static final ItemStack REINFORCED_CRYSTAL_QUARTZ_PILLAR = new ItemStack((IItemProvider)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get());
    private final TranslationTextComponent blockPocketManager = Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).func_149739_a(), new Object[0]);
    private final TranslationTextComponent youNeed = Utils.localize("gui.securitycraft:blockPocketManager.youNeed", new Object[0]);
    private final boolean storage;
    private final boolean isOwner;
    private final int[] materialCounts = new int[3];
    public BlockPocketManagerBlockEntity te;
    private int size = 5;
    private Button toggleButton;
    private Button sizeButton;
    private Button assembleButton;
    private Button outlineButton;
    private Slider offsetSlider;
    private StackHoverChecker[] hoverCheckers = new StackHoverChecker[3];
    private TextHoverChecker assembleHoverChecker;
    private int wallsNeededOverall = (this.size - 2) * (this.size - 2) * 6;
    private int pillarsNeededOverall = (this.size - 2) * 12 - 1;
    private final int chiseledNeededOverall = 8;
    private int wallsStillNeeded;
    private int pillarsStillNeeded;
    private int chiseledStillNeeded;

    public BlockPocketManagerScreen(BlockPocketManagerMenu container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.te = container.te;
        this.size = this.te.size;
        this.isOwner = container.isOwner;
        this.storage = container.storage;
        if (this.storage) {
            this.field_146999_f = 256;
        }
        this.field_147000_g = !this.storage ? 194 : 240;
    }

    public void func_231160_c_() {
        int[] nArray;
        super.func_231160_c_();
        int width = this.storage ? 123 : this.field_146999_f;
        int widgetWidth = this.storage ? 110 : 120;
        int widgetOffset = widgetWidth / 2;
        if (this.storage) {
            int[] nArray2 = new int[5];
            nArray2[0] = -76;
            nArray2[1] = -100;
            nArray2[2] = -52;
            nArray2[3] = -28;
            nArray = nArray2;
            nArray2[4] = -4;
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = -40;
            nArray3[1] = -70;
            nArray3[2] = 23;
            nArray3[3] = 47;
            nArray = nArray3;
            nArray3[4] = 71;
        }
        int[] yOffset = nArray;
        this.toggleButton = new ExtendedButton(this.field_147003_i + width / 2 - widgetOffset, this.field_147009_r + this.field_147000_g / 2 + yOffset[0], widgetWidth, 20, (ITextComponent)Utils.localize("gui.securitycraft:blockPocketManager." + (!this.te.enabled ? "activate" : "deactivate"), new Object[0]), this::toggleButtonClicked);
        this.func_230480_a_((Widget)this.toggleButton);
        this.sizeButton = new ExtendedButton(this.field_147003_i + width / 2 - widgetOffset, this.field_147009_r + this.field_147000_g / 2 + yOffset[1], widgetWidth, 20, (ITextComponent)Utils.localize("gui.securitycraft:blockPocketManager.size", this.size, this.size, this.size), this::sizeButtonClicked);
        this.func_230480_a_((Widget)this.sizeButton);
        this.assembleButton = new ExtendedButton(this.field_147003_i + width / 2 - widgetOffset, this.field_147009_r + this.field_147000_g / 2 + yOffset[2], widgetWidth, 20, (ITextComponent)Utils.localize("gui.securitycraft:blockPocketManager.assemble", new Object[0]), this::assembleButtonClicked);
        this.func_230480_a_((Widget)this.assembleButton);
        this.outlineButton = new ExtendedButton(this.field_147003_i + width / 2 - widgetOffset, this.field_147009_r + this.field_147000_g / 2 + yOffset[3], widgetWidth, 20, (ITextComponent)Utils.localize("gui.securitycraft:blockPocketManager.outline." + (!this.te.showOutline ? "show" : "hide"), new Object[0]), this::outlineButtonClicked);
        this.func_230480_a_((Widget)this.outlineButton);
        this.offsetSlider = new NamedSlider((ITextComponent)Utils.localize("gui.securitycraft:projector.offset", this.te.autoBuildOffset), StringTextComponent.field_240750_d_, this.field_147003_i + width / 2 - widgetOffset, this.field_147009_r + this.field_147000_g / 2 + yOffset[4], widgetWidth, 20, (ITextComponent)Utils.localize("gui.securitycraft:projector.offset", ""), "", (-this.size + 2) / 2, (this.size - 2) / 2, this.te.autoBuildOffset, false, true, null, this::offsetSliderReleased);
        this.func_230480_a_((Widget)this.offsetSlider);
        this.offsetSlider.updateSlider();
        if (!this.te.getOwner().isOwner((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            this.offsetSlider.field_230693_o_ = false;
            this.outlineButton.field_230693_o_ = false;
            this.assembleButton.field_230693_o_ = false;
            this.toggleButton.field_230693_o_ = false;
            this.sizeButton.field_230693_o_ = false;
        } else {
            this.updateMaterialInformation(true);
            this.offsetSlider.field_230693_o_ = !this.te.enabled;
            this.sizeButton.field_230693_o_ = this.offsetSlider.field_230693_o_;
        }
        if (!this.storage) {
            this.hoverCheckers[0] = new StackHoverChecker(BLOCK_POCKET_WALL, this.field_147009_r + 93, this.field_147009_r + 113, this.field_147003_i + 23, this.field_147003_i + 43);
            this.hoverCheckers[1] = new StackHoverChecker(REINFORCED_CRYSTAL_QUARTZ_PILLAR, this.field_147009_r + 93, this.field_147009_r + 113, this.field_147003_i + 75, this.field_147003_i + 95);
            this.hoverCheckers[2] = new StackHoverChecker(REINFORCED_CHISELED_CRYSTAL_QUARTZ, this.field_147009_r + 93, this.field_147009_r + 113, this.field_147003_i + 128, this.field_147003_i + 148);
        } else {
            this.hoverCheckers[0] = new StackHoverChecker(BLOCK_POCKET_WALL, this.field_147009_r + this.field_147000_g - 73, this.field_147009_r + this.field_147000_g - 54, this.field_147003_i + 174, this.field_147003_i + 191);
            this.hoverCheckers[1] = new StackHoverChecker(REINFORCED_CRYSTAL_QUARTZ_PILLAR, this.field_147009_r + this.field_147000_g - 50, this.field_147009_r + this.field_147000_g - 31, this.field_147003_i + 174, this.field_147003_i + 191);
            this.hoverCheckers[2] = new StackHoverChecker(REINFORCED_CHISELED_CRYSTAL_QUARTZ, this.field_147009_r + this.field_147000_g - 27, this.field_147009_r + this.field_147000_g - 9, this.field_147003_i + 174, this.field_147003_i + 191);
        }
        this.assembleHoverChecker = new TextHoverChecker((Widget)this.assembleButton, Arrays.asList(Utils.localize("gui.securitycraft:blockPocketManager.needStorageModule", new Object[0]), Utils.localize("messages.securitycraft:blockpocket.notEnoughItems", new Object[0])));
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.blockPocketManager, (float)((this.storage ? 123 : this.field_146999_f) / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.blockPocketManager) / 2), 6.0f, 0x404040);
        if (this.storage) {
            this.field_230712_o_.func_243248_b(matrix, this.field_213127_e.func_145748_c_(), 8.0f, (float)(this.field_147000_g - 94), 0x404040);
            this.func_230459_a_(matrix, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (!this.te.enabled && this.isOwner) {
            if (!this.storage) {
                this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.youNeed, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.youNeed) / 2), 83.0f, 0x404040);
                this.field_230712_o_.func_238421_b_(matrix, this.wallsNeededOverall + "", 42.0f, 100.0f, 0x404040);
                this.field_230706_i_.func_175599_af().func_180450_b(BLOCK_POCKET_WALL, 25, 96);
                this.field_230712_o_.func_238421_b_(matrix, this.pillarsNeededOverall + "", 94.0f, 100.0f, 0x404040);
                this.field_230706_i_.func_175599_af().func_180450_b(REINFORCED_CRYSTAL_QUARTZ_PILLAR, 77, 96);
                this.field_230712_o_.func_238421_b_(matrix, "8", 147.0f, 100.0f, 0x404040);
                this.field_230706_i_.func_175599_af().func_180450_b(REINFORCED_CHISELED_CRYSTAL_QUARTZ, 130, 96);
            } else {
                this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.youNeed, (float)(212 - this.field_230712_o_.func_238414_a_((ITextProperties)this.youNeed) / 2), (float)(this.field_147000_g - 83), 0x404040);
                this.field_230712_o_.func_238421_b_(matrix, Math.max(0, this.wallsStillNeeded) + "", 192.0f, (float)(this.field_147000_g - 66), 0x404040);
                this.field_230706_i_.func_175599_af().func_180450_b(BLOCK_POCKET_WALL, 175, this.field_147000_g - 70);
                this.field_230712_o_.func_238421_b_(matrix, Math.max(0, this.pillarsStillNeeded) + "", 192.0f, (float)(this.field_147000_g - 44), 0x404040);
                this.field_230706_i_.func_175599_af().func_180450_b(REINFORCED_CRYSTAL_QUARTZ_PILLAR, 175, this.field_147000_g - 48);
                this.field_230712_o_.func_238421_b_(matrix, Math.max(0, this.chiseledStillNeeded) + "", 192.0f, (float)(this.field_147000_g - 22), 0x404040);
                this.field_230706_i_.func_175599_af().func_180450_b(REINFORCED_CHISELED_CRYSTAL_QUARTZ, 175, this.field_147000_g - 26);
            }
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        if (!this.te.enabled && this.isOwner) {
            for (StackHoverChecker shc : this.hoverCheckers) {
                if (!shc.checkHover(mouseX, mouseY)) continue;
                this.func_230457_a_(matrix, shc.getStack(), mouseX, mouseY);
                return;
            }
        }
        if (!this.te.enabled && this.isOwner && !this.assembleButton.field_230693_o_ && this.assembleHoverChecker.checkHover(mouseX, mouseY)) {
            if (!this.storage) {
                GuiUtils.drawHoveringText((MatrixStack)matrix, this.assembleHoverChecker.getLines().subList(0, 1), (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
            } else {
                GuiUtils.drawHoveringText((MatrixStack)matrix, this.assembleHoverChecker.getLines().subList(1, 2), (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
            }
        }
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.storage ? TEXTURE_STORAGE : TEXTURE);
        this.func_238474_b_(matrix, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.func_184098_a(slot, slotId, mouseButton, type);
        this.updateMaterialInformation(true);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.offsetSlider.dragging) {
            this.offsetSlider.func_231048_c_(mouseX, mouseY, button);
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    private void updateMaterialInformation(boolean recalculateStoredStacks) {
        if (recalculateStoredStacks) {
            this.materialCounts[2] = 0;
            this.materialCounts[1] = 0;
            this.materialCounts[0] = 0;
            this.te.getStorageHandler().ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (!(stack.func_77973_b() instanceof BlockItem)) continue;
                    Block block = ((BlockItem)stack.func_77973_b()).func_179223_d();
                    if (block == SCContent.BLOCK_POCKET_WALL.get()) {
                        this.materialCounts[0] = this.materialCounts[0] + stack.func_190916_E();
                        continue;
                    }
                    if (block == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                        this.materialCounts[1] = this.materialCounts[1] + stack.func_190916_E();
                        continue;
                    }
                    if (block != SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()) continue;
                    this.materialCounts[2] = this.materialCounts[2] + stack.func_190916_E();
                }
            });
        }
        this.wallsNeededOverall = (this.size - 2) * (this.size - 2) * 6;
        this.pillarsNeededOverall = (this.size - 2) * 12 - 1;
        this.wallsStillNeeded = this.wallsNeededOverall - this.materialCounts[0];
        this.pillarsStillNeeded = this.pillarsNeededOverall - this.materialCounts[1];
        this.chiseledStillNeeded = 8 - this.materialCounts[2];
        this.assembleButton.field_230693_o_ = this.isOwner && (this.field_230706_i_.field_71439_g.func_184812_l_() || !this.te.enabled && this.storage && this.wallsStillNeeded <= 0 && this.pillarsStillNeeded <= 0 && this.chiseledStillNeeded <= 0);
    }

    public void toggleButtonClicked(Button button) {
        if (this.te.enabled) {
            this.te.disableMultiblock();
        } else {
            this.te.size = this.size;
            TranslationTextComponent feedback = this.te.enableMultiblock();
            if (feedback != null) {
                PlayerUtils.sendMessageToPlayer((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (IFormattableTextComponent)Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)feedback, TextFormatting.DARK_AQUA, true);
            }
        }
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
    }

    public void sizeButtonClicked(Button button) {
        this.size += 4;
        if (this.size > 25) {
            this.size = 5;
        }
        int newMin = (-this.size + 2) / 2;
        int newMax = (this.size - 2) / 2;
        int newOffset = this.te.autoBuildOffset > 0 ? Math.min(this.te.autoBuildOffset, newMax) : Math.max(this.te.autoBuildOffset, newMin);
        this.updateMaterialInformation(false);
        this.te.size = this.size;
        this.offsetSlider.minValue = newMin;
        this.offsetSlider.maxValue = newMax;
        this.te.autoBuildOffset = newOffset;
        this.offsetSlider.setValue((double)newOffset);
        this.offsetSlider.updateSlider();
        button.func_238482_a_((ITextComponent)Utils.localize("gui.securitycraft:blockPocketManager.size", this.size, this.size, this.size));
        this.sync();
    }

    public void assembleButtonClicked(Button button) {
        this.te.size = this.size;
        IFormattableTextComponent feedback = this.te.autoAssembleMultiblock();
        if (feedback != null) {
            PlayerUtils.sendMessageToPlayer((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (IFormattableTextComponent)Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).func_149739_a(), new Object[0]), feedback, TextFormatting.DARK_AQUA, true);
        }
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
    }

    public void outlineButtonClicked(Button button) {
        this.te.toggleOutline();
        this.outlineButton.func_238482_a_((ITextComponent)Utils.localize("gui.securitycraft:blockPocketManager.outline." + (!this.te.showOutline ? "show" : "hide"), new Object[0]));
        this.sync();
    }

    public void offsetSliderReleased(Slider slider) {
        this.te.autoBuildOffset = slider.getValueInt();
        this.sync();
    }

    private void sync() {
        SecurityCraft.channel.send(PacketDistributor.SERVER.noArg(), (Object)new SyncBlockPocketManager(this.te.func_174877_v(), this.te.size, this.te.showOutline, this.te.autoBuildOffset));
    }
}

