/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.inventory.CustomizeBlockMenu;
import net.geforcemods.securitycraft.network.server.ToggleOption;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.screen.components.NamedSlider;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import net.minecraftforge.fml.client.gui.widget.Slider;

@OnlyIn(value=Dist.CLIENT)
public class CustomizeBlockScreen
extends ContainerScreen<CustomizeBlockMenu>
implements IHasExtraAreas {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("securitycraft:textures/gui/container/customize0.png"), new ResourceLocation("securitycraft:textures/gui/container/customize1.png"), new ResourceLocation("securitycraft:textures/gui/container/customize2.png"), new ResourceLocation("securitycraft:textures/gui/container/customize3.png"), new ResourceLocation("securitycraft:textures/gui/container/customize4.png"), new ResourceLocation("securitycraft:textures/gui/container/customize5.png")};
    private final List<Rectangle2d> extraAreas = new ArrayList<Rectangle2d>();
    private IModuleInventory moduleInv;
    private PictureButton[] descriptionButtons = new PictureButton[5];
    private Button[] optionButtons = new Button[5];
    private HoverChecker[] hoverCheckers = new HoverChecker[10];
    private final String blockName;

    public CustomizeBlockScreen(CustomizeBlockMenu container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.moduleInv = container.moduleInv;
        this.blockName = container.moduleInv.getTileEntity().func_195044_w().func_177230_c().func_149739_a().substring(5);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int numberOfColumns = 2;
        for (int i = 0; i < this.moduleInv.getMaxNumberOfModules(); ++i) {
            int column = i % 2;
            this.descriptionButtons[i] = new PictureButton(this.field_147003_i + 127 + column * 22, this.field_147009_r + 16 + Math.floorDiv(i, 2) * 22, 20, 20, this.field_230707_j_, new ItemStack((IItemProvider)this.moduleInv.acceptedModules()[i].getItem()));
            this.func_230480_a_((Widget)this.descriptionButtons[i]);
            this.hoverCheckers[i] = new HoverChecker((Widget)this.descriptionButtons[i]);
        }
        TileEntity te = this.moduleInv.getTileEntity();
        if (te instanceof ICustomizable && ((ICustomizable)te).customOptions() != null) {
            ICustomizable customizableTe = (ICustomizable)te;
            for (int i = 0; i < customizableTe.customOptions().length; ++i) {
                Option<?> option = customizableTe.customOptions()[i];
                if (option instanceof Slider.ISlider && option.isSlider()) {
                    TranslationTextComponent translatedBlockName = Utils.localize(this.blockName, new Object[0]);
                    if (option instanceof Option.DoubleOption) {
                        this.optionButtons[i] = new NamedSlider((ITextComponent)Utils.localize("option" + this.blockName + "." + option.getName(), option.toString()), (ITextComponent)translatedBlockName, this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, StringTextComponent.field_240750_d_, "", (Double)((Option.DoubleOption)option).getMin(), (Double)((Option.DoubleOption)option).getMax(), (Double)((Option.DoubleOption)option).get(), true, false, (Slider.ISlider)option, null);
                    } else if (option instanceof Option.IntOption) {
                        this.optionButtons[i] = new NamedSlider((ITextComponent)Utils.localize("option" + this.blockName + "." + option.getName(), option.toString()), (ITextComponent)translatedBlockName, this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, StringTextComponent.field_240750_d_, "", (Integer)((Option.IntOption)option).getMin(), (Integer)((Option.IntOption)option).getMax(), (Integer)((Option.IntOption)option).get(), true, false, (Slider.ISlider)option, null);
                    }
                    this.optionButtons[i].setFGColor(0xE0E0E0);
                } else {
                    this.optionButtons[i] = new ExtendedButton(this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, this.getOptionButtonTitle(option), this::optionButtonClicked);
                    this.optionButtons[i].setFGColor(option.toString().equals(option.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0);
                }
                this.func_230480_a_((Widget)this.optionButtons[i]);
                this.hoverCheckers[i + this.moduleInv.getMaxNumberOfModules()] = new HoverChecker((Widget)this.optionButtons[i]);
            }
        }
        for (Button button : this.optionButtons) {
            if (button == null) continue;
            this.extraAreas.add(new Rectangle2d(button.field_230690_l_, button.field_230691_m_, button.func_230998_h_(), button.func_238483_d_()));
        }
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        for (Button b : this.optionButtons) {
            if (!(b instanceof Slider) || !((Slider)b).dragging) continue;
            ((Slider)b).func_231048_c_(mouseX, mouseY, button);
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().func_75211_c().func_190926_b()) {
            this.func_230457_a_(matrix, this.getSlotUnderMouse().func_75211_c(), mouseX, mouseY);
        }
        for (int i = 0; i < this.hoverCheckers.length; ++i) {
            if (this.hoverCheckers[i] == null || !this.hoverCheckers[i].checkHover(mouseX, mouseY)) continue;
            if (i < this.moduleInv.getMaxNumberOfModules()) {
                this.func_238654_b_(matrix, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)this.getModuleDescription(i), 150), mouseX, mouseY);
                continue;
            }
            this.func_238654_b_(matrix, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)this.getOptionDescription(i), 150), mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        TranslationTextComponent s = Utils.localize(this.moduleInv.getTileEntity().func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)s, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)s) / 2), 6.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrix, Utils.INVENTORY_TEXT, 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURES[this.moduleInv.getMaxNumberOfModules()]);
        this.func_238474_b_(matrix, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void optionButtonClicked(Button button) {
        for (int i = 0; i < this.optionButtons.length; ++i) {
            if (button != this.optionButtons[i]) continue;
            Option<?> tempOption = ((ICustomizable)this.moduleInv.getTileEntity()).customOptions()[i];
            tempOption.toggle();
            button.setFGColor(tempOption.toString().equals(tempOption.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0);
            button.func_238482_a_(this.getOptionButtonTitle(tempOption));
            SecurityCraft.channel.sendToServer((Object)new ToggleOption(this.moduleInv.getTileEntity().func_174877_v().func_177958_n(), this.moduleInv.getTileEntity().func_174877_v().func_177956_o(), this.moduleInv.getTileEntity().func_174877_v().func_177952_p(), i));
            return;
        }
    }

    private ITextComponent getModuleDescription(int buttonID) {
        String moduleDescription = "module" + this.blockName + "." + this.descriptionButtons[buttonID].getItemStack().func_77977_a().substring(5).replace("securitycraft.", "") + ".description";
        return Utils.localize(this.descriptionButtons[buttonID].getItemStack().func_77977_a(), new Object[0]).func_230529_a_((ITextComponent)new StringTextComponent(":")).func_240699_a_(TextFormatting.RESET).func_230529_a_((ITextComponent)new StringTextComponent("\n\n")).func_230529_a_((ITextComponent)Utils.localize(moduleDescription, new Object[0]));
    }

    private TranslationTextComponent getOptionDescription(int buttonID) {
        Option<?> option = ((ICustomizable)this.moduleInv.getTileEntity()).customOptions()[buttonID - this.moduleInv.getSlots()];
        String optionDescription = "option" + this.blockName + "." + option.getName() + ".description";
        return Utils.localize("gui.securitycraft:customize.tooltip", new TranslationTextComponent(optionDescription), new TranslationTextComponent("gui.securitycraft:customize.currentSetting", new Object[]{this.getValueText(option)}));
    }

    private ITextComponent getOptionButtonTitle(Option<?> option) {
        return Utils.localize("option" + this.blockName + "." + option.getName(), this.getValueText(option));
    }

    private ITextComponent getValueText(Option<?> option) {
        if (option instanceof Option.BooleanOption) {
            return new TranslationTextComponent((Boolean)((Option.BooleanOption)option).get() != false ? "gui.securitycraft:invScan.yes" : "gui.securitycraft:invScan.no");
        }
        return new StringTextComponent(option.toString());
    }

    @Override
    public List<Rectangle2d> getExtraAreas() {
        return this.extraAreas;
    }
}

