/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.inventory.InventoryScannerMenu;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InventoryScannerScreen
extends ContainerScreen<InventoryScannerMenu> {
    private static final ResourceLocation REGULAR_INVENTORY = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_gui.png");
    private static final ResourceLocation ENHANCED_INVENTORY = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_enhanced_gui.png");
    private InventoryScannerBlockEntity tileEntity;
    private boolean owns = false;
    private boolean hasRedstoneModule = false;
    private boolean hasStorageModule = false;
    private ITextComponent infoStringRedstone;
    private ITextComponent infoStringStorage;
    private static final Style UNDERLINE = Style.field_240709_b_.func_240721_b_(TextFormatting.UNDERLINE);
    private final ITextComponent redstoneModuleNotInstalled = Utils.localize("gui.securitycraft:invScan.notInstalled", Utils.localize(((ModuleItem)SCContent.REDSTONE_MODULE.get()).func_77658_a(), new Object[0]));
    private final ITextComponent storageModuleNotInstalled = Utils.localize("gui.securitycraft:invScan.notInstalled", Utils.localize(((ModuleItem)SCContent.STORAGE_MODULE.get()).func_77658_a(), new Object[0]));
    private final ITextComponent prohibitedItems = Utils.localize("gui.securitycraft:invScan.prohibitedItems", new Object[0]);
    private final ITextComponent adminMode = Utils.localize("gui.securitycraft:invScan.mode.admin", new Object[0]).func_230530_a_(UNDERLINE);
    private final ITextComponent viewMode = Utils.localize("gui.securitycraft:invScan.mode.view", new Object[0]).func_230530_a_(UNDERLINE);
    private final ITextComponent storage = Utils.localize("gui.securitycraft:invScan.storage", new Object[0]);

    public InventoryScannerScreen(InventoryScannerMenu container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tileEntity = container.te;
        this.owns = this.tileEntity.getOwner().isOwner(inv.field_70458_d);
        this.hasRedstoneModule = this.tileEntity.hasModule(ModuleType.REDSTONE);
        this.hasStorageModule = this.tileEntity.hasModule(ModuleType.STORAGE);
        this.infoStringRedstone = Utils.localize("gui.securitycraft:invScan.emit_redstone", Utils.localize("gui.securitycraft:invScan." + (this.hasRedstoneModule ? "yes" : "no"), new Object[0]));
        this.infoStringStorage = Utils.localize("gui.securitycraft:invScan.check_inv", Utils.localize("gui.securitycraft:invScan." + (this.hasStorageModule ? "yes" : "no"), new Object[0]));
        this.field_146999_f = this.hasStorageModule ? 246 : 190;
        this.field_147000_g = 196;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        RenderSystem.disableLighting();
        this.field_230712_o_.func_238418_a_((ITextProperties)this.infoStringRedstone, this.field_147003_i + 28, this.field_147009_r + 45, 150, 0x404040);
        this.field_230712_o_.func_238418_a_((ITextProperties)this.infoStringStorage, this.field_147003_i + 28, this.field_147009_r + 75, 150, 0x404040);
        ClientUtils.renderModuleInfo(matrix, ModuleType.REDSTONE, null, this.redstoneModuleNotInstalled, this.hasRedstoneModule, this.field_147003_i + 8, this.field_147009_r + 45, this.field_230708_k_, this.field_230709_l_, mouseX, mouseY);
        ClientUtils.renderModuleInfo(matrix, ModuleType.STORAGE, null, this.storageModuleNotInstalled, this.hasStorageModule, this.field_147003_i + 8, this.field_147009_r + 75, this.field_230708_k_, this.field_230709_l_, mouseX, mouseY);
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().func_75211_c().func_190926_b()) {
            this.func_230457_a_(matrix, this.getSlotUnderMouse().func_75211_c(), mouseX, mouseY);
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrix, this.prohibitedItems, 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrix, this.tileEntity.getOwner().isOwner((PlayerEntity)this.field_230706_i_.field_71439_g) ? this.adminMode : this.viewMode, 112.0f, 6.0f, 0x404040);
        if (this.hasStorageModule && this.owns) {
            this.field_230712_o_.func_243248_b(matrix, this.storage, 188.0f, 18.0f, 0x404040);
        }
        this.field_230712_o_.func_243248_b(matrix, Utils.INVENTORY_TEXT, 15.0f, (float)(this.field_147000_g - 93), 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.hasStorageModule && this.owns ? ENHANCED_INVENTORY : REGULAR_INVENTORY);
        this.func_238474_b_(matrix, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g + 30);
    }
}

