/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.inventory.ProjectorMenu;
import net.geforcemods.securitycraft.inventory.StateSelectorAccessMenu;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.screen.components.NamedSlider;
import net.geforcemods.securitycraft.screen.components.StateSelector;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ProjectorScreen
extends ContainerScreen<ProjectorMenu>
implements IHasExtraAreas {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/projector.png");
    private static final TranslationTextComponent SLOT_TOOLTIP = Utils.localize("gui.securitycraft:projector.block", new Object[0]);
    private ProjectorBlockEntity be;
    private TranslationTextComponent blockName;
    private TextHoverChecker[] hoverCheckers = new TextHoverChecker[5];
    private TextHoverChecker slotHoverChecker;
    private NamedSlider projectionWidthSlider;
    private NamedSlider projectionHeightSlider;
    private NamedSlider projectionRangeSlider;
    private NamedSlider projectionOffsetSlider;
    private StateSelector stateSelector;
    private int sliderWidth = 120;

    public ProjectorScreen(ProjectorMenu menu, PlayerInventory inv, ITextComponent text) {
        super((Container)menu, inv, text);
        this.be = menu.be;
        this.blockName = Utils.localize(this.be.func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
        this.field_147000_g = 235;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_147003_i += 90;
        int id = 0;
        int left = this.field_147003_i + (this.field_146999_f - this.sliderWidth) / 2;
        this.projectionWidthSlider = (NamedSlider)this.func_230480_a_((Widget)new NamedSlider((ITextComponent)Utils.localize("gui.securitycraft:projector.width", this.be.getProjectionWidth()), (ITextComponent)this.blockName, left, this.field_147009_r + 57, this.sliderWidth, 20, (ITextComponent)Utils.localize("gui.securitycraft:projector.width", ""), "", 1, 10, this.be.getProjectionWidth(), false, true, null, this::sliderReleased));
        this.projectionWidthSlider.setFGColor(0xE0E0E0);
        this.hoverCheckers[id++] = new TextHoverChecker((Widget)this.projectionWidthSlider, (ITextComponent)Utils.localize("gui.securitycraft:projector.width.description", new Object[0]));
        this.projectionHeightSlider = (NamedSlider)this.func_230480_a_((Widget)new NamedSlider((ITextComponent)Utils.localize("gui.securitycraft:projector.height", this.be.getProjectionHeight()), (ITextComponent)this.blockName, left, this.field_147009_r + 78, this.sliderWidth, 20, (ITextComponent)Utils.localize("gui.securitycraft:projector.height", ""), "", 1, 10, this.be.getProjectionHeight(), false, true, null, this::sliderReleased));
        this.projectionHeightSlider.setFGColor(0xE0E0E0);
        this.hoverCheckers[id++] = new TextHoverChecker((Widget)this.projectionHeightSlider, (ITextComponent)Utils.localize("gui.securitycraft:projector.height.description", new Object[0]));
        this.projectionRangeSlider = (NamedSlider)this.func_230480_a_((Widget)new NamedSlider((ITextComponent)Utils.localize("gui.securitycraft:projector.range", this.be.getProjectionRange()), (ITextComponent)this.blockName, left, this.field_147009_r + 99, this.sliderWidth, 20, (ITextComponent)Utils.localize("gui.securitycraft:projector.range", ""), "", 1, 30, this.be.getProjectionRange(), false, true, slider -> {
            if (this.be.isHorizontal()) {
                slider.func_238482_a_((ITextComponent)new StringTextComponent("").func_230529_a_(slider.dispString).func_240702_b_(Integer.toString((int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue) - 16)));
            }
        }, this::sliderReleased));
        this.projectionRangeSlider.setFGColor(0xE0E0E0);
        this.hoverCheckers[id++] = new TextHoverChecker((Widget)this.projectionRangeSlider, (ITextComponent)Utils.localize("gui.securitycraft:projector.range.description", new Object[0]));
        this.projectionOffsetSlider = (NamedSlider)this.func_230480_a_((Widget)new NamedSlider((ITextComponent)Utils.localize("gui.securitycraft:projector.offset", this.be.getProjectionOffset()), (ITextComponent)this.blockName, left, this.field_147009_r + 120, this.sliderWidth, 20, (ITextComponent)Utils.localize("gui.securitycraft:projector.offset", ""), "", -10, 10, this.be.getProjectionOffset(), false, true, null, this::sliderReleased));
        this.projectionOffsetSlider.setFGColor(0xE0E0E0);
        this.hoverCheckers[id++] = new TextHoverChecker((Widget)this.projectionOffsetSlider, (ITextComponent)Utils.localize("gui.securitycraft:projector.offset.description", new Object[0]));
        TogglePictureButton toggleButton = (TogglePictureButton)this.func_230480_a_((Widget)new TogglePictureButton(left + this.sliderWidth - 20, this.field_147009_r + 36, 20, 20, TEXTURE, new int[]{176, 192}, new int[]{0, 0}, 2, 2, b -> {
            this.be.setHorizontal(!this.be.isHorizontal());
            this.projectionRangeSlider.updateSlider();
            SecurityCraft.channel.sendToServer((Object)new SyncProjector(this.be.func_174877_v(), this.be.isHorizontal() ? 1 : 0, SyncProjector.DataType.HORIZONTAL));
        }));
        toggleButton.setCurrentIndex(this.be.isHorizontal() ? 1 : 0);
        this.hoverCheckers[id++] = new TextHoverChecker((Widget)toggleButton, Arrays.asList(Utils.localize("gui.securitycraft:projector.vertical", new Object[0]), Utils.localize("gui.securitycraft:projector.horizontal", new Object[0])));
        this.projectionRangeSlider.updateSlider();
        this.slotHoverChecker = new TextHoverChecker(this.field_147009_r + 22, this.field_147009_r + 39, this.field_147003_i + 78, this.field_147003_i + 95, (ITextComponent)SLOT_TOOLTIP);
        this.stateSelector = (StateSelector)this.func_230481_d_(new StateSelector((StateSelectorAccessMenu)this.field_147002_h, this.field_230704_d_, this.field_147003_i - 190, this.field_147009_r + 7, 0, 197, 0, -2.85f, -0.45f));
        this.stateSelector.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
        for (TextHoverChecker thc : this.hoverCheckers) {
            if (!thc.checkHover(mouseX, mouseY)) continue;
            this.func_238652_a_(matrix, thc.getName(), mouseX, mouseY);
        }
        if (this.slotHoverChecker.checkHover(mouseX, mouseY) && ((ProjectorMenu)this.field_147002_h).be.func_191420_l()) {
            this.func_238652_a_(matrix, this.slotHoverChecker.getName(), mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.blockName, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.blockName) / 2), 6.0f, 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(matrix, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.stateSelector != null) {
            this.stateSelector.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.projectionWidthSlider.dragging) {
            this.projectionWidthSlider.func_231048_c_(mouseX, mouseY, button);
        }
        if (this.projectionHeightSlider.dragging) {
            this.projectionHeightSlider.func_231048_c_(mouseX, mouseY, button);
        }
        if (this.projectionRangeSlider.dragging) {
            this.projectionRangeSlider.func_231048_c_(mouseX, mouseY, button);
        }
        if (this.projectionOffsetSlider.dragging) {
            this.projectionOffsetSlider.func_231048_c_(mouseX, mouseY, button);
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.stateSelector != null && this.stateSelector.func_231045_a_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public List<Rectangle2d> getExtraAreas() {
        if (this.stateSelector != null) {
            return this.stateSelector.getGuiExtraAreas();
        }
        return new ArrayList<Rectangle2d>();
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        if (this.stateSelector.getState() != null) {
            this.be.setProjectedState(this.stateSelector.getState());
            SecurityCraft.channel.sendToServer((Object)new SyncProjector(this.be.func_174877_v(), this.stateSelector.getState()));
        }
    }

    public void sliderReleased(NamedSlider slider) {
        int data = 0;
        SyncProjector.DataType dataType = SyncProjector.DataType.INVALID;
        if (slider == this.projectionWidthSlider) {
            data = slider.getValueInt();
            this.be.setProjectionWidth(data);
            dataType = SyncProjector.DataType.WIDTH;
        } else if (slider == this.projectionHeightSlider) {
            data = slider.getValueInt();
            this.be.setProjectionHeight(data);
            dataType = SyncProjector.DataType.HEIGHT;
        } else if (slider == this.projectionRangeSlider) {
            data = slider.getValueInt();
            this.be.setProjectionRange(data);
            dataType = SyncProjector.DataType.RANGE;
        } else if (slider == this.projectionOffsetSlider) {
            data = slider.getValueInt();
            this.be.setProjectionOffset(data);
            dataType = SyncProjector.DataType.OFFSET;
        }
        SecurityCraft.channel.sendToServer((Object)new SyncProjector(this.be.func_174877_v(), data, dataType));
    }
}

