/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.items.SCManualItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.PageGroup;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.screen.components.IngredientDisplay;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class SCManualScreen
extends Screen {
    private static final ResourceLocation PAGE = new ResourceLocation("securitycraft:textures/gui/info_book_texture.png");
    private static final ResourceLocation PAGE_WITH_SCROLL = new ResourceLocation("securitycraft:textures/gui/info_book_texture_special.png");
    private static final ResourceLocation TITLE_PAGE = new ResourceLocation("securitycraft:textures/gui/info_book_title_page.png");
    private static final ResourceLocation ICONS = new ResourceLocation("securitycraft:textures/gui/info_book_icons.png");
    private static final ResourceLocation VANILLA_BOOK = new ResourceLocation("textures/gui/book.png");
    private static final int SUBPAGE_LENGTH = 1285;
    private static int lastPage = -1;
    private final IFormattableTextComponent intro1 = Utils.localize("gui.securitycraft:scManual.intro.1", new Object[0]).func_230530_a_(Style.field_240709_b_.setUnderlined(Boolean.valueOf(true)));
    private final TranslationTextComponent ourPatrons = Utils.localize("gui.securitycraft:scManual.patreon.title", new Object[0]);
    private List<HoverChecker> hoverCheckers = new ArrayList<HoverChecker>();
    private int currentPage = lastPage;
    private NonNullList<Ingredient> recipe;
    private IngredientDisplay[] displays = new IngredientDisplay[9];
    private int startX = -1;
    private List<ITextProperties> subpages = new ArrayList<ITextProperties>();
    private List<IReorderingProcessor> author = new ArrayList<IReorderingProcessor>();
    private int currentSubpage = 0;
    private List<IReorderingProcessor> intro2;
    private PatronList patronList;
    private Button patreonLinkButton;
    private boolean explosive;
    private boolean ownable;
    private boolean passwordProtected;
    private boolean viewActivated;
    private boolean customizable;
    private boolean lockable;
    private boolean moduleInventory;
    private IngredientDisplay pageIcon;
    private TranslationTextComponent pageTitle;
    private TranslationTextComponent designedBy;
    private PageGroup pageGroup = PageGroup.NONE;

    public SCManualScreen() {
        super((ITextComponent)new TranslationTextComponent(((Item)SCContent.SC_MANUAL.get()).func_77658_a()));
    }

    public void func_231160_c_() {
        int startY = 2;
        this.startX = (this.field_230708_k_ - 256) / 2;
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.func_230480_a_((Widget)new ChangePageButton(this.startX + 210, startY + 188, true, b -> this.nextPage()));
        this.func_230480_a_((Widget)new ChangePageButton(this.startX + 16, startY + 188, false, b -> this.previousPage()));
        this.func_230480_a_((Widget)new ChangePageButton(this.startX + 180, startY + 97, true, b -> this.nextSubpage()));
        this.func_230480_a_((Widget)new ChangePageButton(this.startX + 155, startY + 97, false, b -> this.previousSubpage()));
        this.patreonLinkButton = new HyperlinkButton(this.startX + 225, 143, 16, 16, StringTextComponent.field_240750_d_, b -> this.func_230455_a_(Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.patreon.com/Geforce"))));
        this.func_230480_a_((Widget)this.patreonLinkButton);
        this.patronList = new PatronList(this.field_230706_i_, 115, 90, 50, this.startX + 125);
        this.field_230705_e_.add(this.patronList);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.displays[i * 3 + j] = new IngredientDisplay(this.startX + 101 + j * 19, 144 + i * 19);
            }
        }
        this.pageIcon = new IngredientDisplay(this.startX + 19, 22);
        this.updateRecipeAndIcons();
        SCManualItem.PAGES.sort((page1, page2) -> {
            String key1 = page1.getTitle().getString();
            String key2 = page2.getTitle().getString();
            return key1.compareTo(key2);
        });
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currentPage == -1) {
            this.field_230706_i_.func_110434_K().func_110577_a(TITLE_PAGE);
        } else if (this.recipe != null && this.recipe.size() > 0) {
            this.field_230706_i_.func_110434_K().func_110577_a(PAGE);
        } else {
            this.field_230706_i_.func_110434_K().func_110577_a(PAGE_WITH_SCROLL);
        }
        this.func_238474_b_(matrix, this.startX, 5, 0, 0, 256, 250);
        for (int i = 0; i < this.field_230710_m_.size(); ++i) {
            ((Widget)this.field_230710_m_.get(i)).func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        }
        if (this.currentPage > -1) {
            String pageNumberText = this.currentPage + 2 + "/" + (SCManualItem.PAGES.size() + 1);
            if (this.subpages.size() > 1) {
                this.field_230712_o_.func_238421_b_(matrix, this.currentSubpage + 1 + "/" + this.subpages.size(), (float)(this.startX + 205), 102.0f, 9339504);
            }
            if (this.designedBy != null) {
                this.field_230712_o_.func_238418_a_((ITextProperties)this.designedBy, this.startX + 18, 150, 75, 0);
            }
            this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.pageTitle, (float)(this.startX + 39), 27.0f, 0);
            this.field_230712_o_.func_238418_a_(this.subpages.get(this.currentSubpage), this.startX + 18, 45, 225, 0);
            this.field_230712_o_.func_238421_b_(matrix, pageNumberText, (float)(this.startX + 240 - this.field_230712_o_.func_78256_a(pageNumberText)), 182.0f, 9339504);
            this.pageIcon.render(this.field_230706_i_, partialTicks);
            this.field_230706_i_.func_110434_K().func_110577_a(ICONS);
            if (this.ownable) {
                this.func_238474_b_(matrix, this.startX + 29, 118, 1, 1, 16, 16);
            }
            if (this.passwordProtected) {
                this.func_238474_b_(matrix, this.startX + 55, 118, 18, 1, 17, 16);
            }
            if (this.viewActivated) {
                this.func_238474_b_(matrix, this.startX + 81, 118, 36, 1, 17, 16);
            }
            if (this.explosive) {
                this.func_238474_b_(matrix, this.startX + 107, 117, 54, 1, 18, 18);
            }
            if (this.customizable) {
                this.func_238474_b_(matrix, this.startX + 136, 118, 88, 1, 16, 16);
            }
            if (this.moduleInventory) {
                this.func_238474_b_(matrix, this.startX + 163, 118, 105, 1, 16, 16);
            }
            if (this.lockable) {
                this.func_238474_b_(matrix, this.startX + 189, 118, 154, 1, 16, 16);
            }
            if (this.customizable || this.moduleInventory) {
                this.func_238474_b_(matrix, this.startX + 213, 118, 72, 1, 16, 16);
            }
            for (IngredientDisplay display : this.displays) {
                display.render(this.field_230706_i_, partialTicks);
            }
            for (int i = 0; i < this.hoverCheckers.size(); ++i) {
                HoverChecker chc = this.hoverCheckers.get(i);
                if (chc == null || !chc.checkHover(mouseX, mouseY)) continue;
                if (chc instanceof TextHoverChecker && ((TextHoverChecker)chc).getName() != null) {
                    GuiUtils.drawHoveringText((MatrixStack)matrix, ((TextHoverChecker)chc).getLines(), (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
                    continue;
                }
                if (i >= this.displays.length || this.displays[i].getCurrentStack().func_190926_b()) continue;
                this.func_230457_a_(matrix, this.displays[i].getCurrentStack(), mouseX, mouseY);
            }
        } else {
            IReorderingProcessor text;
            int i;
            String pageNumberText = "1/" + (SCManualItem.PAGES.size() + 1);
            this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.intro1, (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.intro1) / 2), 22.0f, 0);
            for (i = 0; i < this.intro2.size(); ++i) {
                text = this.intro2.get(i);
                this.field_230712_o_.func_238422_b_(matrix, text, (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_243245_a(text) / 2), (float)(150 + 10 * i), 0);
            }
            for (i = 0; i < this.author.size(); ++i) {
                text = this.author.get(i);
                this.field_230712_o_.func_238422_b_(matrix, text, (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_243245_a(text) / 2), (float)(180 + 10 * i), 0);
            }
            if (this.patronList != null) {
                this.patronList.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
            }
            this.field_230712_o_.func_238421_b_(matrix, pageNumberText, (float)(this.startX + 240 - this.field_230712_o_.func_78256_a(pageNumberText)), 182.0f, 9339504);
            this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.ourPatrons, (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.ourPatrons) / 2 + 30), 40.0f, 0);
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        lastPage = this.currentPage;
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.previousSubpage();
        } else if (keyCode == 262) {
            this.nextSubpage();
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    private void hideSubpageButtonsOnMainPage() {
        ((Widget)this.field_230710_m_.get((int)2)).field_230694_p_ = this.currentPage != -1 && this.subpages.size() > 1;
        ((Widget)this.field_230710_m_.get((int)3)).field_230694_p_ = this.currentPage != -1 && this.subpages.size() > 1;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        if (Screen.func_231173_s_()) {
            for (IngredientDisplay display : this.displays) {
                if (display == null) continue;
                display.changeRenderingStack(-scroll);
            }
            if (this.pageIcon != null) {
                this.pageIcon.changeRenderingStack(-scroll);
            }
            return true;
        }
        if (this.currentPage == -1 && this.patronList != null && this.patronList.func_231047_b_(mouseX, mouseY) && !this.patronList.patrons.isEmpty()) {
            this.patronList.func_231043_a_(mouseX, mouseY, scroll);
            return true;
        }
        switch ((int)Math.signum(scroll)) {
            case -1: {
                this.nextPage();
                break;
            }
            case 1: {
                this.previousPage();
            }
        }
        ((Widget)this.field_230710_m_.get((int)2)).field_230694_p_ = this.currentPage != -1 && this.subpages.size() > 1;
        ((Widget)this.field_230710_m_.get((int)3)).field_230694_p_ = this.currentPage != -1 && this.subpages.size() > 1;
        return true;
    }

    private void nextPage() {
        ++this.currentPage;
        if (this.currentPage > SCManualItem.PAGES.size() - 1) {
            this.currentPage = -1;
        }
        this.updateRecipeAndIcons();
        this.hideSubpageButtonsOnMainPage();
    }

    private void previousPage() {
        --this.currentPage;
        if (this.currentPage < -1) {
            this.currentPage = SCManualItem.PAGES.size() - 1;
        }
        this.updateRecipeAndIcons();
        this.hideSubpageButtonsOnMainPage();
    }

    private void nextSubpage() {
        ++this.currentSubpage;
        if (this.currentSubpage == this.subpages.size()) {
            this.currentSubpage = 0;
        }
    }

    private void previousSubpage() {
        --this.currentSubpage;
        if (this.currentSubpage == -1) {
            this.currentSubpage = this.subpages.size() - 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateRecipeAndIcons() {
        this.currentSubpage = 0;
        this.hoverCheckers.clear();
        boolean bl = this.patreonLinkButton.field_230694_p_ = this.currentPage == -1;
        if (this.currentPage < 0) {
            for (IngredientDisplay display : this.displays) {
                display.setIngredient(Ingredient.field_193370_a);
            }
            this.pageIcon.setIngredient(Ingredient.field_193370_a);
            this.recipe = null;
            ((Widget)this.field_230710_m_.get((int)2)).field_230694_p_ = false;
            ((Widget)this.field_230710_m_.get((int)3)).field_230694_p_ = false;
            if (I18n.func_188566_a((String)"gui.securitycraft:scManual.author")) {
                this.author = this.field_230712_o_.func_238425_b_((ITextProperties)Utils.localize("gui.securitycraft:scManual.author", new Object[0]), 180);
            } else {
                this.author.clear();
            }
            this.intro2 = this.field_230712_o_.func_238425_b_((ITextProperties)Utils.localize("gui.securitycraft:scManual.intro.2", new Object[0]), 225);
            this.patronList.fetchPatrons();
            return;
        }
        SCManualPage page = SCManualItem.PAGES.get(this.currentPage);
        String designedBy = page.getDesignedBy();
        Item item = page.getItem();
        this.designedBy = designedBy != null && !designedBy.isEmpty() ? Utils.localize("gui.securitycraft:scManual.designedBy", designedBy) : null;
        this.recipe = null;
        this.pageGroup = page.getGroup();
        if (this.pageGroup == PageGroup.NONE) {
            for (IRecipe object : Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b()) {
                ShapedRecipe recipe;
                if (object instanceof ShapedRecipe) {
                    recipe = (ShapedRecipe)object;
                    if (recipe.func_77571_b().func_190926_b() || recipe.func_77571_b().func_77973_b() != page.getItem()) continue;
                    NonNullList nonNullList = recipe.func_192400_c();
                    NonNullList nonNullList2 = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
                    for (int i2 = 0; i2 < nonNullList.size(); ++i2) {
                        nonNullList2.set(this.getCraftMatrixPosition(i2, recipe.func_192403_f(), recipe.func_192404_g()), nonNullList.get(i2));
                    }
                    this.recipe = nonNullList2;
                } else {
                    void var8_39;
                    if (!(object instanceof ShapelessRecipe) || (recipe = (ShapelessRecipe)object).func_77571_b().func_190926_b() || recipe.func_77571_b().func_77973_b() != page.getItem() || recipe.func_199560_c().func_110623_a().endsWith("_reset")) continue;
                    NonNullList nonNullList = NonNullList.func_191197_a((int)recipe.func_192400_c().size(), (Object)Ingredient.field_193370_a);
                    boolean bl2 = false;
                    while (var8_39 < nonNullList.size()) {
                        nonNullList.set((int)var8_39, recipe.func_192400_c().get((int)var8_39));
                        ++var8_39;
                    }
                    this.recipe = nonNullList;
                }
                break;
            }
        } else if (this.pageGroup.hasRecipeGrid()) {
            void var7_28;
            HashMap<Integer, ItemStack[]> recipeStacks = new HashMap<Integer, ItemStack[]>();
            List pageItems = Arrays.stream(this.pageGroup.getItems().func_193365_a()).map(ItemStack::func_77973_b).collect(Collectors.toList());
            int stacksLeft = pageItems.size();
            boolean bl3 = false;
            while (var7_28 < 9) {
                recipeStacks.put((int)var7_28, new ItemStack[pageItems.size()]);
                ++var7_28;
            }
            for (IRecipe iRecipe : Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b()) {
                int indexToAddAt;
                ItemStack[] items;
                int n;
                NonNullList ingredients;
                ShapedRecipe recipe;
                if (stacksLeft == 0) break;
                if (iRecipe instanceof ShapedRecipe) {
                    recipe = (ShapedRecipe)iRecipe;
                    if (recipe.func_77571_b().func_190926_b() || !pageItems.contains(recipe.func_77571_b().func_77973_b())) continue;
                    ingredients = recipe.func_192400_c();
                    for (n = 0; n < ingredients.size(); ++n) {
                        items = ((Ingredient)ingredients.get(n)).func_193365_a();
                        if (items.length == 0) continue;
                        indexToAddAt = pageItems.indexOf(recipe.func_77571_b().func_77973_b());
                        ((ItemStack[])recipeStacks.get((Object)Integer.valueOf((int)this.getCraftMatrixPosition((int)n, (int)recipe.func_192403_f(), (int)recipe.func_192404_g()))))[indexToAddAt] = items[0];
                    }
                    --stacksLeft;
                    continue;
                }
                if (!(iRecipe instanceof ShapelessRecipe) || (recipe = (ShapelessRecipe)iRecipe).func_77571_b().func_190926_b() || !pageItems.contains(recipe.func_77571_b().func_77973_b()) || recipe.func_199560_c().func_110623_a().endsWith("_reset")) continue;
                ingredients = recipe.func_192400_c();
                for (n = 0; n < ingredients.size(); ++n) {
                    items = ((Ingredient)ingredients.get(n)).func_193365_a();
                    if (items.length == 0) continue;
                    indexToAddAt = pageItems.indexOf(recipe.func_77571_b().func_77973_b());
                    ((ItemStack[])recipeStacks.get((Object)Integer.valueOf((int)n)))[indexToAddAt] = items[0];
                }
                --stacksLeft;
            }
            this.recipe = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
            recipeStacks.forEach((i, stackArray) -> {
                Ingredient cfr_ignored_0 = (Ingredient)this.recipe.set(i.intValue(), (Object)Ingredient.func_234819_a_(Arrays.stream(stackArray).map(s -> s == null ? ItemStack.field_190927_a : s)));
            });
        }
        if (page.hasRecipeDescription()) {
            String name = page.getItem().getRegistryName().func_110623_a();
            this.hoverCheckers.add(new TextHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, (ITextComponent)Utils.localize("gui.securitycraft:scManual.recipe." + name, new Object[0])));
        } else if (this.pageGroup == PageGroup.REINFORCED || item == ((Block)SCContent.REINFORCED_HOPPER.get()).func_199767_j()) {
            this.recipe = null;
            this.hoverCheckers.add(new TextHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, (ITextComponent)Utils.localize("gui.securitycraft:scManual.recipe.reinforced", new Object[0])));
        } else if (this.recipe != null) {
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    this.hoverCheckers.add(new HoverChecker(144 + row * 19, 144 + row * 19 + 16, this.startX + 101 + column * 19, this.startX + 101 + column * 19 + 16));
                }
            }
        } else {
            this.hoverCheckers.add(new TextHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, (ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0])));
        }
        this.pageTitle = page.getTitle();
        if (this.pageGroup != PageGroup.NONE) {
            this.pageIcon.setIngredient(this.pageGroup.getItems());
        } else {
            this.pageIcon.setIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
        }
        this.resetTileEntityInfo();
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).func_179223_d();
            this.explosive = block instanceof IExplosive;
            if (this.explosive) {
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 107, this.startX + 107 + 16, (ITextComponent)Utils.localize("gui.securitycraft:scManual.explosiveBlock", new Object[0])));
            }
            if (block.hasTileEntity(block.func_176223_P())) {
                IModuleInventory moduleInv;
                ICustomizable scte;
                TileEntity te = block.createTileEntity(block.func_176223_P(), (IBlockReader)Minecraft.func_71410_x().field_71441_e);
                this.ownable = te instanceof IOwnable;
                if (this.ownable) {
                    this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 29, this.startX + 29 + 16, (ITextComponent)Utils.localize("gui.securitycraft:scManual.ownableBlock", new Object[0])));
                }
                if (this.passwordProtected = te instanceof IPasswordProtected) {
                    this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 55, this.startX + 55 + 16, (ITextComponent)Utils.localize("gui.securitycraft:scManual.passwordProtectedBlock", new Object[0])));
                }
                if (this.viewActivated = te instanceof IViewActivated) {
                    this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 81, this.startX + 81 + 16, (ITextComponent)Utils.localize("gui.securitycraft:scManual.viewActivatedBlock", new Object[0])));
                }
                if (te instanceof ICustomizable && (scte = (ICustomizable)te).customOptions() != null && scte.customOptions().length > 0) {
                    ArrayList<ITextComponent> arrayList = new ArrayList<ITextComponent>();
                    this.customizable = true;
                    arrayList.add((ITextComponent)Utils.localize("gui.securitycraft:scManual.options", new Object[0]));
                    arrayList.add((ITextComponent)new StringTextComponent("---"));
                    for (Option<?> option : scte.customOptions()) {
                        arrayList.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)Utils.localize("option" + block.func_149739_a().substring(5) + "." + option.getName() + ".description", new Object[0])));
                        arrayList.add(StringTextComponent.field_240750_d_);
                    }
                    arrayList.remove(arrayList.size() - 1);
                    this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 136, this.startX + 136 + 16, arrayList));
                }
                if (te instanceof IModuleInventory && (moduleInv = (IModuleInventory)te).acceptedModules() != null && moduleInv.acceptedModules().length > 0) {
                    ArrayList<ITextComponent> arrayList = new ArrayList<ITextComponent>();
                    this.moduleInventory = true;
                    arrayList.add((ITextComponent)Utils.localize("gui.securitycraft:scManual.modules", new Object[0]));
                    arrayList.add((ITextComponent)new StringTextComponent("---"));
                    for (ModuleType moduleType : moduleInv.acceptedModules()) {
                        arrayList.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)Utils.localize("module" + block.func_149739_a().substring(5) + "." + moduleType.getItem().func_77658_a().substring(5).replace("securitycraft.", "") + ".description", new Object[0])));
                        arrayList.add(StringTextComponent.field_240750_d_);
                    }
                    arrayList.remove(arrayList.size() - 1);
                    this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 163, this.startX + 163 + 16, arrayList));
                }
                if (this.lockable = te instanceof ILockable) {
                    this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 189, this.startX + 189 + 16, (ITextComponent)Utils.localize("gui.securitycraft:scManual.lockable", new Object[0])));
                }
                if (this.customizable || this.moduleInventory) {
                    this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 213, this.startX + 213 + 16, (ITextComponent)Utils.localize("gui.securitycraft:scManual.customizableBlock", new Object[0])));
                }
            }
        }
        if (this.recipe != null && this.recipe.size() > 0) {
            for (int i6 = 0; i6 < 3; ++i6) {
                for (int j = 0; j < 3; ++j) {
                    int index = i6 * 3 + j;
                    if (index >= this.recipe.size()) {
                        this.displays[index].setIngredient(Ingredient.field_193370_a);
                        continue;
                    }
                    this.displays[index].setIngredient((Ingredient)this.recipe.get(index));
                }
            }
        } else {
            for (IngredientDisplay ingredientDisplay : this.displays) {
                ingredientDisplay.setIngredient(Ingredient.field_193370_a);
            }
        }
        this.subpages = this.field_230712_o_.func_238420_b_().func_238362_b_((ITextProperties)page.getHelpInfo(), 1285, Style.field_240709_b_);
        ((Widget)this.field_230710_m_.get((int)2)).field_230694_p_ = this.currentPage != -1 && this.subpages.size() > 1;
        ((Widget)this.field_230710_m_.get((int)3)).field_230694_p_ = this.currentPage != -1 && this.subpages.size() > 1;
    }

    private void resetTileEntityInfo() {
        this.explosive = false;
        this.ownable = false;
        this.passwordProtected = false;
        this.viewActivated = false;
        this.customizable = false;
        this.lockable = false;
        this.moduleInventory = false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.patronList != null) {
            this.patronList.func_231044_a_(mouseX, mouseY, button);
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.patronList != null) {
            this.patronList.func_231048_c_(mouseX, mouseY, button);
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.patronList != null) {
            this.patronList.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    private int getCraftMatrixPosition(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    class HyperlinkButton
    extends Button {
        public HyperlinkButton(int xPos, int yPos, int width, int height, ITextComponent displayString, Button.IPressable handler) {
            super(xPos, yPos, width, height, displayString, handler);
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partial) {
            SCManualScreen.this.field_230706_i_.func_110434_K().func_110577_a(ICONS);
            this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
            this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, this.func_230449_g_() ? 138 : 122, 1, 16, 16);
        }
    }

    static class ChangePageButton
    extends ExtendedButton {
        private final int textureY;

        public ChangePageButton(int xPos, int yPos, boolean forward, Button.IPressable onClick) {
            super(xPos, yPos, 23, 13, StringTextComponent.field_240750_d_, onClick);
            this.textureY = forward ? 192 : 205;
        }

        public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(VANILLA_BOOK);
                this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, this.func_230449_g_() ? 23 : 0, this.textureY, 23, 13);
            }
        }
    }

    class PatronList
    extends ScrollPanel {
        private final String patronListLink;
        private final int slotHeight = 12;
        private final ExecutorService executor;
        private Future<List<String>> patronRequestFuture;
        private List<String> patrons;
        private boolean patronsAvailable;
        private boolean error;
        private boolean patronsRequested;
        private final int barWidth = 6;
        private final int barLeft;
        private final List<IReorderingProcessor> fetchErrorLines;
        private final List<IReorderingProcessor> noPatronsLines;
        private final ITextComponent loadingText;

        public PatronList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.patronListLink = FMLEnvironment.production ? "https://gist.githubusercontent.com/bl4ckscor3/bdda6596012b1206816db034350b5717/raw" : "https://gist.githubusercontent.com/bl4ckscor3/3196e6740774e386871a74a9606eaa61/raw";
            this.slotHeight = 12;
            this.executor = Executors.newSingleThreadExecutor();
            this.patrons = new ArrayList<String>();
            this.patronsAvailable = false;
            this.error = false;
            this.barWidth = 6;
            this.loadingText = Utils.localize("gui.securitycraft:scManual.patreon.loading", new Object[0]);
            this.barLeft = left + width - 6;
            this.fetchErrorLines = SCManualScreen.this.field_230712_o_.func_238425_b_((ITextProperties)Utils.localize("gui.securitycraft:scManual.patreon.error", new Object[0]), width);
            this.noPatronsLines = SCManualScreen.this.field_230712_o_.func_238425_b_((ITextProperties)Utils.localize("advancements.empty", new Object[0]), width - 10);
        }

        protected int getContentHeight() {
            int n = this.patrons.size();
            SCManualScreen.this.field_230712_o_.getClass();
            int height = n * (9 + 3);
            if (height < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            if (this.patronsAvailable) {
                Tessellator tess = Tessellator.func_178181_a();
                BufferBuilder buffer = tess.func_178180_c();
                Minecraft client = Minecraft.func_71410_x();
                double scale = client.func_228018_at_().func_198100_s();
                int baseY = this.top + 4 - (int)this.scrollDistance;
                int extraHeight = this.getContentHeight() + 4 - this.height;
                GL11.glEnable((int)3089);
                GL11.glScissor((int)((int)((double)this.left * scale)), (int)((int)((double)client.func_228018_at_().func_198091_l() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
                this.drawGradientRect(matrix, this.left, this.top, this.right, this.bottom, -1061176398, -792740942);
                this.drawPanel(matrix, this.right, baseY, tess, mouseX, mouseY);
                RenderSystem.disableDepthTest();
                if (extraHeight > 0) {
                    int barHeight = this.getBarHeight();
                    int barTop = (int)this.scrollDistance * (this.height - barHeight) / extraHeight + this.top;
                    if (barTop < this.top) {
                        barTop = this.top;
                    }
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                    buffer.func_225582_a_((double)this.barLeft, (double)this.bottom, 0.0).func_225586_a_(142, 130, 112, 255).func_181675_d();
                    buffer.func_225582_a_((double)(this.barLeft + 6), (double)this.bottom, 0.0).func_225586_a_(142, 130, 112, 255).func_181675_d();
                    buffer.func_225582_a_((double)(this.barLeft + 6), (double)this.top, 0.0).func_225586_a_(142, 130, 112, 255).func_181675_d();
                    buffer.func_225582_a_((double)this.barLeft, (double)this.top, 0.0).func_225586_a_(142, 130, 112, 255).func_181675_d();
                    tess.func_78381_a();
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                    buffer.func_225582_a_((double)this.barLeft, (double)(barTop + barHeight), 0.0).func_225586_a_(128, 112, 85, 255).func_181675_d();
                    buffer.func_225582_a_((double)(this.barLeft + 6), (double)(barTop + barHeight), 0.0).func_225586_a_(128, 112, 85, 255).func_181675_d();
                    buffer.func_225582_a_((double)(this.barLeft + 6), (double)barTop, 0.0).func_225586_a_(128, 112, 85, 255).func_181675_d();
                    buffer.func_225582_a_((double)this.barLeft, (double)barTop, 0.0).func_225586_a_(128, 112, 85, 255).func_181675_d();
                    tess.func_78381_a();
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                    buffer.func_225582_a_((double)this.barLeft, (double)(barTop + barHeight - 1), 0.0).func_225586_a_(209, 191, 161, 255).func_181675_d();
                    buffer.func_225582_a_((double)(this.barLeft + 6 - 1), (double)(barTop + barHeight - 1), 0.0).func_225586_a_(209, 191, 161, 255).func_181675_d();
                    buffer.func_225582_a_((double)(this.barLeft + 6 - 1), (double)barTop, 0.0).func_225586_a_(209, 191, 161, 255).func_181675_d();
                    buffer.func_225582_a_((double)this.barLeft, (double)barTop, 0.0).func_225586_a_(209, 191, 161, 255).func_181675_d();
                    tess.func_78381_a();
                }
                RenderSystem.enableTexture();
                RenderSystem.shadeModel((int)7424);
                RenderSystem.enableAlphaTest();
                RenderSystem.disableBlend();
                GL11.glDisable((int)3089);
                int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - 4.0f);
                int slotIndex = mouseListY / 12;
                if (mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.patrons.size() && mouseY >= this.top && mouseY <= this.bottom) {
                    String patron = this.patrons.get(slotIndex);
                    int length = SCManualScreen.this.field_230712_o_.func_78256_a(patron);
                    if (length >= this.width - 6) {
                        SCManualScreen.this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent(patron), this.left - 10, baseY + (12 * slotIndex + 12));
                    }
                }
                if (this.patrons.isEmpty()) {
                    for (int i = 0; i < this.noPatronsLines.size(); ++i) {
                        IReorderingProcessor line = this.noPatronsLines.get(i);
                        SCManualScreen.this.field_230712_o_.func_238422_b_(matrix, line, (float)(this.left + this.width / 2 - SCManualScreen.this.field_230712_o_.func_243245_a(line) / 2), (float)(this.top + 30 + i * 10), -13421773);
                    }
                }
            } else if (this.error) {
                for (int i = 0; i < this.fetchErrorLines.size(); ++i) {
                    IReorderingProcessor line = this.fetchErrorLines.get(i);
                    SCManualScreen.this.field_230712_o_.func_238422_b_(matrix, line, (float)(this.left + this.width / 2 - SCManualScreen.this.field_230712_o_.func_243245_a(line) / 2), (float)(this.top + 30 + i * 10), -5242623);
                }
            } else if (this.patronRequestFuture != null && this.patronRequestFuture.isDone()) {
                try {
                    this.patrons = this.patronRequestFuture.get();
                    this.executor.shutdown();
                    this.patronsAvailable = true;
                }
                catch (InterruptedException | ExecutionException e) {
                    this.error = true;
                }
            } else {
                SCManualScreen.this.field_230712_o_.func_243248_b(matrix, this.loadingText, (float)(this.left + this.width / 2 - SCManualScreen.this.field_230712_o_.func_238414_a_((ITextProperties)this.loadingText) / 2), (float)(this.top + 30), 0);
            }
        }

        protected void drawPanel(MatrixStack matrix, int entryRight, int relativeY, Tessellator tesselator, int mouseX, int mouseY) {
            for (int i = 0; i < this.patrons.size(); ++i) {
                String patron = this.patrons.get(i);
                if (patron == null || patron.isEmpty()) continue;
                SCManualScreen.this.field_230712_o_.func_238421_b_(matrix, patron, (float)(this.left + 2), (float)(relativeY + 12 * i), 0);
            }
        }

        public void fetchPatrons() {
            if (!this.patronsRequested) {
                this.patronRequestFuture = this.executor.submit(() -> {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(this.patronListLink).openStream()));){
                        List list = reader.lines().collect(Collectors.toList());
                        return list;
                    }
                    catch (IOException e) {
                        this.error = true;
                        return new ArrayList();
                    }
                });
                this.patronsRequested = true;
            }
        }

        public int getBarHeight() {
            int barHeight = this.height * this.height / this.getContentHeight();
            if (barHeight < 32) {
                barHeight = 32;
            }
            if (barHeight > this.height - 8) {
                barHeight = this.height - 8;
            }
            return barHeight;
        }
    }
}

