/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.network.server.SyncSSSSettingsOnServer;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class SonicSecuritySystemScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private static final ResourceLocation STREAMER_ICONS = new ResourceLocation("textures/gui/stream_indicator.png");
    private static final TranslationTextComponent SOUND_TEXT = Utils.localize("gui.securitycraft:sonic_security_system.sound", new Object[0]);
    private static final int PLAYBACK_DELAY = 10;
    private final SonicSecuritySystemBlockEntity te;
    private int xSize = 176;
    private int ySize = 166;
    private Button recordingButton;
    private Button clearButton;
    private Button powerButton;
    private Button playButton;
    private TogglePictureButton soundButton;
    private boolean playback = false;
    private int tickCount = 10;
    private int currentNote = 0;
    private boolean isOwner;

    public SonicSecuritySystemScreen(SonicSecuritySystemBlockEntity te) {
        super(te.func_200200_C_());
        this.te = te;
        this.isOwner = te.getOwner().isOwner((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }

    public void func_231023_e_() {
        if (this.playback) {
            ++this.tickCount;
            if (this.tickCount >= 10) {
                if (this.currentNote < this.te.getNumberOfNotes()) {
                    SonicSecuritySystemBlockEntity.NoteWrapper note = this.te.getRecordedNotes().get(this.currentNote++);
                    SoundEvent sound = NoteBlockInstrument.valueOf((String)note.instrumentName.toUpperCase()).func_208088_a();
                    float pitch = (float)Math.pow(2.0, (double)(note.noteID - 12) / 12.0);
                    this.tickCount = 0;
                    this.field_230706_i_.field_71441_e.func_184133_a((PlayerEntity)this.field_230706_i_.field_71439_g, this.te.func_174877_v(), sound, SoundCategory.RECORDS, 3.0f, pitch);
                } else if (this.currentNote >= this.te.getNumberOfNotes()) {
                    this.currentNote = 0;
                    this.playback = false;
                }
            }
        }
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        boolean isActive = this.te.isActive();
        boolean hasNotes = this.te.getNumberOfNotes() > 0;
        this.powerButton = (Button)this.func_230480_a_((Widget)new ExtendedButton(this.field_230708_k_ / 2 - 75, this.field_230709_l_ / 2 - 59, 150, 20, this.getPowerString(this.te.isActive()), button -> {
            boolean toggledState = !this.te.isActive();
            boolean containsNotes = this.te.getNumberOfNotes() > 0;
            this.te.setActive(toggledState);
            SecurityCraft.channel.sendToServer((Object)new SyncSSSSettingsOnServer(this.te.func_174877_v(), toggledState ? SyncSSSSettingsOnServer.DataType.POWER_ON : SyncSSSSettingsOnServer.DataType.POWER_OFF));
            this.powerButton.func_238482_a_(this.getPowerString(toggledState));
            if (!toggledState) {
                this.recordingButton.func_238482_a_(this.getRecordingString(false));
            }
            this.recordingButton.field_230693_o_ = toggledState;
            this.soundButton.field_230693_o_ = toggledState;
            this.playButton.field_230693_o_ = toggledState && containsNotes;
            this.clearButton.field_230693_o_ = toggledState && containsNotes;
        }));
        this.recordingButton = (Button)this.func_230480_a_((Widget)new ExtendedButton(this.field_230708_k_ / 2 - 75, this.field_230709_l_ / 2 - 32, 150, 20, this.getRecordingString(this.te.isRecording()), button -> {
            boolean recording = !this.te.isRecording();
            this.te.setRecording(recording);
            SecurityCraft.channel.sendToServer((Object)new SyncSSSSettingsOnServer(this.te.func_174877_v(), recording ? SyncSSSSettingsOnServer.DataType.RECORDING_ON : SyncSSSSettingsOnServer.DataType.RECORDING_OFF));
            this.recordingButton.func_238482_a_(this.getRecordingString(this.te.isRecording()));
        }));
        this.playButton = (Button)this.func_230480_a_((Widget)new ExtendedButton(this.field_230708_k_ / 2 - 75, this.field_230709_l_ / 2 - 10, 150, 20, (ITextComponent)Utils.localize("gui.securitycraft:sonic_security_system.recording.play", new Object[0]), button -> {
            if (this.te.getNumberOfNotes() > 0) {
                this.playback = true;
            }
        }));
        this.clearButton = (Button)this.func_230480_a_((Widget)new ExtendedButton(this.field_230708_k_ / 2 - 75, this.field_230709_l_ / 2 + 12, 150, 20, (ITextComponent)Utils.localize("gui.securitycraft:sonic_security_system.recording.clear", new Object[0]), button -> {
            this.te.clearNotes();
            SecurityCraft.channel.sendToServer((Object)new SyncSSSSettingsOnServer(this.te.func_174877_v(), SyncSSSSettingsOnServer.DataType.CLEAR_NOTES));
            this.playButton.field_230693_o_ = false;
            this.clearButton.field_230693_o_ = false;
        }));
        this.soundButton = (TogglePictureButton)this.func_230480_a_((Widget)new TogglePictureButton(this.field_230708_k_ / 2 + 55, this.field_230709_l_ / 2 + 52, 20, 20, STREAMER_ICONS, new int[]{0, 0}, new int[]{32, 48}, 2, 16, 16, 16, 16, 16, 64, 2, button -> {
            boolean toggledPing = !this.te.pings();
            this.te.setPings(toggledPing);
            SecurityCraft.channel.sendToServer((Object)new SyncSSSSettingsOnServer(this.te.func_174877_v(), toggledPing ? SyncSSSSettingsOnServer.DataType.SOUND_ON : SyncSSSSettingsOnServer.DataType.SOUND_OFF));
        }));
        this.soundButton.setCurrentIndex(!this.te.pings() ? 1 : 0);
        this.powerButton.field_230693_o_ = this.isOwner;
        this.recordingButton.field_230693_o_ = isActive && this.isOwner;
        this.soundButton.field_230693_o_ = isActive && this.isOwner;
        this.playButton.field_230693_o_ = isActive && hasNotes;
        this.clearButton.field_230693_o_ = isActive && hasNotes && this.isOwner;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int startX = (this.field_230708_k_ - this.xSize) / 2;
        int startY = (this.field_230709_l_ - this.ySize) / 2;
        int textWidth = this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_);
        int soundTextLength = this.field_230712_o_.func_238414_a_((ITextProperties)SOUND_TEXT);
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(matrix, startX, startY, 0, 0, this.xSize, this.ySize);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.field_230712_o_.func_243248_b(matrix, this.field_230704_d_, (float)(startX + this.xSize / 2 - textWidth / 2), (float)(startY + 6), 0x404040);
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)SOUND_TEXT, (float)(this.field_230708_k_ / 2 + 50 - soundTextLength), (float)(startY + 141), 0x404040);
    }

    public boolean func_231177_au__() {
        return false;
    }

    private ITextComponent getRecordingString(boolean recording) {
        return recording ? Utils.localize("gui.securitycraft:sonic_security_system.stop_recording", new Object[0]) : Utils.localize("gui.securitycraft:sonic_security_system.start_recording", new Object[0]);
    }

    private ITextComponent getPowerString(boolean on) {
        return on ? Utils.localize("gui.securitycraft:sonic_security_system.power.on", new Object[0]) : Utils.localize("gui.securitycraft:sonic_security_system.power.off", new Object[0]);
    }
}

