/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.geforcemods.securitycraft.inventory.StateSelectorAccessMenu;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.screen.components.ToggleComponentButton;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.StandingOrWallType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class StateSelector
extends Screen
implements IGuiEventListener,
IContainerListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/state_selector.png");
    private static final int PAGE_LENGTH = 5;
    private static final float ROTATION_SENSITIVITY = 0.1f;
    private static final Vector3f Y_DRAG_ROTATION_VECTOR = new Vector3f((float)(1.0 / Math.sqrt(2.0)), 0.0f, (float)(1.0 / Math.sqrt(2.0)));
    private static final Quaternion DEFAULT_ROTATION = ClientUtils.fromXYZDegrees(new Vector3f(15.0f, -135.0f, 0.0f));
    private static final EnumProperty<StandingOrWallType> STANDING_OR_WALL_TYPE_PROPERTY = EnumProperty.func_177709_a((String)"standing_or_wall", StandingOrWallType.class);
    private final StateSelectorAccessMenu menu;
    private final int xStart;
    private final int yStart;
    private final int slotToCheck;
    private final float previewXTranslation;
    private final float previewYTranslation;
    private final HoverChecker dragHoverChecker;
    private final List<Rectangle2d> extraAreas = new ArrayList<Rectangle2d>();
    private Item blockItem = Items.field_190931_a;
    private BlockState state = Blocks.field_150350_a.func_176223_P();
    private List<Property<?>> properties = new ArrayList();
    private TileEntity be = null;
    private TileEntityRenderer beRenderer = null;
    private List<BlockStatePropertyButton<?>> propertyButtons = new ArrayList();
    private int page;
    private int amountOfPages;
    private Button previousPageButton;
    private Button nextPageButton;
    private Matrix4f dragRotation = (Matrix4f)Util.func_200696_a((Object)new Matrix4f(), matrix -> matrix.func_226591_a_());
    private boolean clickedInDragRegion = false;
    private StandingOrWallType standingOrWallType = StandingOrWallType.NONE;

    public StateSelector(StateSelectorAccessMenu menu, ITextComponent title, int xStart, int yStart, int slotToCheck, int dragStartX, int dragStartY, float previewXTranslation, float previewYTranslation) {
        super(title);
        menu.func_75132_a(this);
        this.menu = menu;
        this.xStart = xStart;
        this.yStart = yStart;
        this.slotToCheck = slotToCheck;
        this.previewXTranslation = previewXTranslation;
        this.previewYTranslation = previewYTranslation;
        this.dragHoverChecker = new HoverChecker(dragStartY += yStart, dragStartY + 47, dragStartX += xStart, dragStartX + 47);
    }

    protected void func_231160_c_() {
        if (this.menu.getStateStack().func_77973_b() instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)this.menu.getStateStack().func_77973_b();
            BlockState savedState = this.menu.getSavedState();
            Block blockToCheck = blockItem.func_179223_d();
            this.standingOrWallType = this.menu.getStandingOrWallType();
            if (blockItem instanceof WallOrFloorItem && this.standingOrWallType == StandingOrWallType.WALL) {
                blockToCheck = ((WallOrFloorItem)blockItem).field_195947_b;
            }
            this.state = blockToCheck == savedState.func_177230_c() ? savedState : blockItem.func_179223_d().func_176223_P();
            this.blockItem = blockItem;
        }
        this.previousPageButton = new ExtendedButton(this.xStart + 69, this.yStart + 125, 20, 20, (ITextComponent)new StringTextComponent("<"), button -> this.turnPage(-1));
        this.nextPageButton = new ExtendedButton(this.xStart + 126, this.yStart + 125, 20, 20, (ITextComponent)new StringTextComponent(">"), button -> this.turnPage(1));
        this.updateButtons(true, false);
        this.extraAreas.add(new Rectangle2d(this.xStart, 0, 193, this.field_230706_i_.func_228018_at_().func_198087_p()));
    }

    public void func_230430_a_(MatrixStack pose, int mouseX, int mouseY, float partialTick) {
        IRenderTypeBuffer.Impl bufferSource = this.field_230706_i_.func_228019_au_().func_228487_b_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.field_71446_o.func_110577_a(TEXTURE);
        this.func_238474_b_(pose, this.xStart, this.yStart, 0, 0, 193, 150);
        super.func_230430_a_(pose, mouseX, mouseY, partialTick);
        this.previousPageButton.func_230430_a_(pose, mouseX, mouseY, partialTick);
        this.nextPageButton.func_230430_a_(pose, mouseX, mouseY, partialTick);
        pose.func_227860_a_();
        pose.func_227861_a_((double)this.previewXTranslation, (double)this.previewYTranslation, 0.0);
        pose.func_227866_c_().func_227870_a_().func_226592_a_(1.5f);
        pose.func_227861_a_(0.5, 0.5, 0.5);
        pose.func_227863_a_(DEFAULT_ROTATION);
        pose.func_227866_c_().func_227870_a_().func_226595_a_(this.dragRotation);
        pose.func_227861_a_(-0.5, -0.5, -0.5);
        this.renderBlockModel(this.state, pose, (IRenderTypeBuffer)bufferSource);
        if (this.beRenderer != null) {
            this.beRenderer.func_225616_a_(this.be, partialTick, pose, (IRenderTypeBuffer)bufferSource, 0xF000F0, OverlayTexture.field_229196_a_);
        }
        pose.func_227865_b_();
        for (int i = 0; i < this.propertyButtons.size(); ++i) {
            String propertyName = this.propertyButtons.get(i).getProperty().func_177701_a();
            this.field_230712_o_.func_238421_b_(pose, propertyName, (float)(this.xStart + 91 - this.field_230712_o_.func_78256_a(propertyName) - 2), (float)(this.yStart + i * 23 + 10), 0x404040);
        }
        this.field_230712_o_.func_238421_b_(pose, this.page + "/" + this.amountOfPages, (float)(this.xStart + 100), (float)(this.yStart + 130), 0x404040);
    }

    public void updateButtons(boolean updateInfo, boolean slotChanged) {
        if (updateInfo) {
            this.properties = new ArrayList(this.state.func_235904_r_());
            this.properties.removeIf(arg_0 -> ((BooleanProperty)BlockStateProperties.field_208198_y).equals(arg_0));
            if (this.blockItem instanceof WallOrFloorItem) {
                this.properties.add(0, (Property<?>)STANDING_OR_WALL_TYPE_PROPERTY);
                if (slotChanged) {
                    this.standingOrWallType = StandingOrWallType.STANDING;
                }
            } else if (slotChanged) {
                this.standingOrWallType = StandingOrWallType.NONE;
            }
            this.amountOfPages = (int)Math.ceil((float)this.properties.size() / 5.0f);
            this.page = this.amountOfPages == 0 ? 0 : 1;
            this.updateBlockEntityInfo(true);
            this.dragRotation.func_226591_a_();
        }
        int buttonY = 0;
        int pageStartIndex = (this.page - 1) * 5;
        int i = 0;
        this.field_230710_m_.removeIf(this.propertyButtons::contains);
        this.propertyButtons.clear();
        for (Property<?> property : this.properties) {
            if (i < pageStartIndex) {
                ++i;
                continue;
            }
            if (i >= pageStartIndex + 5) break;
            Collection values = property.func_177700_c();
            StandingOrWallType defaultValue = property == STANDING_OR_WALL_TYPE_PROPERTY ? this.standingOrWallType : this.state.func_177229_b(property);
            int defaultValueIndex = 0;
            for (Object o : values) {
                if (o == defaultValue) break;
                ++defaultValueIndex;
            }
            this.propertyButtons.add((BlockStatePropertyButton<?>)this.func_230480_a_((Widget)new BlockStatePropertyButton(this.xStart + 91, this.yStart + buttonY + 5, 100, 20, defaultValueIndex, property)));
            buttonY += 23;
            ++i;
        }
        if (this.previousPageButton != null) {
            boolean bl = this.previousPageButton.field_230693_o_ = this.page > 1;
        }
        if (this.nextPageButton != null) {
            this.nextPageButton.field_230693_o_ = this.page != this.amountOfPages;
        }
    }

    public void turnPage(int direction) {
        this.page = (int)((float)this.page + Math.signum(direction));
        if (this.page > this.amountOfPages) {
            this.page = 1;
        } else if (this.page < 1) {
            this.page = this.amountOfPages;
        }
        this.updateButtons(false, false);
    }

    private void updateBlockEntityInfo(boolean reset) {
        if (reset) {
            this.be = null;
            this.beRenderer = null;
        }
        if (this.state.hasTileEntity()) {
            if (this.be == null) {
                Minecraft mc = Minecraft.func_71410_x();
                this.be = this.state.createTileEntity((IBlockReader)mc.field_71441_e);
                this.be.field_145850_b = mc.field_71441_e;
                this.beRenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(this.be);
            }
            this.be.field_195045_e = this.state;
        }
    }

    public void renderBlockModel(BlockState state, MatrixStack pose, IRenderTypeBuffer bufferSource) {
        if (state.func_185901_i() == BlockRenderType.MODEL) {
            BlockRendererDispatcher blockRenderer = this.field_230706_i_.func_175602_ab();
            IBakedModel blockModel = blockRenderer.func_184389_a(state);
            int color = this.field_230706_i_.func_184125_al().func_228054_a_(state, null, null, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            blockRenderer.func_175019_b().renderModel(pose.func_227866_c_(), bufferSource.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)state, (boolean)false)), state, blockModel, r, g, b, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        }
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.clickedInDragRegion) {
            this.dragRotation.func_226602_e_();
            this.dragRotation.func_226596_a_(Vector3f.field_229180_c_.func_229193_c_((float)dragX * 0.1f));
            this.dragRotation.func_226596_a_(Y_DRAG_ROTATION_VECTOR.func_229193_c_((float)dragY * 0.1f));
            this.dragRotation.func_226602_e_();
        }
        return true;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.propertyButtons.size() && !this.propertyButtons.get(i).func_231044_a_(mouseX, mouseY, button); ++i) {
        }
        this.previousPageButton.func_231044_a_(mouseX, mouseY, button);
        this.nextPageButton.func_231044_a_(mouseX, mouseY, button);
        this.clickedInDragRegion = this.dragHoverChecker.checkHover(mouseX, mouseY);
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.clickedInDragRegion = false;
        return false;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        for (int i = 0; i < this.propertyButtons.size() && !this.propertyButtons.get(i).func_231043_a_(mouseX, mouseY, delta); ++i) {
        }
        return false;
    }

    public void func_71111_a(Container menu, int slotIndex, ItemStack newStack) {
        if (slotIndex == this.slotToCheck) {
            if (newStack.func_77973_b() instanceof BlockItem && (this.state == null || ((BlockItem)newStack.func_77973_b()).func_179223_d() != this.state.func_177230_c())) {
                this.state = ((BlockItem)newStack.func_77973_b()).func_179223_d().func_176223_P();
                this.blockItem = newStack.func_77973_b();
            } else {
                this.state = Blocks.field_150350_a.func_176223_P();
                this.blockItem = Items.field_190931_a;
            }
            this.updateButtons(true, true);
            if (this.menu != null) {
                this.menu.onStateChange(this.state);
            }
        }
    }

    public boolean func_231049_c__(boolean focus) {
        return false;
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return new ArrayList();
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
    }

    public void func_71112_a(Container container, int varToUpdate, int newValue) {
    }

    public BlockState getState() {
        return this.state;
    }

    public StandingOrWallType getStandingOrWallType() {
        return this.standingOrWallType;
    }

    public List<Rectangle2d> getGuiExtraAreas() {
        return this.extraAreas;
    }

    public class BlockStatePropertyButton<T extends Comparable<T>>
    extends ToggleComponentButton {
        private final Property<T> property;
        private T value;

        public BlockStatePropertyButton(int xPos, int yPos, int width, int height, int initialValue, Property<T> property) {
            super(xPos, yPos, width, height, null, initialValue, property.func_177700_c().size(), b -> {});
            this.property = property;
            this.onValueChange();
        }

        @Override
        public void onValueChange() {
            if (this.property != null) {
                Collection values = this.property.func_177700_c();
                int i = 0;
                for (Comparable t : values) {
                    if (i++ != this.getCurrentIndex()) continue;
                    this.value = t;
                    break;
                }
                this.func_238482_a_((ITextComponent)new StringTextComponent(this.property.func_177702_a(this.value)));
            }
        }

        public void func_230930_b_() {
            if (this.property == STANDING_OR_WALL_TYPE_PROPERTY) {
                StateSelector.this.state = StateSelector.this.standingOrWallType.getNewState((WallOrFloorItem)StateSelector.this.blockItem);
                StateSelector.this.standingOrWallType = StateSelector.this.standingOrWallType == StandingOrWallType.STANDING ? StandingOrWallType.WALL : StandingOrWallType.STANDING;
                StateSelector.this.updateButtons(true, false);
                StateSelector.this.updateBlockEntityInfo(true);
            } else {
                StateSelector.this.state = (BlockState)StateSelector.this.state.func_206870_a(this.property, this.value);
                StateSelector.this.updateBlockEntityInfo(false);
            }
            StateSelector.this.menu.onStateChange(StateSelector.this.state);
        }

        public Property<T> getProperty() {
            return this.property;
        }

        public T getValue() {
            return this.value;
        }
    }
}

