/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockReader;

public class BlockEntityRenderDelegate {
    private final Map<TileEntity, DelegateRendererInfo> renderDelegates = new HashMap<TileEntity, DelegateRendererInfo>();

    public void putDelegateFor(TileEntity originalBlockEntity, BlockState delegateState) {
        DelegateRendererInfo delegateInfo;
        if (this.renderDelegates.containsKey(originalBlockEntity) && (delegateInfo = this.renderDelegates.get(originalBlockEntity)).delegateBlockEntity.func_195044_w().func_177230_c() == delegateState.func_177230_c()) {
            ((DelegateRendererInfo)delegateInfo).delegateBlockEntity.field_195045_e = delegateState;
            return;
        }
        if (delegateState != null && delegateState.hasTileEntity()) {
            Minecraft mc = Minecraft.func_71410_x();
            TileEntity delegateBe = delegateState.createTileEntity((IBlockReader)mc.field_71441_e);
            delegateBe.field_195045_e = delegateState;
            delegateBe.field_145850_b = mc.field_71441_e;
            TileEntityRenderer delegateBeRenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(delegateBe);
            if (delegateBeRenderer != null) {
                this.renderDelegates.put(originalBlockEntity, new DelegateRendererInfo(delegateBe, delegateBeRenderer));
            }
        }
    }

    public void removeDelegateOf(TileEntity originalBlockEntity) {
        this.renderDelegates.remove(originalBlockEntity);
    }

    public boolean tryRenderDelegate(TileEntity originalBlockEntity, float partialTicks, MatrixStack pose, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        DelegateRendererInfo delegateRendererInfo = this.renderDelegates.get(originalBlockEntity);
        if (delegateRendererInfo != null) {
            delegateRendererInfo.delegateRenderer().func_225616_a_(delegateRendererInfo.delegateBlockEntity(), partialTicks, pose, buffer, combinedLight, combinedOverlay);
            return true;
        }
        return false;
    }

    private static class DelegateRendererInfo {
        private final TileEntity delegateBlockEntity;
        private final TileEntityRenderer delegateRenderer;

        public DelegateRendererInfo(TileEntity delegateBlockEntity, TileEntityRenderer delegateRenderer) {
            this.delegateBlockEntity = delegateBlockEntity;
            this.delegateRenderer = delegateRenderer;
        }

        public TileEntity delegateBlockEntity() {
            return this.delegateBlockEntity;
        }

        public TileEntityRenderer delegateRenderer() {
            return this.delegateRenderer;
        }
    }
}

