/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPistonBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ReinforcedPistonBlockStructureHelper {
    private final World world;
    private final BlockPos pistonPos;
    private final boolean extending;
    private final BlockPos blockToMove;
    private final Direction moveDirection;
    private final List<BlockPos> toMove = Lists.newArrayList();
    private final List<BlockPos> toDestroy = Lists.newArrayList();
    private final Direction facing;

    public ReinforcedPistonBlockStructureHelper(World world, BlockPos pos, Direction pistonFacing, boolean extending) {
        this.world = world;
        this.pistonPos = pos;
        this.facing = pistonFacing;
        this.extending = extending;
        if (extending) {
            this.moveDirection = pistonFacing;
            this.blockToMove = pos.func_177972_a(pistonFacing);
        } else {
            this.moveDirection = pistonFacing.func_176734_d();
            this.blockToMove = pos.func_177967_a(pistonFacing, 2);
        }
    }

    public boolean canMove() {
        BlockState state = this.world.func_180495_p(this.blockToMove);
        this.toMove.clear();
        this.toDestroy.clear();
        if (!ReinforcedPistonBlock.canPush(state, this.world, this.pistonPos, this.blockToMove, this.moveDirection, false, this.facing)) {
            if (this.extending && state.func_185905_o() == PushReaction.DESTROY) {
                this.toDestroy.add(this.blockToMove);
                return true;
            }
            return false;
        }
        if (!this.addBlockLine(this.blockToMove, this.moveDirection)) {
            return false;
        }
        for (int i = 0; i < this.toMove.size(); ++i) {
            BlockPos pos = this.toMove.get(i);
            if (!this.world.func_180495_p(pos).isStickyBlock() || this.addBranchingBlocks(pos)) continue;
            return false;
        }
        return true;
    }

    private boolean addBlockLine(BlockPos origin, Direction facing) {
        BlockState state = this.world.func_180495_p(origin);
        if (this.world.func_175623_d(origin)) {
            return true;
        }
        if (!ReinforcedPistonBlock.canPush(state, this.world, this.pistonPos, origin, this.moveDirection, false, facing)) {
            return true;
        }
        if (origin.equals((Object)this.pistonPos)) {
            return true;
        }
        if (this.toMove.contains(origin)) {
            return true;
        }
        int i = 1;
        if (i + this.toMove.size() > 12) {
            return false;
        }
        while (state.isStickyBlock()) {
            BlockPos blockpos = origin.func_177967_a(this.moveDirection.func_176734_d(), i);
            BlockState oldState = state;
            state = this.world.func_180495_p(blockpos);
            if (state.isAir((IBlockReader)this.world, blockpos) || !oldState.canStickTo(state) || !ReinforcedPistonBlock.canPush(state, this.world, this.pistonPos, blockpos, this.moveDirection, false, this.moveDirection.func_176734_d()) || blockpos.equals((Object)this.pistonPos)) break;
            if (++i + this.toMove.size() <= 12) continue;
            return false;
        }
        int l = 0;
        for (int i1 = i - 1; i1 >= 0; --i1) {
            this.toMove.add(origin.func_177967_a(this.moveDirection.func_176734_d(), i1));
            ++l;
        }
        int j1 = 1;
        while (true) {
            BlockPos offsetPos;
            int j;
            if ((j = this.toMove.indexOf(offsetPos = origin.func_177967_a(this.moveDirection, j1))) > -1) {
                this.reorderListAtCollision(l, j);
                for (int k = 0; k <= j + l; ++k) {
                    BlockPos posToPush = this.toMove.get(k);
                    if (!this.world.func_180495_p(posToPush).isStickyBlock() || this.addBranchingBlocks(posToPush)) continue;
                    return false;
                }
                return true;
            }
            state = this.world.func_180495_p(offsetPos);
            if (state.isAir((IBlockReader)this.world, offsetPos)) {
                return true;
            }
            if (!ReinforcedPistonBlock.canPush(state, this.world, this.pistonPos, offsetPos, this.moveDirection, true, this.moveDirection) || offsetPos.equals((Object)this.pistonPos)) {
                return false;
            }
            if (state.func_185905_o() == PushReaction.DESTROY) {
                this.toDestroy.add(offsetPos);
                return true;
            }
            if (this.toMove.size() >= 12) {
                return false;
            }
            this.toMove.add(offsetPos);
            ++l;
            ++j1;
        }
    }

    private void reorderListAtCollision(int offsets, int index) {
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        list.addAll(this.toMove.subList(0, index));
        list1.addAll(this.toMove.subList(this.toMove.size() - offsets, this.toMove.size()));
        list2.addAll(this.toMove.subList(index, this.toMove.size() - offsets));
        this.toMove.clear();
        this.toMove.addAll(list);
        this.toMove.addAll(list1);
        this.toMove.addAll(list2);
    }

    private boolean addBranchingBlocks(BlockPos fromPos) {
        BlockState state = this.world.func_180495_p(fromPos);
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos;
            BlockState offsetState;
            if (direction.func_176740_k() == this.moveDirection.func_176740_k() || !(offsetState = this.world.func_180495_p(offsetPos = fromPos.func_177972_a(direction))).canStickTo(state) || this.addBlockLine(offsetPos, direction)) continue;
            return false;
        }
        return true;
    }

    public List<BlockPos> getBlocksToMove() {
        return this.toMove;
    }

    public List<BlockPos> getBlocksToDestroy() {
        return this.toDestroy;
    }
}

