/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.network;

import com.google.common.base.Charsets;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.network.IClientPacketChannelHandler;
import fi.dy.masa.malilib.network.IPluginChannelHandler;
import fi.dy.masa.malilib.network.PacketSplitter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.util.ResourceLocation;

public class ClientPacketChannelHandler
implements IClientPacketChannelHandler {
    public static final ResourceLocation REGISTER = new ResourceLocation("minecraft:register");
    public static final ResourceLocation UNREGISTER = new ResourceLocation("minecraft:unregister");
    private static final ClientPacketChannelHandler INSTANCE = new ClientPacketChannelHandler();
    private final HashMap<ResourceLocation, IPluginChannelHandler> handlers = new HashMap();

    public static IClientPacketChannelHandler getInstance() {
        return INSTANCE;
    }

    private ClientPacketChannelHandler() {
    }

    @Override
    public void registerClientChannelHandler(IPluginChannelHandler handler) {
        ArrayList<ResourceLocation> toRegister = new ArrayList<ResourceLocation>();
        for (ResourceLocation channel : handler.getChannels()) {
            if (this.handlers.containsKey(channel)) continue;
            this.handlers.put(channel, handler);
            toRegister.add(channel);
        }
        if (!toRegister.isEmpty()) {
            this.sendRegisterPacket(REGISTER, toRegister);
        }
    }

    @Override
    public void unregisterClientChannelHandler(IPluginChannelHandler handler) {
        ArrayList<ResourceLocation> toUnRegister = new ArrayList<ResourceLocation>();
        for (ResourceLocation channel : handler.getChannels()) {
            if (!this.handlers.remove(channel, handler)) continue;
            toUnRegister.add(channel);
        }
        if (!toUnRegister.isEmpty()) {
            this.sendRegisterPacket(UNREGISTER, toUnRegister);
        }
    }

    public boolean processPacketFromServer(SCustomPayloadPlayPacket packet, ClientPlayNetHandler netHandler) {
        ResourceLocation channel = packet.func_149169_c();
        IPluginChannelHandler handler = this.handlers.get(channel);
        if (handler != null) {
            PacketBuffer buf = PacketSplitter.receive(netHandler, packet);
            if (buf != null) {
                handler.onPacketReceived(buf);
            }
            return true;
        }
        return false;
    }

    private void sendRegisterPacket(ResourceLocation type, List<ResourceLocation> channels) {
        String joinedChannels = channels.stream().map(ResourceLocation::toString).collect(Collectors.joining("\u0000"));
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])joinedChannels.getBytes(Charsets.UTF_8));
        CCustomPayloadPacket packet = new CCustomPayloadPacket(type, new PacketBuffer(payload));
        ClientPlayNetHandler handler = Minecraft.func_71410_x().func_147114_u();
        if (handler != null) {
            handler.func_147297_a((IPacket)packet);
        } else {
            MaLiLib.logger.warn("Failed to send register channel packet - network handler was null");
        }
    }
}

