/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class BlockShape {
    private final VoxelShape shape;

    public static BlockShape create(AxisAlignedBB box) {
        return new BlockShape(box);
    }

    public static BlockShape create(VoxelShape box) {
        return new BlockShape(box);
    }

    public static BlockShape create(double x1, double y1, double z1, double x2, double y2, double z2) {
        return BlockShape.create(VoxelShapes.func_197873_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
    }

    public static BlockShape createBlockShape(double x1, double y1, double z1, double x2, double y2, double z2) {
        return BlockShape.create(VoxelShapes.func_197873_a((double)(x1 / 16.0), (double)(y1 / 16.0), (double)(z1 / 16.0), (double)(x2 / 16.0), (double)(y2 / 16.0), (double)(z2 / 16.0)));
    }

    public static BlockShape or(BlockShape shape, BlockShape ... shapes) {
        return new BlockShape(VoxelShapes.func_216384_a((VoxelShape)shape.shape, (VoxelShape[])((VoxelShape[])Arrays.stream(shapes).map(s -> s.shape).toArray(VoxelShape[]::new))));
    }

    public static BlockShape fullCube() {
        return new BlockShape(VoxelShapes.func_197868_b());
    }

    public static BlockShape empty() {
        return new BlockShape(VoxelShapes.func_197880_a());
    }

    public static boolean intersects(BlockShape shape1, BlockShape shape2) {
        return shape1.intersects(shape2);
    }

    public BlockShape(VoxelShape shape) {
        this.shape = shape;
    }

    public BlockShape(AxisAlignedBB shape) {
        this(VoxelShapes.func_197881_a((AxisAlignedBB)shape));
    }

    public BlockShape(List<AxisAlignedBB> shapes) {
        this(VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197880_a(), (VoxelShape[])((VoxelShape[])shapes.stream().map(VoxelShapes::func_197881_a).toArray(VoxelShape[]::new))));
    }

    public List<AxisAlignedBB> toBoxes() {
        return this.shape.func_197756_d();
    }

    public void forEachBox(Consumer<AxisAlignedBB> action) {
        this.toBoxes().forEach(action);
    }

    public void forEachEdge(LineConsumer action) {
        this.shape.func_197754_a(action::apply);
    }

    public void forEachCorner(PointConsumer action) {
        this.shape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
            action.apply(x1, y1, z1);
            action.apply(x2, y1, z1);
            action.apply(x1, y1, z2);
            action.apply(x2, y1, z2);
            action.apply(x1, y2, z1);
            action.apply(x2, y2, z1);
            action.apply(x1, y2, z2);
            action.apply(x2, y2, z2);
        });
    }

    public AxisAlignedBB simplify() {
        return this.shape.func_197752_a();
    }

    public double getStart(Direction.Axis axis) {
        return this.shape.func_197762_b(axis);
    }

    public double getEnd(Direction.Axis axis) {
        return this.shape.func_197758_c(axis);
    }

    public double minX() {
        return this.getStart(Direction.Axis.X);
    }

    public double minY() {
        return this.getStart(Direction.Axis.Y);
    }

    public double minZ() {
        return this.getStart(Direction.Axis.Z);
    }

    public double maxX() {
        return this.getEnd(Direction.Axis.X);
    }

    public double maxY() {
        return this.getEnd(Direction.Axis.Y);
    }

    public double maxZ() {
        return this.getEnd(Direction.Axis.Z);
    }

    public boolean isEmpty() {
        return this.shape.func_197766_b();
    }

    public BlockShape offset(double x, double y, double z) {
        return new BlockShape(this.shape.func_197751_a(x, y, z));
    }

    public BlockShape offset(BlockPos pos) {
        return new BlockShape(this.shape.func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    public BlockShape offset(Direction direction) {
        return this.offset(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e());
    }

    public boolean intersects(BlockShape shape) {
        if (this.isEmpty() || shape.isEmpty()) {
            return false;
        }
        return this.maxX() > shape.minX() && this.minX() < shape.maxX() && this.maxY() > shape.minY() && this.minY() < shape.maxY() && this.maxZ() > shape.minZ() && this.minZ() < shape.maxZ();
    }

    public BlockShape grow(double amount) {
        return this.transformBoxes(box -> box.func_186662_g(amount));
    }

    public BlockShape shrink(double amount) {
        return this.transformBoxes(box -> box.func_186664_h(amount));
    }

    public BlockShape flip(Direction.Axis axis) {
        return this.transformBoxes(box -> new AxisAlignedBB(axis == Direction.Axis.X ? 1.0 - box.field_72340_a : box.field_72340_a, axis == Direction.Axis.Y ? 1.0 - box.field_72338_b : box.field_72338_b, axis == Direction.Axis.Z ? 1.0 - box.field_72339_c : box.field_72339_c, axis == Direction.Axis.X ? 1.0 - box.field_72336_d : box.field_72336_d, axis == Direction.Axis.Y ? 1.0 - box.field_72337_e : box.field_72337_e, axis == Direction.Axis.Z ? 1.0 - box.field_72334_f : box.field_72334_f));
    }

    public BlockShape rotate(Direction.Axis axis) {
        if (axis == null) {
            throw new IllegalArgumentException("axis must not be null!");
        }
        if (axis == Direction.Axis.X) {
            return this.transformBoxes(box -> new AxisAlignedBB(box.field_72340_a, box.field_72339_c, -box.field_72338_b + 1.0, box.field_72336_d, box.field_72334_f, -box.field_72337_e + 1.0));
        }
        if (axis == Direction.Axis.Y) {
            return this.transformBoxes(box -> new AxisAlignedBB(-box.field_72339_c + 1.0, box.field_72338_b, box.field_72340_a, -box.field_72334_f + 1.0, box.field_72337_e, box.field_72336_d));
        }
        if (axis == Direction.Axis.Z) {
            return this.transformBoxes(box -> new AxisAlignedBB(box.field_72338_b, -box.field_72340_a + 1.0, box.field_72339_c, box.field_72337_e, -box.field_72336_d + 1.0, box.field_72334_f));
        }
        return null;
    }

    private BlockShape transformBoxes(Function<AxisAlignedBB, AxisAlignedBB> transformer) {
        return new BlockShape(this.toBoxes().stream().map(transformer::apply).collect(Collectors.toList()));
    }

    @Deprecated
    public VoxelShape getUnderlying() {
        return this.shape;
    }

    public static interface PointConsumer {
        public void apply(double var1, double var3, double var5);
    }

    public static interface LineConsumer {
        public void apply(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

