/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.itsmeow.betteranimalsplus.imdlib.mixin.ModelPartAccessor;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class RenderUtil {
    private static final Map<ModelRenderer, ModelRenderer.ModelBox> cubeList = new WeakHashMap<ModelRenderer, ModelRenderer.ModelBox>();

    public static Vector3d partLocation(ModelRenderer ... parts) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (ModelRenderer part : parts) {
            x += part.field_78795_f + RenderUtil.xOffset(part);
            y += part.field_78796_g + RenderUtil.yOffset(part);
            z += part.field_78808_h + RenderUtil.zOffset(part);
        }
        return new Vector3d((double)x, (double)y, (double)z);
    }

    public static void partTranslateRotate(MatrixStack stack, ModelRenderer ... parts) {
        for (ModelRenderer part : parts) {
            RenderUtil.pointTranslate(stack, part);
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(part.field_78795_f));
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(part.field_78796_g));
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(part.field_78808_h));
        }
    }

    public static void partTranslateOffsetRotate(MatrixStack stack, ModelRenderer ... parts) {
        for (ModelRenderer part : parts) {
            RenderUtil.offsetTranslate(stack, part);
            RenderUtil.pointTranslate(stack, part);
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(part.field_78795_f));
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(part.field_78796_g));
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(part.field_78808_h));
        }
    }

    public static void partScaleTranslate(MatrixStack stack, ModelRenderer part, float scale) {
        RenderUtil.offsetTranslate(stack, part);
        RenderUtil.pointTranslate(stack, part);
        RenderUtil.scale(stack, scale);
        RenderUtil.negativeOffsetTranslate(stack, part);
        RenderUtil.negativePointTranslate(stack, part);
    }

    public static void partScaleTranslate(MatrixStack stack, ModelRenderer part, double scale) {
        RenderUtil.partScaleTranslate(stack, part, (float)scale);
    }

    public static void partScaleTranslate(MatrixStack stack, ModelRenderer part, float scaleX, float scaleY, float scaleZ) {
        RenderUtil.offsetTranslate(stack, part);
        RenderUtil.pointTranslate(stack, part);
        stack.func_227862_a_(scaleX, scaleY, scaleZ);
        RenderUtil.negativeOffsetTranslate(stack, part);
        RenderUtil.negativePointTranslate(stack, part);
    }

    public static void partScaleTranslate(MatrixStack stack, ModelRenderer part, double scaleX, double scaleY, double scaleZ) {
        RenderUtil.partScaleTranslate(stack, part, (float)scaleX, (float)scaleY, (float)scaleZ);
    }

    public static void offsetTranslate(MatrixStack stack, ModelRenderer part) {
        stack.func_227861_a_((double)RenderUtil.xOffset(part), (double)RenderUtil.yOffset(part), (double)RenderUtil.zOffset(part));
    }

    public static void negativeOffsetTranslate(MatrixStack stack, ModelRenderer part) {
        stack.func_227861_a_((double)(-RenderUtil.xOffset(part)), (double)(-RenderUtil.yOffset(part)), (double)(-RenderUtil.zOffset(part)));
    }

    public static void pointTranslate(MatrixStack stack, ModelRenderer part) {
        stack.func_227861_a_((double)(part.field_78800_c / 16.0f), (double)(part.field_78797_d / 16.0f), (double)(part.field_78798_e / 16.0f));
    }

    public static void negativePointTranslate(MatrixStack stack, ModelRenderer part) {
        stack.func_227861_a_((double)(-part.field_78800_c / 16.0f), (double)(-part.field_78797_d / 16.0f), (double)(-part.field_78798_e / 16.0f));
    }

    public static void scale(MatrixStack stack, float scale) {
        stack.func_227862_a_(scale, scale, scale);
    }

    public static void scale(MatrixStack stack, double scale) {
        RenderUtil.scale(stack, (float)scale);
    }

    public static float xOffset(ModelRenderer part) {
        return RenderUtil.getPartBox((ModelRenderer)part).field_78252_a / 16.0f;
    }

    public static float yOffset(ModelRenderer part) {
        return RenderUtil.getPartBox((ModelRenderer)part).field_78250_b / 16.0f;
    }

    public static float zOffset(ModelRenderer part) {
        return RenderUtil.getPartBox((ModelRenderer)part).field_78251_c / 16.0f;
    }

    private static ModelRenderer.ModelBox getPartBox(ModelRenderer part) {
        ModelRenderer.ModelBox res = cubeList.get(part);
        if (res == null) {
            res = (ModelRenderer.ModelBox)((ModelPartAccessor)part).cubes().get(0);
            cubeList.put(part, res);
        }
        return res;
    }
}

