/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.util;

import dev.itsmeow.betteranimalsplus.imdlib.block.GenericSkullBlock;
import dev.itsmeow.betteranimalsplus.imdlib.blockentity.HeadBlockEntity;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.builder.IEntityBuilder;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.EntityVariant;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.imdlib.item.ItemBlockHeadType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.Registries;
import me.shedaniel.architectury.registry.RegistrySupplier;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class HeadType {
    protected static final Set<HeadType> HEADS = new HashSet<HeadType>();
    protected static final Map<String, HeadType> HEADS_MAP = new HashMap<String, HeadType>();
    protected static final Map<ResourceLocation, HeadType> HEADS_BLOCK_MAP = new HashMap<ResourceLocation, HeadType>();
    private final String name;
    private final PlacementType placement;
    private final EntityTypeContainer<? extends LivingEntity> container;
    private final String modid;
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<Supplier<EntityModel<? extends Entity>>> modelSupplier;
    private IVariant singletonVariant;
    private final Map<IVariant, Pair<RegistrySupplier<GenericSkullBlock>, RegistrySupplier<ItemBlockHeadType>>> heads = new HashMap<IVariant, Pair<RegistrySupplier<GenericSkullBlock>, RegistrySupplier<ItemBlockHeadType>>>();
    private final Set<RegistrySupplier<ItemBlockHeadType>> items = new HashSet<RegistrySupplier<ItemBlockHeadType>>();
    private final Set<RegistrySupplier<GenericSkullBlock>> blocks = new HashSet<RegistrySupplier<GenericSkullBlock>>();
    private final Map<ResourceLocation, IVariant> reverseVariantMap = new HashMap<ResourceLocation, IVariant>();
    private final Consumer<Registries> registerVariants;

    public HeadType(String modid, ItemGroup group, String name, PlacementType placement, HeadIDMapping mapping, @Nullable Function<IVariant, String> variantMapper, @Nullable IVariant singletonVariant, @Nullable String singletonID, EntityTypeContainer<? extends LivingEntity> container) {
        this.name = name;
        this.modid = modid;
        this.placement = placement;
        this.container = container;
        if (!container.hasVariants() && mapping != HeadIDMapping.SINGLETON) {
            throw new RuntimeException("Tried to create non-singleton head type with a variantless entity!");
        }
        this.registerVariants = registries -> {
            switch (mapping) {
                case NAMES: {
                    for (IVariant variant : container.getVariants()) {
                        if (!variant.hasHead()) continue;
                        this.setupVariant((Registries)registries, variant, group, variant.getName());
                    }
                    break;
                }
                case NUMBERS: {
                    for (IVariant variant : container.getVariants()) {
                        if (!variant.hasHead()) continue;
                        this.setupVariant((Registries)registries, variant, group, String.valueOf(container.getVariants().indexOf((Object)variant) + 1));
                    }
                    break;
                }
                case CUSTOM: {
                    for (IVariant variant : container.getVariants()) {
                        if (!variant.hasHead()) continue;
                        this.setupVariant((Registries)registries, variant, group, (String)variantMapper.apply(variant));
                    }
                    break;
                }
                case SINGLETON: {
                    this.setupVariant((Registries)registries, singletonVariant, group, singletonID);
                    this.singletonVariant = singletonVariant;
                    break;
                }
            }
        };
        HEADS.add(this);
        HEADS_MAP.put(name, this);
    }

    public void register(Registries registries) {
        this.registerVariants.accept(registries);
    }

    protected void setupVariant(Registries registries, IVariant variant, ItemGroup group, String id) {
        ResourceLocation rl = new ResourceLocation(this.getMod(), this.getName() + "_" + id);
        RegistrySupplier block = registries.get(Registry.field_239711_l_).registerSupplied(rl, () -> new GenericSkullBlock(this, id));
        RegistrySupplier item = registries.get(Registry.field_239714_o_).registerSupplied(rl, () -> new ItemBlockHeadType((Block)block.get(), this, id, variant, group));
        this.heads.put(variant, (Pair<RegistrySupplier<GenericSkullBlock>, RegistrySupplier<ItemBlockHeadType>>)Pair.of((Object)block, (Object)item));
        this.blocks.add((RegistrySupplier<GenericSkullBlock>)block);
        this.items.add((RegistrySupplier<ItemBlockHeadType>)item);
        this.reverseVariantMap.put(rl, variant);
        HEADS_BLOCK_MAP.put(rl, this);
    }

    public static Set<HeadType> values() {
        return HEADS;
    }

    public static HeadType valueOf(String name) {
        return HEADS_MAP.get(name);
    }

    public static HeadType valueOf(Block block) {
        return HEADS_BLOCK_MAP.get(block);
    }

    public static GenericSkullBlock[] getAllBlocks() {
        return HeadType.values().stream().map(type -> type.getBlockObjects()).flatMap(Collection::stream).map(Supplier::get).collect(Collectors.toList()).toArray(new GenericSkullBlock[0]);
    }

    public IVariant getVariantForBlock(Block block) {
        return this.reverseVariantMap.get(Registry.field_212618_g.func_177774_c((Object)block));
    }

    public Pair<RegistrySupplier<GenericSkullBlock>, RegistrySupplier<ItemBlockHeadType>> getPairForVariant(IVariant variant) {
        return this.heads.get(variant);
    }

    public RegistrySupplier<GenericSkullBlock> getBlockForVariant(IVariant variant) {
        if (this.getPairForVariant(variant) == null) {
            return null;
        }
        return (RegistrySupplier)this.getPairForVariant(variant).getLeft();
    }

    public RegistrySupplier<ItemBlockHeadType> getItemForVariant(IVariant variant) {
        if (this.getPairForVariant(variant) == null) {
            return null;
        }
        return (RegistrySupplier)this.getPairForVariant(variant).getRight();
    }

    public RegistrySupplier<GenericSkullBlock> getSingletonBlock() {
        if (this.getPairForVariant(this.singletonVariant) == null) {
            return null;
        }
        return (RegistrySupplier)this.getPairForVariant(this.singletonVariant).getLeft();
    }

    public RegistrySupplier<ItemBlockHeadType> getSingletonItem() {
        if (this.getPairForVariant(this.singletonVariant) == null) {
            return null;
        }
        return (RegistrySupplier)this.getPairForVariant(this.singletonVariant).getRight();
    }

    public Set<RegistrySupplier<ItemBlockHeadType>> getItemObjects() {
        return this.items;
    }

    public Set<RegistrySupplier<GenericSkullBlock>> getBlockObjects() {
        return this.blocks;
    }

    public HeadBlockEntity createTE() {
        return new HeadBlockEntity(this);
    }

    public String getName() {
        return this.name;
    }

    public PlacementType getPlacementType() {
        return this.placement;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Supplier<Supplier<EntityModel<? extends Entity>>> getModelSupplier() {
        return this.modelSupplier;
    }

    public EntityTypeContainer<? extends LivingEntity> getContainer() {
        return this.container;
    }

    public IVariant getSingletonVariant() {
        return this.singletonVariant;
    }

    public void drop(MobEntity entity, int chance) {
        this.drop(entity, chance, this.getHeadID(entity).orElse(null));
    }

    public void drop(MobEntity entity, int chance, IVariant variant) {
        if (variant != null && !entity.field_70170_p.field_72995_K && !entity.func_70631_g_() && entity.func_70681_au().nextInt(chance) == 0) {
            ItemStack stack = new ItemStack((IItemProvider)this.getItemForVariant(variant).get());
            entity.func_70099_a(stack, 0.5f);
        }
    }

    private Optional<IVariant> getHeadID(MobEntity entity) {
        if (entity instanceof IVariantTypes && this.container.hasVariants()) {
            IVariantTypes ent = (IVariantTypes)entity;
            return ent.getVariant();
        }
        return Optional.of(this.singletonVariant);
    }

    public String getMod() {
        return this.modid;
    }

    public static enum PlacementType {
        FLOOR_AND_WALL,
        WALL_ONLY;

    }

    public static enum HeadIDMapping {
        NAMES,
        NUMBERS,
        CUSTOM,
        SINGLETON;

    }

    public static class Builder<T extends MobEntity, C extends EntityTypeContainer<T>, B extends IEntityBuilder<T, C, B>> {
        private final String name;
        private final B initial;
        private PlacementType placement;
        @OnlyIn(value=Dist.CLIENT)
        private Supplier<Supplier<EntityModel<?>>> modelSupplier;
        private HeadIDMapping idMapping;
        private Function<IVariant, String> customMapper;
        private IVariant singletonVariant;
        private String singletonID;
        private ItemGroup group;

        public Builder(B initial, String name) {
            this.initial = initial;
            this.name = name;
            this.placement = PlacementType.WALL_ONLY;
            this.idMapping = null;
        }

        public Builder<T, C, B> itemGroup(ItemGroup group) {
            this.group = group;
            return this;
        }

        public Builder<T, C, B> mapToNames() {
            this.idMapping = HeadIDMapping.NAMES;
            return this;
        }

        public Builder<T, C, B> mapToNumbers() {
            this.idMapping = HeadIDMapping.NUMBERS;
            return this;
        }

        public Builder<T, C, B> mapToCustom(Function<IVariant, String> customMapper) {
            this.idMapping = HeadIDMapping.CUSTOM;
            this.customMapper = customMapper;
            return this;
        }

        public Builder<T, C, B> singleton(String id, String texture) {
            this.idMapping = HeadIDMapping.SINGLETON;
            this.singletonID = id;
            this.singletonVariant = new EntityVariant(this.initial.getMod(), id, texture);
            return this;
        }

        public Builder<T, C, B> allowFloor() {
            this.placement = PlacementType.FLOOR_AND_WALL;
            return this;
        }

        public Builder<T, C, B> setModel(Supplier<Supplier<EntityModel<? extends Entity>>> modelSupplier) {
            if (Platform.getEnv() == Dist.CLIENT) {
                this.modelSupplier = modelSupplier;
            }
            return this;
        }

        public B done() {
            this.initial.setHeadBuild(this::build);
            return this.initial;
        }

        public HeadType build(C container) {
            if (this.idMapping == null) {
                throw new RuntimeException("No ID mapping set for head builder " + this.name);
            }
            HeadType type = new HeadType(this.initial.getMod(), this.group, this.name, this.placement, this.idMapping, this.customMapper, this.singletonVariant, this.singletonID, (EntityTypeContainer<? extends LivingEntity>)container);
            if (Platform.getEnv() == Dist.CLIENT) {
                type.modelSupplier = this.modelSupplier;
            }
            return type;
        }
    }
}

