/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.proxy.DefaultProxyProvider;
import blusunrize.immersiveengineering.api.wires.redstone.CapabilityRedstoneNetwork;
import blusunrize.immersiveengineering.api.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorTileEntity;
import blusunrize.immersiveengineering.common.wires.DummySyncManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class ConnectorBundledTileEntity
extends ImmersiveConnectableTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IRedstoneConnector {
    public static final List<IBundledProvider> EXTRA_SOURCES = new ArrayList<IBundledProvider>();
    private final CapabilityReference<CapabilityRedstoneNetwork.RedstoneBundleConnection> attached = CapabilityReference.forTileEntityAt(this, this::getAttachedFace, CapabilityRedstoneNetwork.REDSTONE_BUNDLE_CONNECTION);
    private boolean dirtyExtraSource = false;

    public ConnectorBundledTileEntity() {
        this((TileEntityType<? extends ConnectorBundledTileEntity>)((TileEntityType)IETileTypes.CONNECTOR_BUNDLED.get()));
    }

    public ConnectorBundledTileEntity(TileEntityType<? extends ConnectorBundledTileEntity> type) {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)type);
    }

    private DirectionalBlockPos getAttachedFace() {
        return new DirectionalBlockPos(this.field_174879_c.func_177972_a(this.getFacing()), this.getFacing().func_176734_d());
    }

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && (this.attached.isPresent() && this.attached.get().pollDirty() || this.dirtyExtraSource)) {
            this.getHandler().updateValues();
            this.dirtyExtraSource = false;
        }
    }

    public byte getValue(int redstoneChannel) {
        return this.getHandler().getValue(redstoneChannel);
    }

    private RedstoneNetworkHandler getHandler() {
        return Objects.requireNonNull(this.globalNet.getLocalNet(this.field_174879_c).getHandler(RedstoneNetworkHandler.ID, RedstoneNetworkHandler.class));
    }

    @Override
    public void onChange(ConnectionPoint cp, RedstoneNetworkHandler handler) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.attached.isPresent()) {
                this.attached.get().onChange(cp, handler, this.getFacing().func_176734_d());
            }
            BlockState stateHere = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.markContainingBlockForUpdate(stateHere);
            this.markBlockForUpdate(this.field_174879_c.func_177972_a(this.getFacing()), this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(this.getFacing())));
        }
    }

    @Override
    public void updateInput(byte[] signals, ConnectionPoint cp) {
        if (this.attached.isPresent()) {
            this.attached.get().updateInput(signals, cp, this.getFacing().func_176734_d());
        }
        DirectionalBlockPos attachedTo = this.getAttachedFace();
        for (IBundledProvider source : EXTRA_SOURCES) {
            byte[] provided = source.getEmittedState(this.field_145850_b, attachedTo.getPosition(), attachedTo.getSide());
            if (provided == null) continue;
            for (int color = 0; color < 16; ++color) {
                signals[color] = (byte)Math.max(signals[color], provided[color]);
            }
        }
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vector3i offset) {
        return "REDSTONE".equals(cableType.getCategory());
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return ConnectorBlock.DEFAULT_FACING_PROP;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
    }

    @Override
    public Vector3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        Direction side = this.getFacing().func_176734_d();
        double conRadius = con.type.getRenderDiameter() / 2.0;
        return new Vector3d(0.5 - conRadius * (double)side.func_82601_c(), 0.5 - conRadius * (double)side.func_96559_d(), 0.5 - conRadius * (double)side.func_82599_e());
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        float length = 0.625f;
        float wMin = 0.3125f;
        return EnergyConnectorTileEntity.getConnectorBounds(this.getFacing(), wMin, length);
    }

    @Override
    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)RedstoneNetworkHandler.ID);
    }

    @Override
    protected void onNeighborBlockChange(BlockPos otherPos) {
        IBundledProvider source;
        super.onNeighborBlockChange(otherPos);
        DirectionalBlockPos attachedTo = this.getAttachedFace();
        if (!otherPos.equals((Object)attachedTo.getPosition()) || this.attached.isPresent()) {
            return;
        }
        byte[] overrideState = null;
        Iterator<IBundledProvider> iterator = EXTRA_SOURCES.iterator();
        while (iterator.hasNext() && (overrideState = (source = iterator.next()).getEmittedState(this.field_145850_b, attachedTo.getPosition(), attachedTo.getSide())) == null) {
        }
        RedstoneNetworkHandler handler = this.getHandler();
        for (int color = 0; color < 16 && !this.dirtyExtraSource; ++color) {
            byte current = handler.getValue(color);
            this.dirtyExtraSource = overrideState != null ? current == overrideState[color] : current != 0;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        CapabilityRedstoneNetwork.RedstoneBundleConnection attachedConnection = this.attached.getNullable();
        if (!this.field_145850_b.field_72995_K && attachedConnection != null) {
            GlobalWireNetwork tempGlobal = new GlobalWireNetwork(false, new DefaultProxyProvider(this.field_145850_b), DummySyncManager.INSTANCE);
            tempGlobal.onConnectorLoad((IImmersiveConnectable)this, false);
            LocalWireNetwork tempLocal = tempGlobal.getLocalNet(this.field_174879_c);
            RedstoneNetworkHandler tempHandler = new RedstoneNetworkHandler(tempLocal, tempGlobal);
            attachedConnection.onChange(new ConnectionPoint(this.field_174879_c, 0), tempHandler, this.getFacing().func_176734_d());
        }
    }

    public static interface IBundledProvider {
        @Nullable
        public byte[] getEmittedState(World var1, BlockPos var2, Direction var3);
    }
}

