/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.metal.BlastFurnacePreheaterTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.stone.BlastFurnaceTileEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlastFurnaceAdvancedTileEntity
extends BlastFurnaceTileEntity {
    private CapabilityReference<IItemHandler> output = CapabilityReference.forTileEntityAt(this, () -> new DirectionalBlockPos(this.field_174879_c.func_177967_a(this.getFacing(), 2).func_177982_a(0, -1, 0), this.getFacing().func_176734_d()), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private CapabilityReference<IItemHandler> slag = CapabilityReference.forTileEntityAt(this, () -> new DirectionalBlockPos(this.field_174879_c.func_177967_a(this.getFacing(), -2).func_177982_a(0, -1, 0), this.getFacing().func_176734_d()), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private LazyOptional<IItemHandler> inputHandler = this.registerConstantCap(new IEInventoryHandler(2, (IIEInventory)this, 0, new boolean[]{true, true}, new boolean[]{false, false}));
    private LazyOptional<IItemHandler> outputHandler = this.registerConstantCap(new IEInventoryHandler(1, (IIEInventory)this, 2, new boolean[]{false}, new boolean[]{true}));
    private LazyOptional<IItemHandler> slagHandler = this.registerConstantCap(new IEInventoryHandler(1, (IIEInventory)this, 3, new boolean[]{false}, new boolean[]{true}));
    private static final BlockPos outputOffset = new BlockPos(1, 0, 0);
    private static final BlockPos slagOutputOffset = new BlockPos(1, 0, 2);
    private static final BlockPos inputOffset = new BlockPos(1, 3, 1);
    private static final Set<BlockPos> ioOffsets = ImmutableSet.of((Object)inputOffset, (Object)outputOffset, (Object)slagOutputOffset);

    public BlastFurnaceAdvancedTileEntity() {
        super(IEMultiblocks.ADVANCED_BLAST_FURNACE, (TileEntityType<? extends BlastFurnaceTileEntity>)((TileEntityType)IETileTypes.BLAST_FURNACE_ADVANCED.get()));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 8L == 0L && !this.isDummy()) {
            ItemStack stack;
            if (!((ItemStack)this.inventory.get(2)).func_190926_b()) {
                stack = (ItemStack)this.inventory.get(2);
                stack = Utils.insertStackIntoInventory(this.output, stack, false);
                this.inventory.set(2, (Object)stack);
            }
            if (!((ItemStack)this.inventory.get(3)).func_190926_b()) {
                stack = (ItemStack)this.inventory.get(3);
                stack = Utils.insertStackIntoInventory(this.slag, stack, false);
                this.inventory.set(3, (Object)stack);
            }
        }
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        if (this.posInMultiblock.func_177958_n() == 1 && this.posInMultiblock.func_177952_p() == 1 || ImmutableSet.of((Object)new BlockPos(1, 0, 2), (Object)new BlockPos(1, 1, 2), (Object)new BlockPos(1, 3, 1)).contains((Object)this.posInMultiblock)) {
            return VoxelShapes.func_197868_b();
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (new BlockPos(1, 0, 0).equals((Object)this.posInMultiblock)) {
            xMin = this.getFacing().func_176740_k() == Direction.Axis.Z ? 0.1875f : 0.0f;
            xMax = this.getFacing().func_176740_k() == Direction.Axis.Z ? 0.8125f : 1.0f;
            zMin = this.getFacing().func_176740_k() == Direction.Axis.X ? 0.1875f : 0.0f;
            zMax = this.getFacing().func_176740_k() == Direction.Axis.X ? 0.8125f : 1.0f;
            yMax = 0.8125f;
        } else {
            float indent = 1.0f;
            if (this.posInMultiblock.func_177956_o() == 0) {
                indent = this.posInMultiblock.func_177952_p() == 1 ? 0.5f : 0.3125f;
            } else if (this.posInMultiblock.func_177956_o() == 1) {
                indent = 0.5f;
            } else if (this.posInMultiblock.func_177956_o() == 2) {
                indent = 0.375f;
            }
            if (this.posInMultiblock.func_177952_p() == 2 && this.getFacing() == Direction.WEST || this.posInMultiblock.func_177952_p() == 0 && this.getFacing() == Direction.EAST || this.posInMultiblock.func_177958_n() == 0 && this.getFacing() == Direction.SOUTH || this.posInMultiblock.func_177958_n() == 2 && this.getFacing() == Direction.NORTH) {
                xMin = 1.0f - indent;
            }
            if (this.posInMultiblock.func_177952_p() == 2 && this.getFacing() == Direction.EAST || this.posInMultiblock.func_177952_p() == 0 && this.getFacing() == Direction.WEST || this.posInMultiblock.func_177958_n() == 0 && this.getFacing() == Direction.NORTH || this.posInMultiblock.func_177958_n() == 2 && this.getFacing() == Direction.SOUTH) {
                xMax = indent;
            }
            if (this.posInMultiblock.func_177952_p() == 0 && this.getFacing() == Direction.SOUTH || this.posInMultiblock.func_177952_p() == 2 && this.getFacing() == Direction.NORTH || this.posInMultiblock.func_177958_n() == 2 && this.getFacing() == Direction.EAST || this.posInMultiblock.func_177958_n() == 0 && this.getFacing() == Direction.WEST) {
                zMin = 1.0f - indent;
            }
            if (this.posInMultiblock.func_177952_p() == 0 && this.getFacing() == Direction.NORTH || this.posInMultiblock.func_177952_p() == 2 && this.getFacing() == Direction.SOUTH || this.posInMultiblock.func_177958_n() == 2 && this.getFacing() == Direction.WEST || this.posInMultiblock.func_177958_n() == 0 && this.getFacing() == Direction.EAST) {
                zMax = indent;
            }
        }
        return VoxelShapes.func_197873_a((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
    }

    @Override
    protected int getProcessSpeed() {
        int i = 1;
        for (int j = 0; j < 2; ++j) {
            i += this.getFromPreheater(j == 0, BlastFurnacePreheaterTileEntity::doSpeedup, 0).intValue();
        }
        return i;
    }

    public <V> V getFromPreheater(boolean left, Function<BlastFurnacePreheaterTileEntity, V> getter, V orElse) {
        return this.getPreheater(left).map(getter).orElse(orElse);
    }

    public Optional<BlastFurnacePreheaterTileEntity> getPreheater(boolean left) {
        Direction phf = left ? this.getFacing().func_176746_e() : this.getFacing().func_176735_f();
        BlockPos pos = this.func_174877_v().func_177982_a(0, -1, 0).func_177967_a(phf, 2);
        TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, pos);
        if (te instanceof BlastFurnacePreheaterTileEntity) {
            return Optional.of((BlastFurnacePreheaterTileEntity)te);
        }
        return Optional.empty();
    }

    @Override
    protected void turnOff() {
        super.turnOff();
        for (int j = 0; j < 2; ++j) {
            this.getFromPreheater(j == 0, BlastFurnacePreheaterTileEntity::turnOff, 0);
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        BlastFurnaceAdvancedTileEntity master;
        if (ioOffsets.contains(this.posInMultiblock) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (master = (BlastFurnaceAdvancedTileEntity)this.master()) != null) {
            if (inputOffset.equals((Object)this.posInMultiblock) && facing == Direction.UP) {
                return master.inputHandler.cast();
            }
            if (outputOffset.equals((Object)this.posInMultiblock) && facing == master.getFacing()) {
                return master.outputHandler.cast();
            }
            if (slagOutputOffset.equals((Object)this.posInMultiblock) && facing == master.getFacing().func_176734_d()) {
                return master.slagHandler.cast();
            }
        }
        return super.getCapability(capability, facing);
    }
}

