/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class IERepairItemRecipe
extends SpecialRecipe {
    public IERepairItemRecipe(ResourceLocation name) {
        super(name);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World worldIn) {
        return this.findInputSlots(inv).isPresent();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInventory inv) {
        return this.findInputSlots(inv).map(p -> this.combineStacks((ItemStack)p.getLeft(), (ItemStack)p.getRight())).orElse(ItemStack.field_190927_a);
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        return NonNullList.func_191197_a((int)(inv.func_174923_h() * inv.func_174922_i()), (Object)ItemStack.field_190927_a);
    }

    @Nonnull
    public IRecipeSerializer<IERepairItemRecipe> func_199559_b() {
        return (IRecipeSerializer)Objects.requireNonNull((SpecialRecipeSerializer)RecipeSerializers.IE_REPAIR_SERIALIZER.get());
    }

    private Optional<Pair<ItemStack, ItemStack>> findInputSlots(CraftingInventory inv) {
        Optional<Object> first = Optional.empty();
        Optional<Object> second = Optional.empty();
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            if (!this.isValidInput(stack)) {
                return Optional.empty();
            }
            if (first.isPresent() && second.isPresent()) {
                return Optional.empty();
            }
            if (first.isPresent()) {
                ItemStack existing = (ItemStack)first.get();
                if (existing.func_77973_b() != stack.func_77973_b()) {
                    return Optional.empty();
                }
                second = Optional.of(stack);
                continue;
            }
            first = Optional.of(stack);
        }
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(Pair.of((Object)((ItemStack)first.get()), (Object)((ItemStack)second.get())));
        }
        return Optional.empty();
    }

    private boolean isValidInput(ItemStack in) {
        return in.func_77973_b() instanceof IEBaseItem && ((IEBaseItem)in.func_77973_b()).isIERepairable(in);
    }

    private ItemStack combineStacks(ItemStack a, ItemStack b) {
        int remainingA = a.func_77958_k() - a.func_77952_i();
        int remainingB = a.func_77958_k() - b.func_77952_i();
        int remainingResult = remainingA + remainingB + a.func_77958_k() * 5 / 100;
        int damageResult = a.func_77958_k() - remainingResult;
        if (damageResult < 0) {
            damageResult = 0;
        }
        ItemStack result = new ItemStack((IItemProvider)a.func_77973_b());
        result.func_196085_b(damageResult);
        return result;
    }
}

