/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.mixin.accessors.MixPredicateAccess;
import blusunrize.immersiveengineering.mixin.accessors.PotionBrewingAccess;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.FluidTags;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class PotionHelper {
    public static FluidTagInput getFluidTagForType(Potion type, int amount) {
        if (type == Potions.field_185230_b || type == null) {
            return new FluidTagInput(FluidTags.field_206959_a.func_230234_a_(), amount);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("Potion", type.getRegistryName().toString());
        return new FluidTagInput(IETags.fluidPotion.func_230234_a_(), amount, nbt);
    }

    public static void applyToAllPotionRecipes(PotionRecipeProcessor out) {
        for (PotionBrewing.MixPredicate<Potion> mixPredicate : PotionBrewingAccess.getConversions()) {
            out.apply((Potion)mixPredicate.field_185200_c.get(), (Potion)mixPredicate.field_185198_a.get(), new IngredientWithSize(((MixPredicateAccess)mixPredicate).getIngredient()));
        }
        for (IBrewingRecipe recipe : BrewingRecipeRegistry.getRecipes()) {
            if (!(recipe instanceof BrewingRecipe)) continue;
            IngredientWithSize ingredient = new IngredientWithSize(((BrewingRecipe)recipe).getIngredient());
            Ingredient input = ((BrewingRecipe)recipe).getInput();
            ItemStack output = ((BrewingRecipe)recipe).getOutput();
            if (output.func_77973_b() != Items.field_151068_bn) continue;
            out.apply(PotionUtils.func_185191_c((ItemStack)output), PotionUtils.func_185191_c((ItemStack)input.func_193365_a()[0]), ingredient);
        }
    }

    public static interface PotionRecipeProcessor {
        public void apply(Potion var1, Potion var2, IngredientWithSize var3);
    }
}

