/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionRemoveMultipleOutputs;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/ArcFurnace")
@ZenCodeType.Name(value="mods.immersiveengineering.ArcFurnace")
public class ArcFurnaceRecipeManager
implements IRecipeManager {
    public IRecipeType<ArcFurnaceRecipe> getRecipeType() {
        return ArcFurnaceRecipe.TYPE;
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredientWithAmount mainIngredient, IIngredientWithAmount[] additives, int time, int energy, IItemStack[] outputs, @ZenCodeType.Optional(value="<item:minecraft:air>") IItemStack slag) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        NonNullList<ItemStack> outputList = CrTIngredientUtil.getNonNullList(outputs);
        IngredientWithSize main = CrTIngredientUtil.getIngredientWithSize(mainIngredient);
        IngredientWithSize[] additivesWithSize = CrTIngredientUtil.getIngredientsWithSize(additives);
        ArcFurnaceRecipe recipe = new ArcFurnaceRecipe(resourceLocation, outputList, main, slag.getInternal(), time, energy, additivesWithSize);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe, null));
    }

    public void removeRecipe(IItemStack output) {
        this.removeRecipe((IIngredient)output, false);
    }

    @ZenCodeType.Method
    public void removeRecipe(IIngredient output, final boolean checkSlag) {
        CraftTweakerAPI.apply((IAction)new AbstractActionRemoveMultipleOutputs<ArcFurnaceRecipe>((IRecipeManager)this, output){

            @Override
            public List<ItemStack> getAllOutputs(ArcFurnaceRecipe recipe) {
                ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>((Collection<ItemStack>)recipe.output);
                if (checkSlag) {
                    itemStacks.add(recipe.slag);
                }
                return itemStacks;
            }

            @Override
            public String describe() {
                return super.describe() + ", " + (checkSlag ? "including" : "excluding") + " slag outputs";
            }
        });
    }
}

