/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionRemoveMultipleOutputs;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Cloche")
@ZenCodeType.Name(value="mods.immersiveengineering.Cloche")
public class ClocheRecipeManager
implements IRecipeManager {
    public IRecipeType<ClocheRecipe> getRecipeType() {
        return ClocheRecipe.TYPE;
    }

    public void removeRecipe(IItemStack output) {
        this.removeRecipe((IIngredient)output);
    }

    @ZenCodeType.Method
    public void removeRecipe(IIngredient output) {
        CraftTweakerAPI.apply((IAction)new AbstractActionRemoveMultipleOutputs<ClocheRecipe>((IRecipeManager)this, output){

            @Override
            public List<ItemStack> getAllOutputs(ClocheRecipe recipe) {
                return recipe.outputs;
            }
        });
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredient seed, IIngredient soil, int time, IItemStack[] outputs, Block renderBlock, @ZenCodeType.Optional(value="\"generic\"") String renderType) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        NonNullList<ItemStack> outputList = CrTIngredientUtil.getNonNullList(outputs);
        Ingredient seedIngredient = seed.asVanillaIngredient();
        Ingredient soilIngredient = soil.asVanillaIngredient();
        if (!ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.containsKey(renderType)) {
            throw new IllegalArgumentException("Unknown Render Type: " + renderType);
        }
        ClocheRenderFunction.ClocheRenderReference renderReference = new ClocheRenderFunction.ClocheRenderReference(renderType, renderBlock);
        try {
            ClocheRecipe recipe = new ClocheRecipe(resourceLocation, (List<ItemStack>)outputList, seedIngredient, soilIngredient, time, renderReference);
            CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe, null));
        }
        catch (Exception ex) {
            CraftTweakerAPI.logThrowing((String)"Could not create Cloche recipe '%s' with renderType '%s': ", (Throwable)ex, (Object[])new Object[]{recipePath, renderType});
        }
    }
}

