/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.mixin;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.mixin.IMixinChunkDeltaUpdateS2CPacket;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier;
import fi.dy.masa.litematica.util.SchematicWorldRefresher;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.network.play.server.SUnloadChunkPacket;
import net.minecraft.util.math.SectionPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPlayNetHandler.class})
public abstract class MixinClientPlayNetworkHandler {
    @Inject(method={"onChunkData"}, at={@At(value="RETURN")})
    private void onChunkData(SChunkDataPacket packetIn, CallbackInfo ci) {
        if (Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
            SchematicWorldRefresher.INSTANCE.markSchematicChunksForRenderUpdate(packetIn.func_149273_e(), packetIn.func_149271_f());
        }
    }

    @Inject(method={"onChunkDeltaUpdate"}, at={@At(value="RETURN")})
    private void onChunkDelta(SMultiBlockChangePacket packet, CallbackInfo ci) {
        if (Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
            SectionPos pos = ((IMixinChunkDeltaUpdateS2CPacket)packet).litematica_getSection();
            SchematicWorldRefresher.INSTANCE.markSchematicChunksForRenderUpdate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            packet.func_244310_a((p, s) -> SchematicVerifier.markVerifierBlockChanges(p));
        }
    }

    @Inject(method={"onUnloadChunk"}, at={@At(value="RETURN")})
    private void onChunkUnload(SUnloadChunkPacket packet, CallbackInfo ci) {
        if (!Configs.Generic.LOAD_ENTIRE_SCHEMATICS.getBooleanValue()) {
            DataManager.getSchematicPlacementManager().onClientChunkUnload(packet.func_186940_a(), packet.func_186941_b());
        }
    }
}

