/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.mixin;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier;
import fi.dy.masa.litematica.util.SchematicWorldRefresher;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.storage.ISpawnWorldInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientWorld.class})
public abstract class MixinClientWorld
extends World {
    protected MixinClientWorld(ISpawnWorldInfo properties, RegistryKey<World> registryKey, DimensionType dimensionType, Supplier<IProfiler> profiler, boolean bl, boolean bl2, long l) {
        super(properties, registryKey, dimensionType, profiler, bl, bl2, l);
    }

    @Inject(method={"setBlockStateWithoutNeighborUpdates"}, at={@At(value="HEAD")})
    private void onInvalidateRegionAndSetBlock(BlockPos pos, BlockState state, CallbackInfo ci) {
        SchematicVerifier.markVerifierBlockChanges(pos);
        if (Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
            SchematicWorldRefresher.INSTANCE.markSchematicChunkForRenderUpdate(pos);
        }
    }
}

