/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic;

import fi.dy.masa.malilib.util.NBTUtils;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class SchematicMetadata {
    private String name = "?";
    private String author = "Unknown";
    private String description = "";
    private Vector3i enclosingSize = Vector3i.field_177959_e;
    private long timeCreated;
    private long timeModified;
    private int regionCount;
    private int totalVolume;
    private int totalBlocks;
    private int[] thumbnailPixelData;

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public int[] getPreviewImagePixelData() {
        return this.thumbnailPixelData;
    }

    public int getRegionCount() {
        return this.regionCount;
    }

    public int getTotalVolume() {
        return this.totalVolume;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public Vector3i getEnclosingSize() {
        return this.enclosingSize;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public long getTimeModified() {
        return this.timeModified;
    }

    public boolean hasBeenModified() {
        return this.timeCreated != this.timeModified;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPreviewImagePixelData(int[] pixelData) {
        this.thumbnailPixelData = pixelData;
    }

    public void setRegionCount(int regionCount) {
        this.regionCount = regionCount;
    }

    public void setTotalVolume(int totalVolume) {
        this.totalVolume = totalVolume;
    }

    public void setTotalBlocks(int totalBlocks) {
        this.totalBlocks = totalBlocks;
    }

    public void setEnclosingSize(Vector3i enclosingSize) {
        this.enclosingSize = enclosingSize;
    }

    public void setTimeCreated(long timeCreated) {
        this.timeCreated = timeCreated;
    }

    public void setTimeModified(long timeModified) {
        this.timeModified = timeModified;
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("Name", this.name);
        nbt.func_74778_a("Author", this.author);
        nbt.func_74778_a("Description", this.description);
        nbt.func_74768_a("RegionCount", this.regionCount);
        nbt.func_74768_a("TotalVolume", this.totalVolume);
        nbt.func_74768_a("TotalBlocks", this.totalBlocks);
        nbt.func_74772_a("TimeCreated", this.timeCreated);
        nbt.func_74772_a("TimeModified", this.timeModified);
        nbt.func_218657_a("EnclosingSize", (INBT)NBTUtils.createBlockPosTag((Vector3i)this.enclosingSize));
        if (this.thumbnailPixelData != null) {
            nbt.func_74783_a("PreviewImageData", this.thumbnailPixelData);
        }
        return nbt;
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.name = nbt.func_74779_i("Name");
        this.author = nbt.func_74779_i("Author");
        this.description = nbt.func_74779_i("Description");
        this.regionCount = nbt.func_74762_e("RegionCount");
        this.totalVolume = nbt.func_74762_e("TotalVolume");
        this.totalBlocks = nbt.func_74762_e("TotalBlocks");
        this.timeCreated = nbt.func_74763_f("TimeCreated");
        this.timeModified = nbt.func_74763_f("TimeModified");
        BlockPos size = NBTUtils.readBlockPos((CompoundNBT)nbt.func_74775_l("EnclosingSize"));
        if (size != null) {
            this.enclosingSize = size;
        }
        if (nbt.func_150297_b("PreviewImageData", 11)) {
            this.thumbnailPixelData = nbt.func_74759_k("PreviewImageData");
        }
    }
}

