/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.conversion;

import fi.dy.masa.litematica.mixin.IMixinFenceGateBlock;
import fi.dy.masa.litematica.mixin.IMixinRedstoneWireBlock;
import fi.dy.masa.litematica.mixin.IMixinStairsBlock;
import fi.dy.masa.litematica.mixin.IMixinVineBlock;
import fi.dy.masa.litematica.schematic.conversion.IBlockReaderWithData;
import fi.dy.masa.malilib.util.PositionUtils;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.AttachedStemBlock;
import net.minecraft.block.BannerBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChorusPlantBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.NoteBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.block.TripWireBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.WallBannerBlock;
import net.minecraft.block.WallSkullBlock;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;

public class SchematicConversionFixers {
    private static final BooleanProperty[] HORIZONTAL_CONNECTING_BLOCK_PROPS = new BooleanProperty[]{null, null, FourWayBlock.field_196409_a, FourWayBlock.field_196413_c, FourWayBlock.field_196414_y, FourWayBlock.field_196411_b};
    private static final BlockState REDSTONE_WIRE_DOT = Blocks.field_150488_af.func_176223_P();
    private static final BlockState REDSTONE_WIRE_CROSS = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_150488_af.func_176223_P().func_206870_a((Property)RedstoneWireBlock.field_176348_a, (Comparable)RedstoneSide.NONE)).func_206870_a((Property)RedstoneWireBlock.field_176347_b, (Comparable)RedstoneSide.NONE)).func_206870_a((Property)RedstoneWireBlock.field_176349_M, (Comparable)RedstoneSide.NONE)).func_206870_a((Property)RedstoneWireBlock.field_176350_N, (Comparable)RedstoneSide.NONE);
    public static final IStateFixer FIXER_BANNER = (reader, state, pos) -> {
        DyeColor colorFromData;
        DyeColor colorOrig;
        CompoundNBT tag = reader.getTileEntityData(pos);
        if (tag != null && (colorOrig = ((AbstractBannerBlock)state.func_177230_c()).func_196285_M_()) != (colorFromData = DyeColor.func_196056_a((int)(15 - tag.func_74762_e("Base"))))) {
            Integer rotation = (Integer)state.func_177229_b((Property)BannerBlock.field_176448_b);
            switch (colorFromData) {
                case WHITE: {
                    state = Blocks.field_196784_gT.func_176223_P();
                    break;
                }
                case ORANGE: {
                    state = Blocks.field_196786_gU.func_176223_P();
                    break;
                }
                case MAGENTA: {
                    state = Blocks.field_196788_gV.func_176223_P();
                    break;
                }
                case LIGHT_BLUE: {
                    state = Blocks.field_196790_gW.func_176223_P();
                    break;
                }
                case YELLOW: {
                    state = Blocks.field_196792_gX.func_176223_P();
                    break;
                }
                case LIME: {
                    state = Blocks.field_196794_gY.func_176223_P();
                    break;
                }
                case PINK: {
                    state = Blocks.field_196796_gZ.func_176223_P();
                    break;
                }
                case GRAY: {
                    state = Blocks.field_196826_ha.func_176223_P();
                    break;
                }
                case LIGHT_GRAY: {
                    state = Blocks.field_196827_hb.func_176223_P();
                    break;
                }
                case CYAN: {
                    state = Blocks.field_196829_hc.func_176223_P();
                    break;
                }
                case PURPLE: {
                    state = Blocks.field_196831_hd.func_176223_P();
                    break;
                }
                case BLUE: {
                    state = Blocks.field_196833_he.func_176223_P();
                    break;
                }
                case BROWN: {
                    state = Blocks.field_196835_hf.func_176223_P();
                    break;
                }
                case GREEN: {
                    state = Blocks.field_196837_hg.func_176223_P();
                    break;
                }
                case RED: {
                    state = Blocks.field_196839_hh.func_176223_P();
                    break;
                }
                case BLACK: {
                    state = Blocks.field_196841_hi.func_176223_P();
                }
            }
            state = (BlockState)state.func_206870_a((Property)BannerBlock.field_176448_b, (Comparable)rotation);
        }
        return state;
    };
    public static final IStateFixer FIXER_BANNER_WALL = (reader, state, pos) -> {
        DyeColor colorFromData;
        DyeColor colorOrig;
        CompoundNBT tag = reader.getTileEntityData(pos);
        if (tag != null && (colorOrig = ((AbstractBannerBlock)state.func_177230_c()).func_196285_M_()) != (colorFromData = DyeColor.func_196056_a((int)(15 - tag.func_74762_e("Base"))))) {
            Direction facing = (Direction)state.func_177229_b((Property)WallBannerBlock.field_196290_a);
            switch (colorFromData) {
                case WHITE: {
                    state = Blocks.field_196843_hj.func_176223_P();
                    break;
                }
                case ORANGE: {
                    state = Blocks.field_196845_hk.func_176223_P();
                    break;
                }
                case MAGENTA: {
                    state = Blocks.field_196847_hl.func_176223_P();
                    break;
                }
                case LIGHT_BLUE: {
                    state = Blocks.field_196849_hm.func_176223_P();
                    break;
                }
                case YELLOW: {
                    state = Blocks.field_196851_hn.func_176223_P();
                    break;
                }
                case LIME: {
                    state = Blocks.field_196853_ho.func_176223_P();
                    break;
                }
                case PINK: {
                    state = Blocks.field_196855_hp.func_176223_P();
                    break;
                }
                case GRAY: {
                    state = Blocks.field_196857_hq.func_176223_P();
                    break;
                }
                case LIGHT_GRAY: {
                    state = Blocks.field_196859_hr.func_176223_P();
                    break;
                }
                case CYAN: {
                    state = Blocks.field_196861_hs.func_176223_P();
                    break;
                }
                case PURPLE: {
                    state = Blocks.field_196863_ht.func_176223_P();
                    break;
                }
                case BLUE: {
                    state = Blocks.field_196865_hu.func_176223_P();
                    break;
                }
                case BROWN: {
                    state = Blocks.field_196867_hv.func_176223_P();
                    break;
                }
                case GREEN: {
                    state = Blocks.field_196869_hw.func_176223_P();
                    break;
                }
                case RED: {
                    state = Blocks.field_196871_hx.func_176223_P();
                    break;
                }
                case BLACK: {
                    state = Blocks.field_196873_hy.func_176223_P();
                }
            }
            state = (BlockState)state.func_206870_a((Property)WallBannerBlock.field_196290_a, (Comparable)facing);
        }
        return state;
    };
    public static final IStateFixer FIXER_BED = (reader, state, pos) -> {
        CompoundNBT tag = reader.getTileEntityData(pos);
        if (tag != null && tag.func_150297_b("color", 3)) {
            int colorId = tag.func_74762_e("color");
            Direction facing = (Direction)state.func_177229_b((Property)BedBlock.field_185512_D);
            BedPart part = (BedPart)state.func_177229_b((Property)BedBlock.field_176472_a);
            Boolean occupied = (Boolean)state.func_177229_b((Property)BedBlock.field_176471_b);
            switch (colorId) {
                case 0: {
                    state = Blocks.field_196587_am.func_176223_P();
                    break;
                }
                case 1: {
                    state = Blocks.field_196588_an.func_176223_P();
                    break;
                }
                case 2: {
                    state = Blocks.field_196589_ao.func_176223_P();
                    break;
                }
                case 3: {
                    state = Blocks.field_196590_ap.func_176223_P();
                    break;
                }
                case 4: {
                    state = Blocks.field_196592_aq.func_176223_P();
                    break;
                }
                case 5: {
                    state = Blocks.field_196593_ar.func_176223_P();
                    break;
                }
                case 6: {
                    state = Blocks.field_196594_as.func_176223_P();
                    break;
                }
                case 7: {
                    state = Blocks.field_196595_at.func_176223_P();
                    break;
                }
                case 8: {
                    state = Blocks.field_196596_au.func_176223_P();
                    break;
                }
                case 9: {
                    state = Blocks.field_196597_av.func_176223_P();
                    break;
                }
                case 10: {
                    state = Blocks.field_196598_aw.func_176223_P();
                    break;
                }
                case 11: {
                    state = Blocks.field_196599_ax.func_176223_P();
                    break;
                }
                case 12: {
                    state = Blocks.field_196600_ay.func_176223_P();
                    break;
                }
                case 13: {
                    state = Blocks.field_196601_az.func_176223_P();
                    break;
                }
                case 14: {
                    state = Blocks.field_196550_aA.func_176223_P();
                    break;
                }
                case 15: {
                    state = Blocks.field_196551_aB.func_176223_P();
                    break;
                }
                default: {
                    return state;
                }
            }
            state = (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)BedBlock.field_185512_D, (Comparable)facing)).func_206870_a((Property)BedBlock.field_176472_a, (Comparable)part)).func_206870_a((Property)BedBlock.field_176471_b, (Comparable)occupied);
        }
        return state;
    };
    public static final IStateFixer FIXER_CHRORUS_PLANT = (reader, state, pos) -> ((ChorusPlantBlock)state.func_177230_c()).func_196497_a((IBlockReader)reader, pos);
    public static final IStateFixer FIXER_DIRT_SNOWY = (reader, state, pos) -> {
        Block block = reader.func_180495_p(pos.func_177984_a()).func_177230_c();
        return (BlockState)state.func_206870_a((Property)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(block == Blocks.field_196604_cC || block == Blocks.field_150433_aE));
    };
    public static final IStateFixer FIXER_DOOR = (reader, state, pos) -> {
        if (state.func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER) {
            BlockState stateLower = reader.func_180495_p(pos.func_177977_b());
            if (stateLower.func_177230_c() == state.func_177230_c()) {
                state = (BlockState)state.func_206870_a((Property)DoorBlock.field_176520_a, stateLower.func_177229_b((Property)DoorBlock.field_176520_a));
                state = (BlockState)state.func_206870_a((Property)DoorBlock.field_176519_b, stateLower.func_177229_b((Property)DoorBlock.field_176519_b));
            }
        } else {
            BlockState stateUpper = reader.func_180495_p(pos.func_177984_a());
            if (stateUpper.func_177230_c() == state.func_177230_c()) {
                state = (BlockState)state.func_206870_a((Property)DoorBlock.field_176521_M, stateUpper.func_177229_b((Property)DoorBlock.field_176521_M));
                state = (BlockState)state.func_206870_a((Property)DoorBlock.field_176522_N, stateUpper.func_177229_b((Property)DoorBlock.field_176522_N));
            }
        }
        return state;
    };
    public static final IStateFixer FIXER_DOUBLE_PLANT = (reader, state, pos) -> {
        BlockState stateLower;
        if (state.func_177229_b((Property)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER && (stateLower = reader.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof DoublePlantBlock) {
            state = (BlockState)stateLower.func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER);
        }
        return state;
    };
    public static final IStateFixer FIXER_FENCE = (reader, state, pos) -> {
        FenceBlock fence = (FenceBlock)state.func_177230_c();
        for (Direction side : PositionUtils.HORIZONTAL_DIRECTIONS) {
            BlockPos posAdj = pos.func_177972_a(side);
            BlockState stateAdj = reader.func_180495_p(posAdj);
            Direction sideOpposite = side.func_176734_d();
            boolean flag = stateAdj.func_224755_d((IBlockReader)reader, posAdj, sideOpposite);
            state = (BlockState)state.func_206870_a((Property)HORIZONTAL_CONNECTING_BLOCK_PROPS[side.func_176745_a()], (Comparable)Boolean.valueOf(fence.func_220111_a(stateAdj, flag, sideOpposite)));
        }
        return state;
    };
    public static final IStateFixer FIXER_FENCE_GATE = (reader, state, pos) -> {
        FenceGateBlock gate = (FenceGateBlock)state.func_177230_c();
        Direction facing = (Direction)state.func_177229_b((Property)FenceGateBlock.field_185512_D);
        boolean inWall = false;
        inWall = facing.func_176740_k() == Direction.Axis.X ? ((IMixinFenceGateBlock)gate).invokeIsWall(reader.func_180495_p(pos.func_177972_a(Direction.NORTH))) || ((IMixinFenceGateBlock)gate).invokeIsWall(reader.func_180495_p(pos.func_177972_a(Direction.SOUTH))) : ((IMixinFenceGateBlock)gate).invokeIsWall(reader.func_180495_p(pos.func_177972_a(Direction.WEST))) || ((IMixinFenceGateBlock)gate).invokeIsWall(reader.func_180495_p(pos.func_177972_a(Direction.EAST)));
        return (BlockState)state.func_206870_a((Property)FenceGateBlock.field_176467_M, (Comparable)Boolean.valueOf(inWall));
    };
    public static final IStateFixer FIXER_FIRE = (reader, state, pos) -> AbstractFireBlock.func_235326_a_((IBlockReader)reader, (BlockPos)pos);
    public static final IStateFixer FIXER_FLOWER_POT = (reader, state, pos) -> {
        String itemName;
        CompoundNBT tag = reader.getTileEntityData(pos);
        if (tag != null && (itemName = tag.func_74779_i("Item")).length() > 0) {
            int meta = tag.func_74762_e("Data");
            switch (itemName) {
                case "minecraft:sapling": {
                    if (meta == 0) {
                        return Blocks.field_196746_es.func_176223_P();
                    }
                    if (meta == 1) {
                        return Blocks.field_196748_et.func_176223_P();
                    }
                    if (meta == 2) {
                        return Blocks.field_196750_eu.func_176223_P();
                    }
                    if (meta == 3) {
                        return Blocks.field_196752_ev.func_176223_P();
                    }
                    if (meta == 4) {
                        return Blocks.field_196754_ew.func_176223_P();
                    }
                    if (meta != 5) break;
                    return Blocks.field_196755_ex.func_176223_P();
                }
                case "minecraft:tallgrass": {
                    if (meta == 0) {
                        return Blocks.field_196681_eA.func_176223_P();
                    }
                    if (meta != 2) break;
                    return Blocks.field_196683_eB.func_176223_P();
                }
                case "minecraft:red_flower": {
                    if (meta == 0) {
                        return Blocks.field_196726_ei.func_176223_P();
                    }
                    if (meta == 1) {
                        return Blocks.field_196728_ej.func_176223_P();
                    }
                    if (meta == 2) {
                        return Blocks.field_196730_ek.func_176223_P();
                    }
                    if (meta == 3) {
                        return Blocks.field_196732_el.func_176223_P();
                    }
                    if (meta == 4) {
                        return Blocks.field_196734_em.func_176223_P();
                    }
                    if (meta == 5) {
                        return Blocks.field_196736_en.func_176223_P();
                    }
                    if (meta == 6) {
                        return Blocks.field_196738_eo.func_176223_P();
                    }
                    if (meta == 7) {
                        return Blocks.field_196740_ep.func_176223_P();
                    }
                    if (meta != 8) break;
                    return Blocks.field_196742_eq.func_176223_P();
                }
                case "minecraft:yellow_flower": {
                    return Blocks.field_196744_er.func_176223_P();
                }
                case "minecraft:brown_mushroom": {
                    return Blocks.field_196757_ez.func_176223_P();
                }
                case "minecraft:red_mushroom": {
                    return Blocks.field_196756_ey.func_176223_P();
                }
                case "minecraft:deadbush": {
                    return Blocks.field_196681_eA.func_176223_P();
                }
                case "minecraft:cactus": {
                    return Blocks.field_196685_eC.func_176223_P();
                }
                default: {
                    return state;
                }
            }
        }
        return state;
    };
    public static final IStateFixer FIXER_NOTE_BLOCK = (reader, state, pos) -> {
        CompoundNBT tag = reader.getTileEntityData(pos);
        if (tag != null) {
            state = (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NoteBlock.field_196484_b, (Comparable)Boolean.valueOf(tag.func_74767_n("powered")))).func_206870_a((Property)NoteBlock.field_196485_c, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)tag.func_74771_c("note"), (int)0, (int)24)))).func_206870_a((Property)NoteBlock.field_196483_a, (Comparable)NoteBlockInstrument.func_208087_a((BlockState)reader.func_180495_p(pos.func_177977_b())));
        }
        return state;
    };
    public static final IStateFixer FIXER_PANE = (reader, state, pos) -> {
        PaneBlock pane = (PaneBlock)state.func_177230_c();
        for (Direction side : PositionUtils.HORIZONTAL_DIRECTIONS) {
            BlockPos posAdj = pos.func_177972_a(side);
            BlockState stateAdj = reader.func_180495_p(posAdj);
            Direction sideOpposite = side.func_176734_d();
            boolean flag = stateAdj.func_224755_d((IBlockReader)reader, posAdj, sideOpposite);
            state = (BlockState)state.func_206870_a((Property)HORIZONTAL_CONNECTING_BLOCK_PROPS[side.func_176745_a()], (Comparable)Boolean.valueOf(pane.func_220112_a(stateAdj, flag)));
        }
        return state;
    };
    public static final IStateFixer FIXER_REDSTONE_REPEATER = (reader, state, pos) -> (BlockState)state.func_206870_a((Property)RepeaterBlock.field_176411_a, (Comparable)Boolean.valueOf(SchematicConversionFixers.getIsRepeaterPoweredOnSide(reader, pos, state)));
    public static final IStateFixer FIXER_REDSTONE_WIRE = (reader, state, pos) -> {
        RedstoneWireBlock wire = (RedstoneWireBlock)state.func_177230_c();
        if ((state = ((IMixinRedstoneWireBlock)wire).litematicaGetFullState(reader, state, pos)).func_206870_a((Property)RedstoneWireBlock.field_176351_O, (Comparable)Integer.valueOf(0)) == REDSTONE_WIRE_DOT) {
            state = (BlockState)REDSTONE_WIRE_CROSS.func_206870_a((Property)RedstoneWireBlock.field_176351_O, state.func_177229_b((Property)RedstoneWireBlock.field_176351_O));
        }
        return state;
    };
    public static final IStateFixer FIXER_SKULL = (reader, state, pos) -> {
        CompoundNBT tag = reader.getTileEntityData(pos);
        if (tag != null) {
            int id = MathHelper.func_76125_a((int)tag.func_74771_c("SkullType"), (int)0, (int)5);
            if (id == 2) {
                id = 3;
            } else if (id == 3) {
                id = 2;
            }
            SkullBlock.ISkullType typeOrig = ((AbstractSkullBlock)state.func_177230_c()).func_196292_N_();
            SkullBlock.Types typeFromData = SkullBlock.Types.values()[id];
            if (typeOrig != typeFromData) {
                if (typeFromData == SkullBlock.Types.SKELETON) {
                    state = Blocks.field_196703_eM.func_176223_P();
                } else if (typeFromData == SkullBlock.Types.WITHER_SKELETON) {
                    state = Blocks.field_196705_eO.func_176223_P();
                } else if (typeFromData == SkullBlock.Types.PLAYER) {
                    state = Blocks.field_196710_eS.func_176223_P();
                } else if (typeFromData == SkullBlock.Types.ZOMBIE) {
                    state = Blocks.field_196708_eQ.func_176223_P();
                } else if (typeFromData == SkullBlock.Types.CREEPER) {
                    state = Blocks.field_196714_eU.func_176223_P();
                } else if (typeFromData == SkullBlock.Types.DRAGON) {
                    state = Blocks.field_196716_eW.func_176223_P();
                }
            }
            state = (BlockState)state.func_206870_a((Property)BannerBlock.field_176448_b, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)tag.func_74771_c("Rot"), (int)0, (int)15)));
        }
        return state;
    };
    public static final IStateFixer FIXER_SKULL_WALL = (reader, state, pos) -> {
        CompoundNBT tag = reader.getTileEntityData(pos);
        if (tag != null) {
            int id = MathHelper.func_76125_a((int)tag.func_74771_c("SkullType"), (int)0, (int)5);
            if (id == 2) {
                id = 3;
            } else if (id == 3) {
                id = 2;
            }
            SkullBlock.ISkullType typeOrig = ((AbstractSkullBlock)state.func_177230_c()).func_196292_N_();
            SkullBlock.Types typeFromData = SkullBlock.Types.values()[id];
            if (typeOrig != typeFromData) {
                Direction facing = (Direction)state.func_177229_b((Property)WallSkullBlock.field_196302_a);
                if (typeFromData == SkullBlock.Types.SKELETON) {
                    state = Blocks.field_196701_eL.func_176223_P();
                } else if (typeFromData == SkullBlock.Types.WITHER_SKELETON) {
                    state = Blocks.field_196704_eN.func_176223_P();
                } else if (typeFromData == SkullBlock.Types.PLAYER) {
                    state = Blocks.field_196709_eR.func_176223_P();
                } else if (typeFromData == SkullBlock.Types.ZOMBIE) {
                    state = Blocks.field_196707_eP.func_176223_P();
                } else if (typeFromData == SkullBlock.Types.CREEPER) {
                    state = Blocks.field_196712_eT.func_176223_P();
                } else if (typeFromData == SkullBlock.Types.DRAGON) {
                    state = Blocks.field_196715_eV.func_176223_P();
                }
                state = (BlockState)state.func_206870_a((Property)WallSkullBlock.field_196302_a, (Comparable)facing);
            }
        }
        return state;
    };
    public static final IStateFixer FIXER_STAIRS = (reader, state, pos) -> (BlockState)state.func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)IMixinStairsBlock.invokeGetStairShape(state, reader, pos));
    public static final IStateFixer FIXER_STEM = (reader, state, pos) -> {
        StemBlock stem = (StemBlock)state.func_177230_c();
        StemGrownBlock crop = stem.func_208486_d();
        for (Direction side : PositionUtils.HORIZONTAL_DIRECTIONS) {
            BlockPos posAdj = pos.func_177972_a(side);
            BlockState stateAdj = reader.func_180495_p(posAdj);
            Block blockAdj = stateAdj.func_177230_c();
            if (blockAdj != crop && (stem != Blocks.field_150393_bb || blockAdj != Blocks.field_196625_cS)) continue;
            return (BlockState)crop.func_196523_e().func_176223_P().func_206870_a((Property)AttachedStemBlock.field_196280_a, (Comparable)side);
        }
        return state;
    };
    public static final IStateFixer FIXER_TRIPWIRE = (reader, state, pos) -> {
        TripWireBlock wire = (TripWireBlock)state.func_177230_c();
        return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)TripWireBlock.field_176296_O, (Comparable)Boolean.valueOf(wire.func_196536_a(reader.func_180495_p(pos.func_177978_c()), Direction.NORTH)))).func_206870_a((Property)TripWireBlock.field_176289_Q, (Comparable)Boolean.valueOf(wire.func_196536_a(reader.func_180495_p(pos.func_177968_d()), Direction.SOUTH)))).func_206870_a((Property)TripWireBlock.field_176292_R, (Comparable)Boolean.valueOf(wire.func_196536_a(reader.func_180495_p(pos.func_177976_e()), Direction.WEST)))).func_206870_a((Property)TripWireBlock.field_176291_P, (Comparable)Boolean.valueOf(wire.func_196536_a(reader.func_180495_p(pos.func_177974_f()), Direction.EAST)));
    };
    public static final IStateFixer FIXER_VINE = (reader, state, pos) -> {
        VineBlock vine = (VineBlock)state.func_177230_c();
        return (BlockState)state.func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(((IMixinVineBlock)vine).invokeShouldConnectUp(reader, pos.func_177984_a(), Direction.UP)));
    };

    private static boolean getIsRepeaterPoweredOnSide(IBlockReader reader, BlockPos pos, BlockState stateRepeater) {
        Direction facing = (Direction)stateRepeater.func_177229_b((Property)RepeaterBlock.field_185512_D);
        Direction sideLeft = facing.func_176735_f();
        Direction sideRight = facing.func_176746_e();
        return SchematicConversionFixers.getRepeaterPowerOnSide(reader, pos.func_177972_a(sideLeft), sideLeft) > 0 || SchematicConversionFixers.getRepeaterPowerOnSide(reader, pos.func_177972_a(sideRight), sideRight) > 0;
    }

    private static int getRepeaterPowerOnSide(IBlockReader reader, BlockPos pos, Direction side) {
        BlockState state = reader.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (RedstoneDiodeBlock.func_185546_B((BlockState)state)) {
            if (block == Blocks.field_150451_bX) {
                return 15;
            }
            return block == Blocks.field_150488_af ? ((Integer)state.func_177229_b((Property)RedstoneWireBlock.field_176351_O)).intValue() : state.func_185893_b(reader, pos, side);
        }
        return 0;
    }

    public static interface IStateFixer {
        public BlockState fixState(IBlockReaderWithData var1, BlockState var2, BlockPos var3);
    }
}

