/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.data.SchematicHolder;
import fi.dy.masa.litematica.gui.GuiSchematicSave;
import fi.dy.masa.litematica.scheduler.TaskScheduler;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.scheduler.tasks.TaskDeleteArea;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicDirect;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicSetblock;
import fi.dy.masa.litematica.scheduler.tasks.TaskSaveSchematic;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.schematic.projects.SchematicProject;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextInput;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.interfaces.IStringConsumerFeedback;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class SchematicUtils {
    private static long areaMovedTime;

    public static boolean saveSchematic(boolean inMemoryOnly) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null) {
            if (DataManager.getSchematicProjectsManager().hasProjectOpen()) {
                String title = "litematica.gui.title.schematic_projects.save_new_version";
                SchematicProject project = DataManager.getSchematicProjectsManager().getCurrentProject();
                GuiTextInput gui = new GuiTextInput(512, title, project.getCurrentVersionName(), GuiUtils.getCurrentScreen(), (IStringConsumerFeedback)new SchematicVersionCreator());
                GuiBase.openGui((Screen)gui);
            } else if (inMemoryOnly) {
                String title = "litematica.gui.title.create_in_memory_schematic";
                GuiTextInput gui = new GuiTextInput(512, title, area.getName(), GuiUtils.getCurrentScreen(), (IStringConsumer)new GuiSchematicSave.InMemorySchematicCreator(area));
                GuiBase.openGui((Screen)gui);
            } else {
                GuiSchematicSave gui = new GuiSchematicSave();
                gui.setParent(GuiUtils.getCurrentScreen());
                GuiBase.openGui((Screen)gui);
            }
            return true;
        }
        return false;
    }

    public static void unloadCurrentlySelectedSchematic() {
        SchematicPlacement placement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
        if (placement != null) {
            SchematicHolder.getInstance().removeSchematic(placement.getSchematic());
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_placement_selected", (Object[])new Object[0]);
        }
    }

    public static boolean breakSchematicBlock(Minecraft mc) {
        return SchematicUtils.setTargetedSchematicBlockState(mc, Blocks.field_150350_a.func_176223_P());
    }

    public static boolean placeSchematicBlock(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            BlockPos pos = info.pos.func_177972_a(info.side);
            if (DataManager.getRenderLayerRange().isPositionWithinRange(pos)) {
                return SchematicUtils.setTargetedSchematicBlockState(pos, info.stateNew);
            }
        }
        return false;
    }

    public static boolean replaceSchematicBlocksInDirection(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            Direction playerFacingH = mc.field_71439_g.func_174811_aO();
            Direction direction = fi.dy.masa.malilib.util.PositionUtils.getTargetedDirection((Direction)info.side, (Direction)playerFacingH, (BlockPos)info.pos, (Vector3d)info.hitVec);
            if (direction == info.side) {
                direction = direction.func_176734_d();
            }
            BlockPos posEnd = SchematicUtils.getReplacementBoxEndPos(info.pos, direction);
            return SchematicUtils.setSchematicBlockStates(info.pos, posEnd, info.stateNew);
        }
        return false;
    }

    public static boolean replaceAllIdenticalSchematicBlocks(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            return SchematicUtils.setAllIdenticalSchematicBlockStates(info.pos, info.stateOriginal, info.stateNew);
        }
        return false;
    }

    public static boolean breakSchematicBlocks(Minecraft mc) {
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getSchematicWorldTraceWrapperIfClosest((World)mc.field_71441_e, (Entity)mc.field_71439_g, 10.0);
        if (wrapper != null && wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            BlockRayTraceResult trace = wrapper.getBlockHitResult();
            BlockPos pos = trace.func_216350_a();
            Direction playerFacingH = mc.field_71439_g.func_174811_aO();
            Direction direction = fi.dy.masa.malilib.util.PositionUtils.getTargetedDirection((Direction)trace.func_216354_b(), (Direction)playerFacingH, (BlockPos)pos, (Vector3d)trace.func_216347_e());
            if (direction == trace.func_216354_b()) {
                direction = direction.func_176734_d();
            }
            BlockPos posEnd = SchematicUtils.getReplacementBoxEndPos(pos, direction);
            return SchematicUtils.setSchematicBlockStates(pos, posEnd, Blocks.field_150350_a.func_176223_P());
        }
        return false;
    }

    public static boolean breakAllIdenticalSchematicBlocks(Minecraft mc) {
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getSchematicWorldTraceWrapperIfClosest((World)mc.field_71441_e, (Entity)mc.field_71439_g, 10.0);
        if (wrapper != null && wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            BlockRayTraceResult trace = wrapper.getBlockHitResult();
            BlockPos pos = trace.func_216350_a();
            BlockState stateOriginal = SchematicWorldHandler.getSchematicWorld().func_180495_p(pos);
            return SchematicUtils.setAllIdenticalSchematicBlockStates(pos, stateOriginal, Blocks.field_150350_a.func_176223_P());
        }
        return false;
    }

    public static boolean placeSchematicBlocksInDirection(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            Direction playerFacingH = mc.field_71439_g.func_174811_aO();
            Direction direction = fi.dy.masa.malilib.util.PositionUtils.getTargetedDirection((Direction)info.side, (Direction)playerFacingH, (BlockPos)info.pos, (Vector3d)info.hitVec);
            BlockPos posStart = info.pos.func_177972_a(info.side);
            if (SchematicWorldHandler.getSchematicWorld().func_180495_p(posStart).func_196958_f()) {
                BlockPos posEnd = SchematicUtils.getReplacementBoxEndPos(posStart, direction);
                return SchematicUtils.setSchematicBlockStates(posStart, posEnd, info.stateNew);
            }
        }
        return false;
    }

    public static boolean breakAllSchematicBlocksExceptTargeted(Minecraft mc) {
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getSchematicWorldTraceWrapperIfClosest((World)mc.field_71441_e, (Entity)mc.field_71439_g, 10.0);
        if (wrapper != null && wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            BlockRayTraceResult trace = wrapper.getBlockHitResult();
            BlockPos pos = trace.func_216350_a();
            BlockState stateOriginal = SchematicWorldHandler.getSchematicWorld().func_180495_p(pos);
            return SchematicUtils.setAllStatesToAirExcept(pos, stateOriginal);
        }
        return false;
    }

    public static boolean fillAirWithBlocks(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            BlockPos posStart = info.pos.func_177972_a(info.side);
            if (SchematicWorldHandler.getSchematicWorld().func_180495_p(posStart).func_196958_f()) {
                return SchematicUtils.setAllIdenticalSchematicBlockStates(posStart, Blocks.field_150350_a.func_176223_P(), info.stateNew);
            }
        }
        return false;
    }

    @Nullable
    private static ReplacementInfo getTargetInfo(Minecraft mc) {
        ItemStack stack = mc.field_71439_g.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem || stack.func_190926_b() && ToolMode.REBUILD.getPrimaryBlock() != null) {
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            RayTraceUtils.RayTraceWrapper traceWrapper = RayTraceUtils.getGenericTrace((World)mc.field_71441_e, (Entity)mc.field_71439_g, 10.0, true);
            if (worldSchematic != null && traceWrapper != null && traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
                BlockRayTraceResult trace = traceWrapper.getBlockHitResult();
                Direction side = trace.func_216354_b();
                Vector3d hitVec = trace.func_216347_e();
                BlockPos pos = trace.func_216350_a();
                BlockState stateOriginal = worldSchematic.func_180495_p(pos);
                BlockState stateNew = Blocks.field_150350_a.func_176223_P();
                if (stack.func_77973_b() instanceof BlockItem) {
                    World worldClient = mc.field_71439_g.field_70170_p;
                    mc.field_71439_g.field_70170_p = worldSchematic;
                    BlockRayTraceResult hit = new BlockRayTraceResult(trace.func_216347_e(), side, pos.func_177972_a(side), false);
                    BlockItemUseContext ctx = new BlockItemUseContext(new ItemUseContext((PlayerEntity)mc.field_71439_g, Hand.MAIN_HAND, hit));
                    mc.field_71439_g.field_70170_p = worldClient;
                    stateNew = ((BlockItem)stack.func_77973_b()).func_179223_d().func_196258_a(ctx);
                } else if (ToolMode.REBUILD.getPrimaryBlock() != null) {
                    stateNew = ToolMode.REBUILD.getPrimaryBlock();
                }
                return new ReplacementInfo(pos, side, hitVec, stateOriginal, stateNew);
            }
        }
        return null;
    }

    private static BlockPos getReplacementBoxEndPos(BlockPos startPos, Direction direction) {
        return SchematicUtils.getReplacementBoxEndPos(startPos, direction, 10000);
    }

    private static BlockPos getReplacementBoxEndPos(BlockPos startPos, Direction direction, int maxBlocks) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        LayerRange range = DataManager.getRenderLayerRange();
        BlockState stateStart = world.func_180495_p(startPos);
        BlockPos.Mutable posMutable = new BlockPos.Mutable();
        posMutable.func_189533_g((Vector3i)startPos);
        while (maxBlocks-- > 0) {
            posMutable.func_189536_c(direction);
            if (range.isPositionWithinRange((BlockPos)posMutable) && world.getChunkProvider().func_73149_a(posMutable.func_177958_n() >> 4, posMutable.func_177952_p() >> 4) && world.func_180495_p((BlockPos)posMutable) == stateStart) continue;
            posMutable.func_189536_c(direction.func_176734_d());
            break;
        }
        return posMutable.func_185334_h();
    }

    public static boolean setTargetedSchematicBlockState(Minecraft mc, BlockState state) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        RayTraceUtils.RayTraceWrapper traceWrapper = RayTraceUtils.getGenericTrace((World)mc.field_71441_e, (Entity)mc.field_71439_g, 6.0, true);
        if (world != null && traceWrapper != null && traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            BlockRayTraceResult trace = traceWrapper.getBlockHitResult();
            BlockPos pos = trace.func_216350_a();
            return SchematicUtils.setTargetedSchematicBlockState(pos, state);
        }
        return false;
    }

    private static boolean setTargetedSchematicBlockState(BlockPos pos, BlockState state) {
        if (pos != null) {
            SubChunkPos cpos = new SubChunkPos(pos);
            List<SchematicPlacementManager.PlacementPart> list = DataManager.getSchematicPlacementManager().getAllPlacementsTouchingSubChunk(cpos);
            if (!list.isEmpty()) {
                for (SchematicPlacementManager.PlacementPart part : list) {
                    if (!part.getBox().containsPos((Vector3i)pos)) continue;
                    SchematicPlacement placement = part.getPlacement();
                    String regionName = part.getSubRegionName();
                    LitematicaBlockStateContainer container = placement.getSchematic().getSubRegionContainer(regionName);
                    BlockPos posSchematic = SchematicUtils.getSchematicContainerPositionFromWorldPosition(pos, placement.getSchematic(), regionName, placement, placement.getRelativeSubRegionPlacement(regionName), container);
                    if (posSchematic != null) {
                        state = SchematicUtils.getUntransformedBlockState(state, placement, regionName);
                        BlockState stateOriginal = container.get(posSchematic.func_177958_n(), posSchematic.func_177956_o(), posSchematic.func_177952_p());
                        int totalBlocks = part.getPlacement().getSchematic().getMetadata().getTotalBlocks();
                        int increment = 0;
                        increment = !stateOriginal.func_196958_f() ? (!state.func_196958_f() ? 0 : -1) : (!state.func_196958_f() ? 1 : 0);
                        container.set(posSchematic.func_177958_n(), posSchematic.func_177956_o(), posSchematic.func_177952_p(), state);
                        part.getPlacement().getSchematic().getMetadata().setTotalBlocks(totalBlocks += increment);
                        DataManager.getSchematicPlacementManager().markChunkForRebuild(new ChunkPos(cpos.func_177958_n(), cpos.func_177952_p()));
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean setSchematicBlockStates(BlockPos posStart, BlockPos posEnd, BlockState state) {
        if (posStart != null && posEnd != null) {
            SubChunkPos cpos = new SubChunkPos(posStart);
            List<SchematicPlacementManager.PlacementPart> list = DataManager.getSchematicPlacementManager().getAllPlacementsTouchingSubChunk(cpos);
            if (!list.isEmpty()) {
                for (SchematicPlacementManager.PlacementPart part : list) {
                    if (!part.getBox().containsPos((Vector3i)posStart)) continue;
                    SchematicPlacement placement = part.getPlacement();
                    String regionName = part.getSubRegionName();
                    LitematicaBlockStateContainer container = placement.getSchematic().getSubRegionContainer(regionName);
                    BlockPos posStartSchematic = SchematicUtils.getSchematicContainerPositionFromWorldPosition(posStart, placement.getSchematic(), regionName, placement, placement.getRelativeSubRegionPlacement(regionName), container);
                    BlockPos posEndSchematic = SchematicUtils.getSchematicContainerPositionFromWorldPosition(posEnd, placement.getSchematic(), regionName, placement, placement.getRelativeSubRegionPlacement(regionName), container);
                    if (posStartSchematic != null && posEndSchematic != null) {
                        BlockPos posMin = PositionUtils.getMinCorner(posStartSchematic, posEndSchematic);
                        BlockPos posMax = PositionUtils.getMaxCorner(posStartSchematic, posEndSchematic);
                        int minX = Math.max(posMin.func_177958_n(), 0);
                        int minY = Math.max(posMin.func_177956_o(), 0);
                        int minZ = Math.max(posMin.func_177952_p(), 0);
                        int maxX = Math.min(posMax.func_177958_n(), container.getSize().func_177958_n() - 1);
                        int maxY = Math.min(posMax.func_177956_o(), container.getSize().func_177956_o() - 1);
                        int maxZ = Math.min(posMax.func_177952_p(), container.getSize().func_177952_p() - 1);
                        int totalBlocks = part.getPlacement().getSchematic().getMetadata().getTotalBlocks();
                        int increment = 0;
                        state = SchematicUtils.getUntransformedBlockState(state, placement, regionName);
                        for (int y = minY; y <= maxY; ++y) {
                            for (int z = minZ; z <= maxZ; ++z) {
                                for (int x = minX; x <= maxX; ++x) {
                                    BlockState stateOriginal = container.get(x, y, z);
                                    increment = !stateOriginal.func_196958_f() ? (!state.func_196958_f() ? 0 : -1) : (!state.func_196958_f() ? 1 : 0);
                                    totalBlocks += increment;
                                    container.set(x, y, z, state);
                                }
                            }
                        }
                        part.getPlacement().getSchematic().getMetadata().setTotalBlocks(totalBlocks);
                        DataManager.getSchematicPlacementManager().markAllPlacementsOfSchematicForRebuild(placement.getSchematic());
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean setAllIdenticalSchematicBlockStates(BlockPos posStart, BlockState stateOriginal, BlockState stateNew) {
        if (posStart != null) {
            SubChunkPos cpos = new SubChunkPos(posStart);
            SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
            List<SchematicPlacementManager.PlacementPart> list = manager.getAllPlacementsTouchingSubChunk(cpos);
            if (!list.isEmpty()) {
                for (SchematicPlacementManager.PlacementPart part : list) {
                    if (!part.getBox().containsPos((Vector3i)posStart)) continue;
                    if (SchematicUtils.replaceAllIdenticalBlocks(manager, part, stateOriginal, stateNew)) {
                        manager.markAllPlacementsOfSchematicForRebuild(part.getPlacement().getSchematic());
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean setAllStatesToAirExcept(BlockPos pos, BlockState state) {
        if (pos != null) {
            SubChunkPos cpos = new SubChunkPos(pos);
            SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
            List<SchematicPlacementManager.PlacementPart> list = manager.getAllPlacementsTouchingSubChunk(cpos);
            if (!list.isEmpty()) {
                for (SchematicPlacementManager.PlacementPart part : list) {
                    if (!part.getBox().containsPos((Vector3i)pos)) continue;
                    if (SchematicUtils.setAllStatesToAirExcept(manager, part, state)) {
                        manager.markAllPlacementsOfSchematicForRebuild(part.getPlacement().getSchematic());
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean setAllStatesToAirExcept(SchematicPlacementManager manager, SchematicPlacementManager.PlacementPart part, BlockState state) {
        SchematicPlacement schematicPlacement = part.getPlacement();
        String selected = schematicPlacement.getSelectedSubRegionName();
        ArrayList<String> regions = new ArrayList<String>();
        BlockState air = Blocks.field_150350_a.func_176223_P();
        if (selected != null) {
            regions.add(selected);
        } else if (manager.getSelectedSchematicPlacement() == schematicPlacement) {
            regions.addAll((Collection<String>)schematicPlacement.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED).keySet());
        } else {
            InfoUtils.showInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)20000, (String)"litematica.message.warn.schematic_rebuild_placement_not_selected", (Object[])new Object[0]);
            return false;
        }
        LayerRange range = DataManager.getRenderLayerRange();
        int totalBlocks = schematicPlacement.getSchematic().getMetadata().getTotalBlocks();
        for (String regionName : regions) {
            LitematicaBlockStateContainer container = schematicPlacement.getSchematic().getSubRegionContainer(regionName);
            SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(regionName);
            if (container == null || placement == null) continue;
            int minX = range.getClampedValue(LayerRange.getWorldMinValueForAxis((Direction.Axis)Direction.Axis.X), Direction.Axis.X);
            int minY = range.getClampedValue(LayerRange.getWorldMinValueForAxis((Direction.Axis)Direction.Axis.Y), Direction.Axis.Y);
            int minZ = range.getClampedValue(LayerRange.getWorldMinValueForAxis((Direction.Axis)Direction.Axis.Z), Direction.Axis.Z);
            int maxX = range.getClampedValue(LayerRange.getWorldMaxValueForAxis((Direction.Axis)Direction.Axis.X), Direction.Axis.X);
            int maxY = range.getClampedValue(LayerRange.getWorldMaxValueForAxis((Direction.Axis)Direction.Axis.Y), Direction.Axis.Y);
            int maxZ = range.getClampedValue(LayerRange.getWorldMaxValueForAxis((Direction.Axis)Direction.Axis.Z), Direction.Axis.Z);
            BlockPos posStart = new BlockPos(minX, minY, minZ);
            BlockPos posEnd = new BlockPos(maxX, maxY, maxZ);
            BlockPos pos1 = SchematicUtils.getReverserTransformedWorldPosition(posStart, schematicPlacement.getSchematic(), regionName, schematicPlacement, schematicPlacement.getRelativeSubRegionPlacement(regionName));
            BlockPos pos2 = SchematicUtils.getReverserTransformedWorldPosition(posEnd, schematicPlacement.getSchematic(), regionName, schematicPlacement, schematicPlacement.getRelativeSubRegionPlacement(regionName));
            if (pos1 == null || pos2 == null) {
                return false;
            }
            BlockPos posStartWorld = PositionUtils.getMinCorner(pos1, pos2);
            BlockPos posEndWorld = PositionUtils.getMaxCorner(pos1, pos2);
            Vector3i size = container.getSize();
            int startX = Math.max(posStartWorld.func_177958_n(), 0);
            int startY = Math.max(posStartWorld.func_177956_o(), 0);
            int startZ = Math.max(posStartWorld.func_177952_p(), 0);
            int endX = Math.min(posEndWorld.func_177958_n(), size.func_177958_n() - 1);
            int endY = Math.min(posEndWorld.func_177956_o(), size.func_177956_o() - 1);
            int endZ = Math.min(posEndWorld.func_177952_p(), size.func_177952_p() - 1);
            if (endX >= size.func_177958_n() || endY >= size.func_177956_o() || endZ >= size.func_177952_p()) {
                System.out.printf("OUT OF BOUNDS == region: %s, sx: %d, sy: %s, sz: %d, ex: %d, ey: %d, ez: %d - size x: %d y: %d z: %d =============\n", regionName, startX, startY, startZ, endX, endY, endZ, size.func_177958_n(), size.func_177956_o(), size.func_177952_p());
                return false;
            }
            BlockState stateOriginal = SchematicUtils.getUntransformedBlockState(state, schematicPlacement, regionName);
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    for (int x = startX; x <= endX; ++x) {
                        BlockState oldState = container.get(x, y, z);
                        if (oldState == stateOriginal || oldState.func_196958_f()) continue;
                        container.set(x, y, z, air);
                        --totalBlocks;
                    }
                }
            }
        }
        schematicPlacement.getSchematic().getMetadata().setTotalBlocks(totalBlocks);
        return true;
    }

    private static boolean replaceAllIdenticalBlocks(SchematicPlacementManager manager, SchematicPlacementManager.PlacementPart part, BlockState stateOriginalIn, BlockState stateNewIn) {
        SchematicPlacement schematicPlacement = part.getPlacement();
        String selected = schematicPlacement.getSelectedSubRegionName();
        ArrayList<String> regions = new ArrayList<String>();
        if (selected != null) {
            regions.add(selected);
        } else if (manager.getSelectedSchematicPlacement() == schematicPlacement) {
            regions.addAll((Collection<String>)schematicPlacement.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED).keySet());
        } else {
            InfoUtils.showInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)20000, (String)"litematica.message.warn.schematic_rebuild_placement_not_selected", (Object[])new Object[0]);
            return false;
        }
        LayerRange range = DataManager.getRenderLayerRange();
        int totalBlocks = schematicPlacement.getSchematic().getMetadata().getTotalBlocks();
        int increment = 0;
        increment = !stateOriginalIn.func_196958_f() ? (!stateNewIn.func_196958_f() ? 0 : -1) : (!stateNewIn.func_196958_f() ? 1 : 0);
        for (String regionName : regions) {
            LitematicaBlockStateContainer container = schematicPlacement.getSchematic().getSubRegionContainer(regionName);
            SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(regionName);
            if (container == null || placement == null) continue;
            int minX = range.getClampedValue(LayerRange.getWorldMinValueForAxis((Direction.Axis)Direction.Axis.X), Direction.Axis.X);
            int minY = range.getClampedValue(LayerRange.getWorldMinValueForAxis((Direction.Axis)Direction.Axis.Y), Direction.Axis.Y);
            int minZ = range.getClampedValue(LayerRange.getWorldMinValueForAxis((Direction.Axis)Direction.Axis.Z), Direction.Axis.Z);
            int maxX = range.getClampedValue(LayerRange.getWorldMaxValueForAxis((Direction.Axis)Direction.Axis.X), Direction.Axis.X);
            int maxY = range.getClampedValue(LayerRange.getWorldMaxValueForAxis((Direction.Axis)Direction.Axis.Y), Direction.Axis.Y);
            int maxZ = range.getClampedValue(LayerRange.getWorldMaxValueForAxis((Direction.Axis)Direction.Axis.Z), Direction.Axis.Z);
            BlockPos posStart = new BlockPos(minX, minY, minZ);
            BlockPos posEnd = new BlockPos(maxX, maxY, maxZ);
            BlockPos pos1 = SchematicUtils.getReverserTransformedWorldPosition(posStart, schematicPlacement.getSchematic(), regionName, schematicPlacement, schematicPlacement.getRelativeSubRegionPlacement(regionName));
            BlockPos pos2 = SchematicUtils.getReverserTransformedWorldPosition(posEnd, schematicPlacement.getSchematic(), regionName, schematicPlacement, schematicPlacement.getRelativeSubRegionPlacement(regionName));
            if (pos1 == null || pos2 == null) {
                return false;
            }
            BlockPos posStartWorld = PositionUtils.getMinCorner(pos1, pos2);
            BlockPos posEndWorld = PositionUtils.getMaxCorner(pos1, pos2);
            Vector3i size = container.getSize();
            int startX = Math.max(posStartWorld.func_177958_n(), 0);
            int startY = Math.max(posStartWorld.func_177956_o(), 0);
            int startZ = Math.max(posStartWorld.func_177952_p(), 0);
            int endX = Math.min(posEndWorld.func_177958_n(), size.func_177958_n() - 1);
            int endY = Math.min(posEndWorld.func_177956_o(), size.func_177956_o() - 1);
            int endZ = Math.min(posEndWorld.func_177952_p(), size.func_177952_p() - 1);
            if (startX < 0 || startY < 0 || startZ < 0 || endX >= size.func_177958_n() || endY >= size.func_177956_o() || endZ >= size.func_177952_p()) {
                System.out.printf("OUT OF BOUNDS == region: %s, sx: %d, sy: %s, sz: %d, ex: %d, ey: %d, ez: %d - size x: %d y: %d z: %d =============\n", regionName, startX, startY, startZ, endX, endY, endZ, size.func_177958_n(), size.func_177956_o(), size.func_177952_p());
                return false;
            }
            BlockState stateOriginal = SchematicUtils.getUntransformedBlockState(stateOriginalIn, schematicPlacement, regionName);
            BlockState stateNew = SchematicUtils.getUntransformedBlockState(stateNewIn, schematicPlacement, regionName);
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    for (int x = startX; x <= endX; ++x) {
                        if (container.get(x, y, z) != stateOriginal) continue;
                        container.set(x, y, z, stateNew);
                        totalBlocks += increment;
                    }
                }
            }
        }
        schematicPlacement.getSchematic().getMetadata().setTotalBlocks(totalBlocks);
        return true;
    }

    public static void moveCurrentlySelectedWorldRegionToLookingDirection(int amount, PlayerEntity player, Minecraft mc) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null && area.getAllSubRegionBoxes().size() > 0) {
            BlockPos pos = area.getEffectiveOrigin().func_177967_a(EntityUtils.getClosestLookingDirection((Entity)player), amount);
            SchematicUtils.moveCurrentlySelectedWorldRegionTo(pos, mc);
        }
    }

    public static void moveCurrentlySelectedWorldRegionTo(BlockPos pos, Minecraft mc) {
        if (mc.field_71439_g == null || !mc.field_71439_g.field_71075_bZ.field_75098_d) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.generic.creative_mode_only", (Object[])new Object[0]);
            return;
        }
        TaskScheduler scheduler = TaskScheduler.getServerInstanceIfExistsOrClient();
        long currentTime = System.currentTimeMillis();
        if (currentTime - areaMovedTime < 400L || scheduler.hasTask(TaskSaveSchematic.class) || scheduler.hasTask(TaskDeleteArea.class) || scheduler.hasTask(TaskPasteSchematicSetblock.class) || scheduler.hasTask(TaskPasteSchematicDirect.class)) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.move.pending_tasks", (Object[])new Object[0]);
            return;
        }
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null && area.getAllSubRegionBoxes().size() > 0) {
            LitematicaSchematic schematic = LitematicaSchematic.createEmptySchematic(area, "");
            LitematicaSchematic.SchematicSaveInfo info = new LitematicaSchematic.SchematicSaveInfo(false, false);
            TaskSaveSchematic taskSave = new TaskSaveSchematic(schematic, area, info);
            taskSave.disableCompletionMessage();
            areaMovedTime = System.currentTimeMillis();
            taskSave.setCompletionListener(() -> {
                SchematicPlacement placement = SchematicPlacement.createFor(schematic, pos, "-", true, true);
                DataManager.getSchematicPlacementManager().addSchematicPlacement(placement, false);
                TaskDeleteArea taskDelete = new TaskDeleteArea(area.getAllSubRegionBoxes(), true);
                taskDelete.disableCompletionMessage();
                areaMovedTime = System.currentTimeMillis();
                taskDelete.setCompletionListener(() -> {
                    TaskBase taskPaste = mc.func_71356_B() ? new TaskPasteSchematicDirect(placement) : new TaskPasteSchematicSetblock(placement, false);
                    taskPaste.disableCompletionMessage();
                    areaMovedTime = System.currentTimeMillis();
                    taskPaste.setCompletionListener(() -> {
                        SchematicHolder.getInstance().removeSchematic(schematic);
                        area.moveEntireSelectionTo(pos, false);
                        areaMovedTime = System.currentTimeMillis();
                    });
                    scheduler.scheduleTask(taskPaste, 1);
                });
                scheduler.scheduleTask(taskDelete, 1);
            });
            scheduler.scheduleTask(taskSave, 1);
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_area_selected", (Object[])new Object[0]);
        }
    }

    public static void cloneSelectionArea(Minecraft mc) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null && area.getAllSubRegionBoxes().size() > 0) {
            LitematicaSchematic schematic = LitematicaSchematic.createEmptySchematic(area, mc.field_71439_g.func_200200_C_().getString());
            LitematicaSchematic.SchematicSaveInfo info = new LitematicaSchematic.SchematicSaveInfo(false, false);
            TaskSaveSchematic taskSave = new TaskSaveSchematic(schematic, area, info);
            taskSave.disableCompletionMessage();
            taskSave.setCompletionListener(() -> {
                SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
                String name = schematic.getMetadata().getName();
                BlockPos origin = RayTraceUtils.getTargetedPosition((World)mc.field_71441_e, (Entity)mc.field_71439_g, 6.0, false);
                if (origin == null) {
                    origin = new BlockPos(Math.floor(mc.field_71439_g.func_226277_ct_()), Math.floor(mc.field_71439_g.func_226278_cu_()), Math.floor(mc.field_71439_g.func_226281_cx_()));
                }
                SchematicPlacement placement = SchematicPlacement.createFor(schematic, origin, name, true, true);
                manager.addSchematicPlacement(placement, false);
                manager.setSelectedSchematicPlacement(placement);
                if (mc.field_71439_g.field_71075_bZ.field_75098_d) {
                    DataManager.setToolMode(ToolMode.PASTE_SCHEMATIC);
                }
            });
            TaskScheduler.getServerInstanceIfExistsOrClient().scheduleTask(taskSave, 10);
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_area_selected", (Object[])new Object[0]);
        }
    }

    @Nullable
    public static BlockPos getSchematicContainerPositionFromWorldPosition(BlockPos worldPos, LitematicaSchematic schematic, String regionName, SchematicPlacement schematicPlacement, SubRegionPlacement regionPlacement, LitematicaBlockStateContainer container) {
        BlockPos boxMinRel = SchematicUtils.getReverserTransformedWorldPosition(worldPos, schematic, regionName, schematicPlacement, regionPlacement);
        if (boxMinRel == null) {
            return null;
        }
        int startX = boxMinRel.func_177958_n();
        int startY = boxMinRel.func_177956_o();
        int startZ = boxMinRel.func_177952_p();
        Vector3i size = container.getSize();
        return new BlockPos(MathHelper.func_76125_a((int)startX, (int)0, (int)(size.func_177958_n() - 1)), MathHelper.func_76125_a((int)startY, (int)0, (int)(size.func_177956_o() - 1)), MathHelper.func_76125_a((int)startZ, (int)0, (int)(size.func_177952_p() - 1)));
    }

    @Nullable
    private static BlockPos getReverserTransformedWorldPosition(BlockPos worldPos, LitematicaSchematic schematic, String regionName, SchematicPlacement schematicPlacement, SubRegionPlacement regionPlacement) {
        BlockPos origin = schematicPlacement.getOrigin();
        BlockPos regionPos = regionPlacement.getPos();
        BlockPos regionSize = schematic.getAreaSize(regionName);
        if (regionSize == null) {
            return null;
        }
        BlockPos posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((Vector3i)regionSize).func_177971_a((Vector3i)regionPos);
        BlockPos posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        BlockPos regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos relPos = new BlockPos(worldPos.func_177958_n() - origin.func_177958_n() - regionPosTransformed.func_177958_n(), worldPos.func_177956_o() - origin.func_177956_o() - regionPosTransformed.func_177956_o(), worldPos.func_177952_p() - origin.func_177952_p() - regionPosTransformed.func_177952_p());
        relPos = PositionUtils.getReverseTransformedBlockPos(relPos, regionPlacement.getMirror(), regionPlacement.getRotation());
        relPos = PositionUtils.getReverseTransformedBlockPos(relPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        relPos = relPos.func_177973_b((Vector3i)posMinRel.func_177973_b((Vector3i)regionPos));
        return relPos;
    }

    public static BlockState getUntransformedBlockState(BlockState state, SchematicPlacement schematicPlacement, String subRegionName) {
        SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(subRegionName);
        if (placement != null) {
            Rotation rotationCombined = PositionUtils.getReverseRotation(schematicPlacement.getRotation().func_185830_a(placement.getRotation()));
            Mirror mirrorMain = schematicPlacement.getMirror();
            Mirror mirrorSub = placement.getMirror();
            if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
                Mirror mirror = mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
            }
            if (rotationCombined != Rotation.NONE) {
                state = state.func_185907_a(rotationCombined);
            }
            if (mirrorSub != Mirror.NONE) {
                state = state.func_185902_a(mirrorSub);
            }
            if (mirrorMain != Mirror.NONE) {
                state = state.func_185902_a(mirrorMain);
            }
        }
        return state;
    }

    public static class SchematicVersionCreator
    implements IStringConsumerFeedback {
        public boolean setString(String string) {
            return DataManager.getSchematicProjectsManager().commitNewVersion(string);
        }
    }

    private static class ReplacementInfo {
        public final BlockPos pos;
        public final Direction side;
        public final Vector3d hitVec;
        public final BlockState stateOriginal;
        public final BlockState stateNew;

        public ReplacementInfo(BlockPos pos, Direction side, Vector3d hitVec, BlockState stateOriginal, BlockState stateNew) {
            this.pos = pos;
            this.side = side;
            this.hitVec = hitVec;
            this.stateOriginal = stateOriginal;
            this.stateNew = stateNew;
        }
    }
}

