/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;

public class ChunkSchematic
extends Chunk {
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private final long timeCreated;
    private boolean isEmpty = true;

    public ChunkSchematic(World worldIn, ChunkPos pos) {
        super(worldIn, pos, new BiomeContainer((IObjectIntIterable)worldIn.func_241828_r().func_243612_b(Registry.field_239720_u_), (Biome[])Util.func_200696_a((Object)new Biome[BiomeContainer.field_227049_a_], biomes -> Arrays.fill(biomes, BiomeRegistry.field_244200_a))));
        this.timeCreated = worldIn.func_82737_E();
    }

    public BlockState func_180495_p(BlockPos pos) {
        ChunkSection chunkSection;
        int x = pos.func_177958_n() & 0xF;
        int y = pos.func_177956_o();
        int z = pos.func_177952_p() & 0xF;
        int cy = y >> 4;
        ChunkSection[] sections = this.func_76587_i();
        if (cy >= 0 && cy < sections.length && !ChunkSection.func_222628_a((ChunkSection)(chunkSection = sections[cy]))) {
            return chunkSection.func_177485_a(x, y & 0xF, z);
        }
        return AIR;
    }

    public BlockState func_177436_a(BlockPos pos, BlockState state, boolean isMoving) {
        TileEntity te;
        BlockState stateOld = this.func_180495_p(pos);
        if (stateOld == state) {
            return null;
        }
        int x = pos.func_177958_n() & 0xF;
        int y = pos.func_177956_o();
        int z = pos.func_177952_p() & 0xF;
        Block blockNew = state.func_177230_c();
        Block blockOld = stateOld.func_177230_c();
        ChunkSection section = this.func_76587_i()[y >> 4];
        if (section == field_186036_a) {
            if (state.func_196958_f()) {
                return null;
            }
            this.func_76587_i()[y >> 4] = section = new ChunkSection(y & 0xF0);
        }
        if (!state.func_196958_f()) {
            this.isEmpty = false;
        }
        section.func_222629_a(x, y & 0xF, z, state);
        if (blockOld != blockNew) {
            // empty if block
        }
        if (section.func_177485_a(x, y & 0xF, z).func_177230_c() != blockNew) {
            return null;
        }
        if (blockOld.func_235695_q_() && (te = this.func_177424_a(pos, Chunk.CreateEntityType.CHECK)) != null) {
            te.func_145836_u();
        }
        if (blockNew.func_235695_q_() && blockNew instanceof ITileEntityProvider) {
            te = this.func_177424_a(pos, Chunk.CreateEntityType.CHECK);
            if (te == null) {
                te = ((ITileEntityProvider)blockNew).func_196283_a_((IBlockReader)this.func_177412_p());
            }
            if (te != null) {
                te.func_145836_u();
            }
        }
        this.func_76630_e();
        return stateOld;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public boolean func_76621_g() {
        return this.isEmpty;
    }
}

