/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.recipes.IngredientToRecipesMap;
import org.jetbrains.annotations.UnmodifiableView;

public class RecipeIngredientTable {
    private final Map<RecipeType<?>, IngredientToRecipesMap<?>> map = new HashMap();

    public <V> void add(V recipe, RecipeType<V> recipeType, List<String> ingredientUids) {
        IngredientToRecipesMap ingredientToRecipesMap = this.map.computeIfAbsent(recipeType, k -> new IngredientToRecipesMap());
        ingredientToRecipesMap.add(recipe, ingredientUids);
    }

    public <V> @UnmodifiableView List<V> get(RecipeType<V> recipeType, String ingredientUid) {
        IngredientToRecipesMap<?> ingredientToRecipesMap = this.map.get(recipeType);
        if (ingredientToRecipesMap == null) {
            return List.of();
        }
        return ingredientToRecipesMap.get(ingredientUid);
    }
}

